/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.map.symbol.SymbolID;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanControlsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.color.PaletteType;
import gov.nasa.giss.ui.panel.PanelSection;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanLonLatTrajectoryControls
extends PanControlsPanel {
    private ColorComboBox[] strColorCombos_ = new ColorComboBox[2];
    private DescribedEnumComboBox[] strStyleCombos_ = new DescribedEnumComboBox[2];
    private PanIntSpinner[] strWeightSpinners_ = new PanIntSpinner[2];
    private DescribedEnumComboBox[] ptSymbolCombos_ = new DescribedEnumComboBox[2];
    private FloatComboBox[] ptSymbolSizeCombos_ = new FloatComboBox[2];
    private ColorComboBox backgroundCombo_;
    private PanCheckBox skipNaNsCB_;
    private boolean refreshing_;

    public PanLonLatTrajectoryControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("trajectory-controls", pmeta, mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createTopBox());
        for (int i = 0; i < 2; ++i) {
            this.add(this.createSection(i));
        }
    }

    private JPanel createTopBox() {
        JLabel bgLabel1 = new JLabel("Background:\u2009");
        this.backgroundCombo_ = new ColorComboBox(PaletteType.GRAYSCALE);
        this.backgroundCombo_.setName("feature.background");
        this.backgroundCombo_.setSelectedColor(this.pmeta_.getColor("feature.background"));
        this.skipNaNsCB_ = PanCheckBox.small("feature.nanskip", "Skip points with NaN value", this.pmeta_.getBoolean("feature.nanskip"));
        QuickBox line1 = QuickBox.createLeftBox(bgLabel1, this.backgroundCombo_);
        QuickBox line2 = QuickBox.createLeftBox(this.skipNaNsCB_);
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        jp.setOpaque(false);
        this.add(line1);
        this.add(line2);
        GuiUtils.setSizeSmall(jp);
        return jp;
    }

    private PanelSection createSection(int idx) {
        String title = "Trajectory " + (idx + 1);
        JLabel trow1label2 = new JLabel("Point:\u2009");
        JLabel trow1label3 = new JLabel("Symbol:\u2009");
        JLabel trow1label4 = new JLabel("\u2014 Size:\u2009");
        this.ptSymbolCombos_[idx] = new DescribedEnumComboBox(SymbolID.class);
        this.ptSymbolCombos_[idx].setName(PanParamKeys.FEATURE_SYMBOL_ID[idx]);
        this.ptSymbolCombos_[idx].setSelItemMatching(this.pmeta_.getString(PanParamKeys.FEATURE_SYMBOL_ID[idx]));
        this.ptSymbolSizeCombos_[idx] = FloatComboBox.create(2.0f, 16.0f);
        this.ptSymbolSizeCombos_[idx].setName(PanParamKeys.FEATURE_SYMBOL_SIZE[idx]);
        this.ptSymbolSizeCombos_[idx].setValue(this.pmeta_.getFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[idx]));
        QuickBox row1 = QuickBox.createLeftBox(trow1label2, trow1label3, this.ptSymbolCombos_[idx], trow1label4, this.ptSymbolSizeCombos_[idx]);
        JLabel trow2Label2 = new JLabel("Stroke:\u2009");
        JLabel trow2Label3 = new JLabel("Style:\u2009");
        this.strStyleCombos_[idx] = new DescribedEnumComboBox(PanStrokePattern.class);
        this.strStyleCombos_[idx].setName(PanParamKeys.STROKE_STYLE[idx]);
        this.strStyleCombos_[idx].setSelItemMatching(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[idx]));
        QuickBox row2 = QuickBox.createLeftBox(trow2Label2, trow2Label3, this.strStyleCombos_[idx]);
        JLabel trow3label2 = new JLabel(" ");
        JLabel trow3label3 = new JLabel("Color:\u2009");
        JLabel trow3label4 = new JLabel("\u2014 Weight:\u2009");
        JLabel trow3label5 = new JLabel("%");
        this.strColorCombos_[idx] = new ColorComboBox();
        this.strColorCombos_[idx].setName(PanParamKeys.STROKE_COLOR[idx]);
        this.strColorCombos_[idx].setSelectedColor(this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[idx]));
        this.strWeightSpinners_[idx] = PanIntSpinner.smallWeightX5(PanParamKeys.STROKE_WGT[idx], this.pmeta_.getInt(PanParamKeys.STROKE_WGT[idx]), 0, 250);
        QuickBox row3 = QuickBox.createLeftBox(trow3label2, trow3label3, this.strColorCombos_[idx], trow3label4, this.strWeightSpinners_[idx], trow3label5, Box.createHorizontalStrut(12));
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        jp.setOpaque(false);
        jp.add(row1);
        jp.add(Box.createVerticalStrut(1));
        jp.add(row2);
        jp.add(Box.createVerticalStrut(1));
        jp.add(row3);
        PanelSection ws = new PanelSection(title, jp);
        GuiUtils.setSizeSmall(ws);
        GuiUtils.matchLabelWidths(trow1label2, trow2Label2, trow3label2);
        GuiUtils.matchLabelWidths(trow1label3, trow2Label3, trow3label3);
        return ws;
    }

    private void attachListeners() {
        this.backgroundCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            int index = this.backgroundCombo_.getSelectedIndex();
            if (index < 0 || index >= this.backgroundCombo_.getItemCount()) {
                return;
            }
            Color cnew = this.backgroundCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("feature.background"))) {
                this.pmeta_.setColor("feature.background", cnew);
            }
        });
        this.skipNaNsCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean checked = this.skipNaNsCB_.isSelected();
            this.pmeta_.setBoolean("feature.nanskip", checked);
        });
        int i = 0;
        while (i < 2) {
            int ii = i++;
            this.strColorCombos_[ii].addItemListener(e -> {
                Color cold;
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                int index = this.strColorCombos_[ii].getSelectedIndex();
                if (index < 0 || index >= this.strColorCombos_[ii].getItemCount()) {
                    return;
                }
                Color cnew = this.strColorCombos_[ii].getSelectedColor();
                if (!cnew.equals(cold = this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[ii]))) {
                    this.pmeta_.setColor(PanParamKeys.STROKE_COLOR[ii], cnew);
                }
            });
            this.strStyleCombos_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.STROKE_STYLE[ii], this.strStyleCombos_[ii].getEnumName());
            });
            this.strWeightSpinners_[ii].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                this.pmeta_.setInt(PanParamKeys.STROKE_WGT[ii], this.strWeightSpinners_[ii].getIntValue());
            });
            this.ptSymbolCombos_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.set(PanParamKeys.FEATURE_SYMBOL_ID[ii], this.ptSymbolCombos_[ii].getEnumName());
            });
            this.ptSymbolSizeCombos_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                this.pmeta_.setFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[ii], this.ptSymbolSizeCombos_[ii].getValue());
            });
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.backgroundCombo_.setSelectedColor(this.pmeta_.getColor("feature.background"));
        this.skipNaNsCB_.setSelected(this.pmeta_.getBoolean("feature.nanskip"));
        for (int i = 0; i < 2; ++i) {
            this.ptSymbolCombos_[i].setSelItemMatching(this.pmeta_.getString(PanParamKeys.FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeCombos_[i].setValue(this.pmeta_.getFloat(PanParamKeys.FEATURE_SYMBOL_SIZE[i]));
            this.strStyleCombos_[i].setSelItemMatching(this.pmeta_.getString(PanParamKeys.STROKE_STYLE[i]));
            this.strColorCombos_[i].setSelectedColor(this.pmeta_.getColor(PanParamKeys.STROKE_COLOR[i]));
            this.strWeightSpinners_[i].setValue(this.pmeta_.getInt(PanParamKeys.STROKE_WGT[i]));
        }
        PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
        boolean[] enable = new boolean[]{true, false};
        if (ctype == PanCombinationType.COMPARE) {
            enable[1] = true;
        } else if (ctype == PanCombinationType.A2_ONLY) {
            enable[0] = false;
            enable[1] = true;
        }
        for (int i = 0; i < 2; ++i) {
            this.ptSymbolCombos_[i].setEnabled(enable[i]);
            this.ptSymbolSizeCombos_[i].setEnabled(enable[i]);
            this.strColorCombos_[i].setEnabled(enable[i]);
            this.strStyleCombos_[i].setEnabled(enable[i]);
            this.strWeightSpinners_[i].setEnabled(enable[i]);
        }
        this.refreshing_ = false;
    }
}

