/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanFitScaleToClutAction
extends AbstractAction {
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("fit-scale-to-clut");
    private final PanPlotMeta pmeta_;
    private final PanScaleControls scaleControls_;
    private boolean busy_;

    public PanFitScaleToClutAction(PanPlotMeta pmeta, PanScaleControls scaleControls) {
        super(ACTION_NAME);
        this.pmeta_ = pmeta;
        this.scaleControls_ = scaleControls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.busy_) {
            return;
        }
        if (this.pmeta_.getBoolean("scale.autofit")) {
            return;
        }
        String clutName = this.pmeta_.getString("colorbar.name");
        AbstractColorTable clut = PanResourceUtils.getColorTable(clutName);
        if (!clut.hasRangeLimits()) {
            return;
        }
        this.busy_ = true;
        double min = clut.getRangeMinimum();
        double max = clut.getRangeMaximum();
        if (Double.isNaN(min)) {
            min = -0.1;
            max = 0.1;
        }
        PanScaleMethod smethod = PanScaleMethod.matching(this.pmeta_.getString("scale.method"));
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                if (min <= 0.0) {
                    min = 1.0E-50;
                }
                if (!(max <= 1.0E-50)) break;
                max = 1.0E-25;
                break;
            }
        }
        this.scaleControls_.setScaleRange(min, max);
        this.busy_ = false;
    }
}

