/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanDerGrinten3
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Van der Grinten III";
    public static final int PROPERTIES = 8;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.PI;
    private double rhoBorder_;
    private double rhoBorder2_;

    public VanDerGrinten3(int width, int height) {
        this(width, height, 0, 0);
    }

    public VanDerGrinten3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, Math.PI);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double absLat = Math.abs(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-5) {
            double x2 = lambdaRad;
            double y = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x2, y);
        }
        if (absLat > 89.99999) {
            double x3 = 0.0;
            double y = Math.PI;
            if (lat < 0.0) {
                y = -y;
            }
            x3 = (double)this.outCenterX_ + x3 * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x3, y);
        }
        double absPhiRad = Math.toRadians(absLat);
        double sinTheta = absPhiRad * 0.6366197723675814;
        double cosTheta = Math.sqrt(1.0 - sinTheta * sinTheta);
        double tanHalfTheta = sinTheta / (1.0 + cosTheta);
        double y = Math.PI * tanHalfTheta;
        if (Math.abs(lambdaRad) < 1.0E-5) {
            x = 0.0;
        } else {
            double a = 0.5 * Math.abs(Math.PI / lambdaRad - lambdaRad * 0.3183098861837907);
            x = Math.PI * (Math.sqrt(a * a + 1.0 - tanHalfTheta * tanHalfTheta) - a);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double absY = Math.abs(y);
        double tanHalfTheta = absY * this.invRS_ * 0.3183098861837907;
        double thetaRad = 2.0 * Math.atan(tanHalfTheta);
        double phiRad = Math.sin(thetaRad) * 1.5707963267948966;
        if (Double.isNaN(phiRad) || phiRad > 1.5707963267948966) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double absX = Math.abs(x);
        double lambdaRad = absX > 1.0E-5 && phi < 89.99999 ? VanDerGrinten3.iterateLambdaRad(absX * this.invRS_, phiRad, tanHalfTheta) : this.lambdaCRad_;
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        VanDerGrinten3 vanDerGrinten3 = this;
        synchronized (vanDerGrinten3) {
            double y;
            double tanHalfTheta;
            double thetaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.sin(thetaRad = 2.0 * Math.atan(tanHalfTheta = (y = (double)iy + 0.5) * this.invRS_ * 0.3183098861837907)) * 1.5707963267948966) > 1.5707963267948966); ++iy) {
                double lambdaRad;
                double x;
                double rho2;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; !(ix >= this.dxMax_ || (rho2 = (x = (double)ix + 0.5) * x + y * y) > this.rhoBorder2_ || (lambdaRad = phi < 89.995 ? VanDerGrinten3.iterateLambdaRad(x * this.invRS_, phiRad, tanHalfTheta) : this.lambdaCRad_) > Math.PI || Double.isNaN(lambdaRad)); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private static double iterateLambdaRad(double xOverRS, double phiRad, double tanHalfTheta) {
        double tanSqHalfTheta = tanHalfTheta * tanHalfTheta;
        double lambdaRad = xOverRS * Math.cos(phiRad);
        for (int iter = 0; iter < 33; ++iter) {
            double a = 0.5 * (Math.PI / lambdaRad - lambdaRad * 0.3183098861837907);
            double daDlambda = 0.5 * (-Math.PI / (lambdaRad * lambdaRad) - 0.3183098861837907);
            double sqrtTerm = Math.sqrt(a * a + 1.0 - tanSqHalfTheta);
            double func = Math.PI * (sqrtTerm - a) - xOverRS;
            double dfunc = Math.PI * (0.5 / sqrtTerm * 2.0 * a - 1.0) * daDlambda;
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double xlat = Math.min(maxLat, 89.99999);
        Point2D.Double dotN = this.transformLL2XY(lon, xlat);
        Point2D.Double dotS = this.transformLL2XY(lon, -xlat);
        if (dotN == null || dotS == null) {
            LOGGER.trace("got null dot at a pole for lon {}");
            return;
        }
        if (Math.abs(lambdaRad) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            if (dotEq == null) {
                return;
            }
            GraphicUtils.drawCircularArc(g2d, dotN, dotEq, dotS);
        }
    }
}

