/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RennerApian
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Renner-Apian";
    public static final int PROPERTIES = 0x4000008;
    private static final double FOUR_OVER_PI2 = 0.4052847345693511;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public RennerApian(int width, int height) {
        this(width, height, 0, 0);
    }

    public RennerApian(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x4000008, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    public boolean canLabelGrid() {
        return true;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (phiRad == 0.0) {
            x = lambdaRad;
        } else if (phiRad > 0.0) {
            double absLambdaRad = Math.abs(lambdaRad);
            double offLambdaRad = absLambdaRad - 1.5707963267948966;
            double offX = 1.5707963267948966 + offLambdaRad * Math.sqrt(1.0 - 0.4052847345693511 * phiRad * phiRad);
            x = lambdaRad < 0.0 ? -offX : offX;
        } else {
            x = lambdaRad * Math.sqrt(1.0 - 0.4052847345693511 * phiRad * phiRad);
        }
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.invRS_ / Math.sqrt(1.0 - 0.4052847345693511 * phiRad * phiRad);
        if (y > 0.0) {
            double xxx = Math.abs(x) - 1.5707963267948966 * this.rS_;
            lambdaRad = xxx * xFactor + 1.5707963267948966;
            if (lambdaRad < 0.0) {
                return null;
            }
            if (x < 0.0) {
                lambdaRad = -lambdaRad;
            }
        } else {
            lambdaRad = x * xFactor;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void calculateInverseArray() {
        double halfDxMax = 1.5707963267948966 * this.rS_;
        RennerApian rennerApian = this;
        synchronized (rennerApian) {
            int iy = -this.dyMax_;
            while (iy < this.dyMax_) {
                double lambdaRad;
                double x;
                int ix;
                double y = (double)iy + 0.5;
                double phiRad = y * this.invRS_;
                if (Math.abs(phiRad) > 1.5707963267948966) {
                    return;
                }
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / Math.sqrt(1.0 - 0.4052847345693511 * phiRad * phiRad);
                if (y > 0.0) {
                    for (ix = 0; ix < this.dxMax_; ++ix) {
                        x = (double)ix + 0.5 - halfDxMax;
                        lambdaRad = x * xFactor + 1.5707963267948966;
                        if (lambdaRad < 0.0) continue;
                        if (!(lambdaRad > Math.PI)) {
                            this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                            continue;
                        }
                        break;
                    }
                } else {
                    for (ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                        this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                    }
                }
                ++iy;
            }
            return;
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Graphics2D g2x = (Graphics2D)g2d.create();
        if (label != null && label.length() > 0) {
            double rlon = this.lambdaC_ + 179.99999;
            Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
            FontMetrics fm = g2x.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(dot2.x - (double)fh2 - (double)w);
            g2x.drawString(label, labelx, (float)(dot2.y + (double)fh2 - (double)(0.5f * (float)des)));
            Shape oldclip = g2x.getClip();
            if (oldclip == null) {
                oldclip = this.getMarginRectClose();
            }
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot2.y - (double)fh2, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2x.setClip(clipArea);
        }
        if (lat <= 0.0) {
            this.drawParallelSNoLabel(g2x, lat);
        } else {
            this.drawParallelNNoLabel(g2x, lat);
        }
        g2x.dispose();
    }

    private void drawParallelNNoLabel(Graphics2D g2d, double lat) {
        double llon1 = this.lambdaC_ - 179.99999;
        double llon2 = this.lambdaC_ - 1.0E-5;
        double rlon1 = this.lambdaC_ + 1.0E-5;
        double rlon2 = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(llon1, lat);
        Point2D.Double dot2 = this.transformLL2XY(llon2, lat);
        Point2D.Double dot3 = this.transformLL2XY(rlon1, lat);
        Point2D.Double dot4 = this.transformLL2XY(rlon2, lat);
        if (dot1 == null || dot4 == null) {
            return;
        }
        GraphicUtils.drawLine(g2d, dot1, dot2);
        GraphicUtils.drawLine(g2d, dot3, dot4);
    }

    private void drawParallelSNoLabel(Graphics2D g2d, double lat) {
        double llon = this.lambdaC_ - 179.99999;
        double rlon = this.lambdaC_ + 179.99999;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        GraphicUtils.drawLine(g2d, dot1, dot2);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        if (label == null || label.length() == 0) {
            this.drawMeridianNoLabel(g2d, lon, maxLat);
            return;
        }
        Point2D.Double dot1 = this.transformLL2XY(lon, -62.0);
        Point2D.Double dot2 = this.transformLL2XY(lon, -64.5);
        if (dot1 == null || dot2 == null) {
            return;
        }
        double xave = 0.5 * (dot1.x + dot2.x);
        float ybot = (float)dot2.y;
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(xave - 0.5 * (double)w);
        g2d.drawString(label, labelx, ybot - (float)des);
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, ybot - (float)fh, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        this.drawMeridianNoLabel(g2x, lon, maxLat);
        g2x.dispose();
    }

    private void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda < 1.0E-5) {
            Point2D.Double dotEq = this.transformLL2XYIgnoreMargins(lon, 0.0);
            Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
            GraphicUtils.drawLine(g2d, dotEq, dotS);
        } else {
            super.drawMeridian(g2d, lon, maxLat, null);
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArc(this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, this.dxMax_, 2.0 * (double)this.dyMax_, 0.0, 180.0, 0);
        g2d.draw(arc);
        arc.setArc(this.outCenterX_, this.outCenterY_ - this.dyMax_, this.dxMax_, 2.0 * (double)this.dyMax_, 0.0, 180.0, 0);
        g2d.draw(arc);
        arc.setArc(this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_, 180.0, 180.0, 0);
        g2d.draw(arc);
    }
}

