/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.img.GifWriter;
import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.img.PsDocument;
import gov.nasa.giss.img.PsGraphics2D;
import gov.nasa.giss.img.PsWriter;
import gov.nasa.giss.img.TiffWriter;
import gov.nasa.giss.math.MathUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GImageIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String JPG_EXT = "jpg";
    static final String JPEG_EXT = "jpeg";
    static final String TIF_EXT = "tif";
    static final String TIFF_EXT = "tiff";
    private static final Object SAVE_LOCK = new Object();
    private static String[] readableImageExtensions_;
    private static GifWriter gifWriter_;
    private static TiffWriter tiffWriter_;

    public static String[] getReadableImageFileExtensions() {
        if (readableImageExtensions_ != null) {
            return readableImageExtensions_;
        }
        String[] readerExts = ImageIO.getReaderFormatNames();
        ArrayList<String> formatExts = new ArrayList<String>(30);
        for (String ext : readerExts) {
            String lcExt = ext.toLowerCase();
            boolean already = false;
            for (String ext2 : formatExts) {
                if (!ext2.equals(lcExt)) continue;
                already = true;
                break;
            }
            if (already) continue;
            formatExts.add(lcExt);
        }
        boolean jpgPresent = false;
        boolean jpegPresent = false;
        boolean tifPresent = false;
        boolean tiffPresent = false;
        for (String ext : formatExts) {
            if (ext.equalsIgnoreCase(JPG_EXT)) {
                jpgPresent = true;
            } else if (ext.equalsIgnoreCase(JPEG_EXT)) {
                jpegPresent = true;
            }
            if (ext.equalsIgnoreCase(TIF_EXT)) {
                tifPresent = true;
                continue;
            }
            if (!ext.equalsIgnoreCase(TIFF_EXT)) continue;
            tiffPresent = true;
        }
        if (jpgPresent && !jpegPresent) {
            formatExts.add(JPEG_EXT);
        }
        if (jpegPresent && !jpgPresent) {
            formatExts.add(JPG_EXT);
        }
        if (tifPresent && !tiffPresent) {
            formatExts.add(TIFF_EXT);
        }
        if (tiffPresent && !tifPresent) {
            formatExts.add(TIF_EXT);
        }
        Collections.sort(formatExts);
        readableImageExtensions_ = formatExts.toArray(new String[0]);
        return readableImageExtensions_;
    }

    public static BufferedImage readBufferedImage(File f) throws FileNotFoundException, IOException {
        String lcname = f.getName().toLowerCase();
        BufferedImage bimg = null;
        if (lcname.endsWith(".jpg") || lcname.endsWith(".jpeg")) {
            ImageIcon ii = new ImageIcon(f.toURI().toURL());
            bimg = ImageUtils.toBufferedImage(ii.getImage());
        } else {
            bimg = ImageIO.read(f);
        }
        if (bimg == null) {
            throw new IllegalArgumentException("There is apparently no ImageIO reader registered for that file.");
        }
        return bimg;
    }

    public static boolean saveAsGif(File f, GPrintable plot) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        BufferedImage img = plot.getImage();
        return GImageIO.saveAsGif(f, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsGif(File f, BufferedImage img) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(img, "Image object cannot be null");
        Object object = SAVE_LOCK;
        synchronized (object) {
            if (gifWriter_ == null) {
                gifWriter_ = new GifWriter();
            }
            gifWriter_.setImage(img);
            gifWriter_.write(f);
            gifWriter_.flush();
        }
        return true;
    }

    public static boolean saveAsJpeg(File f, GPrintable plot) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        BufferedImage img = plot.getImage();
        return GImageIO.saveAsJpeg(f, img);
    }

    public static synchronized boolean saveAsJpeg(File f, BufferedImage img) throws IOException {
        return GImageIO.saveAsJpeg(f, img, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsJpeg(File f, BufferedImage img, float quality) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(img, "Image object cannot be null");
        Object object = SAVE_LOCK;
        synchronized (object) {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(JPEG_EXT);
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(quality);
            try (ImageOutputStream ios = ImageIO.createImageOutputStream(f);){
                writer.setOutput(ios);
                writer.write(null, new IIOImage(img, null, null), iwp);
                ios.flush();
                writer.dispose();
            }
        }
        return true;
    }

    public static boolean saveAsPng(File f, GPrintable plot) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        BufferedImage img = plot.getImage();
        return GImageIO.saveAsPng(f, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsPng(File f, BufferedImage img) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(img, "Image object cannot be null");
        Object object = SAVE_LOCK;
        synchronized (object) {
            ImageIO.write((RenderedImage)img, "png", f);
        }
        return true;
    }

    public static boolean saveAsTiff(File f, GPrintable plot, String software) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        BufferedImage img = plot.getImage();
        return GImageIO.saveAsTiff(f, img, software);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsTiff(File f, BufferedImage img, String software) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(img, "Image object cannot be null");
        Object object = SAVE_LOCK;
        synchronized (object) {
            if (tiffWriter_ == null) {
                tiffWriter_ = new TiffWriter();
            } else {
                tiffWriter_.flush();
            }
            tiffWriter_.setImage(img);
            if (software != null) {
                tiffWriter_.setSoftware(software);
            }
            tiffWriter_.write(f);
        }
        return true;
    }

    public static synchronized boolean saveAsPdf(File f, GPrintable plot, boolean vectorized, PaperSize psize, String sw) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        PaperSize paperSize = psize == null ? PaperSize.LETTER : psize;
        LOGGER.trace("paperSize '{}'", (Object)paperSize);
        Dimension dd = new Dimension(paperSize.widthPts(), paperSize.heightPts());
        return GImageIO.saveAsPdf(f, plot, vectorized, dd, sw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean saveAsPdf(File f, GPrintable plot, boolean vectorized, Dimension outSize, String sw) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        Objects.requireNonNull(outSize, "Output dimensions cannot be null");
        Object object = SAVE_LOCK;
        synchronized (object) {
            Dimension plotSize = plot.getSize();
            float ww = (float)outSize.getWidth();
            float hh = (float)outSize.getHeight();
            float inRatio = (float)plotSize.width / (float)plotSize.height;
            float outRatio = ww / hh;
            LOGGER.trace("in {}, ratio {}", (Object)plotSize, (Object)Float.valueOf(inRatio));
            LOGGER.trace("out {}, ratio {}", (Object)outSize, (Object)Float.valueOf(outRatio));
            boolean rotate = (double)inRatio < 1.0 && (double)outRatio > 1.0 || (double)inRatio > 1.0 && (double)outRatio < 1.0;
            LOGGER.trace("rotate {}", (Object)rotate);
            if (rotate) {
                float tmp = ww;
                ww = hh;
                hh = tmp;
            }
            float scaleX = (float)plotSize.width > ww ? ww / (float)plotSize.width : 1.0f;
            float scaleY = (float)plotSize.height > hh ? hh / (float)plotSize.height : 1.0f;
            float scale = MathUtils.min(1.0f, scaleY, scaleX);
            AffineTransform af = new AffineTransform(scale, 0.0f, 0.0f, scale, 0.5f * (ww - scale * (float)plotSize.width), 0.5f * (hh - scale * (float)plotSize.height));
            PDDocument document = new PDDocument();
            document.setVersion(1.7f);
            PDDocumentInformation pdd = document.getDocumentInformation();
            if (sw != null) {
                pdd.setCreator(sw);
            }
            pdd.setCreationDate(Calendar.getInstance());
            PdfBoxGraphics2D g2d = new PdfBoxGraphics2D(document, plotSize.width, plotSize.height);
            g2d.setClip(0, 0, plotSize.width, plotSize.height);
            if (vectorized) {
                plot.print((Graphics2D)g2d);
            } else {
                plot.paint((Graphics2D)g2d);
            }
            g2d.dispose();
            PDPage page = new PDPage(new PDRectangle(ww, hh));
            PDFormXObject xform = g2d.getXFormObject();
            PDPageContentStream contentStream = new PDPageContentStream(document, page);
            Matrix matrix = new Matrix(af);
            contentStream.transform(matrix);
            contentStream.drawForm(xform);
            contentStream.close();
            document.addPage(page);
            document.save(f);
            document.close();
            return true;
        }
    }

    public static synchronized boolean saveAsPs(File f, GPrintable plot, boolean vectorized, PaperSize psize, String title) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        PaperSize paperSize = psize == null ? PaperSize.LETTER : psize;
        LOGGER.trace("paperSize '{}'", (Object)paperSize);
        Dimension dd = new Dimension(paperSize.widthPts(), paperSize.heightPts());
        return GImageIO.saveAsPs(f, plot, vectorized, dd, title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAsPs(File f, GPrintable plot, boolean vectorized, Dimension outSize, String title) throws IOException {
        Objects.requireNonNull(f, "File cannot be null");
        Objects.requireNonNull(plot, "Plot object cannot be null");
        Objects.requireNonNull(outSize, "Output dimensions cannot be null");
        Object object = SAVE_LOCK;
        synchronized (object) {
            Dimension plotSize = plot.getSize();
            float ww = (float)outSize.getWidth();
            float hh = (float)outSize.getHeight();
            float inRatio = (float)plotSize.width / (float)plotSize.height;
            float outRatio = ww / hh;
            LOGGER.trace("in {}, ratio {}", (Object)plotSize, (Object)Float.valueOf(inRatio));
            LOGGER.trace("out {}, ratio {}", (Object)outSize, (Object)Float.valueOf(outRatio));
            boolean rotate = (double)inRatio < 1.0 && (double)outRatio > 1.0 || (double)inRatio > 1.0 && (double)outRatio < 1.0;
            LOGGER.trace("rotate {}", (Object)rotate);
            if (rotate) {
                float tmp = ww;
                ww = hh;
                hh = tmp;
            }
            float scaleX = (float)plotSize.width > ww ? ww / (float)plotSize.width : 1.0f;
            float scaleY = (float)plotSize.height > hh ? hh / (float)plotSize.height : 1.0f;
            float scale = Math.min(1.0f, Math.min(scaleY, scaleX));
            Dimension docsize = new Dimension(Math.round(ww), Math.round(hh));
            PsDocument document = new PsDocument(docsize);
            if (title != null) {
                document.setTitle(title);
            }
            new PsWriter(document, f);
            document.open();
            PsGraphics2D g2d = document.createGraphics(true);
            ((Graphics2D)g2d).translate(0.5f * (ww - scale * (float)plotSize.width), 0.5f * (hh - scale * (float)plotSize.height));
            ((Graphics2D)g2d).scale(scale, scale);
            if (vectorized) {
                plot.print(g2d);
            } else {
                plot.paint(g2d);
            }
            ((Graphics)g2d).dispose();
            document.close();
            return true;
        }
    }

    private GImageIO() {
    }
}

