/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg4.es;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.jcodec.codecs.mpeg4.es.Descriptor;
import org.jcodec.codecs.mpeg4.es.IDescriptorFactory;

public class NodeDescriptor
extends Descriptor {
    private Collection<Descriptor> children;

    public NodeDescriptor(int tag, Collection<Descriptor> children) {
        super(tag, 0);
        this.children = children;
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        for (Descriptor descr : this.children) {
            descr.write(out);
        }
    }

    public Collection<Descriptor> getChildren() {
        return this.children;
    }

    protected static NodeDescriptor parse(ByteBuffer input, IDescriptorFactory factory) {
        Descriptor d;
        ArrayList<Descriptor> children = new ArrayList<Descriptor>();
        do {
            if ((d = Descriptor.read(input, factory)) == null) continue;
            children.add(d);
        } while (d != null);
        return new NodeDescriptor(0, children);
    }

    public static <T> T find(Descriptor es, Class<T> class1, int tag) {
        if (es.getTag() == tag) {
            return (T)es;
        }
        if (es instanceof NodeDescriptor) {
            for (Descriptor descriptor : ((NodeDescriptor)es).getChildren()) {
                T res = NodeDescriptor.find(descriptor, class1, tag);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }
}

