/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.task;

import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.exc.NcForbiddenException;
import gov.nasa.giss.data.nc.exc.NcNotAuthorizedException;
import gov.nasa.giss.data.nc.exc.NcResourceNotFoundException;
import gov.nasa.giss.panoply.authentication.PanCredentialsProvider;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.ui.SlowMessage;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.Task;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;

public class PanOpenDatasetTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final Object address_;
    private String errMsg_;
    private boolean tryAgainOnEDT_;
    private NcDataset dataset_;

    public PanOpenDatasetTask(File address) {
        super("Opening local dataset");
        Objects.requireNonNull(address, "Address Filecannot be null.");
        this.address_ = address;
    }

    public PanOpenDatasetTask(URL address) {
        super("Opening dataset via URL");
        Objects.requireNonNull(address, "Address URL cannot be null.");
        this.address_ = address;
    }

    public PanOpenDatasetTask(String address) {
        super("Opening dataset via DatasetUrl");
        Objects.requireNonNull(address, "Address String cannot be null.");
        this.address_ = address;
    }

    public PanOpenDatasetTask(DatasetUrl address) {
        super("Opening dataset");
        Objects.requireNonNull(address, "Address DatasetUrl cannot be null.");
        this.address_ = address;
    }

    @Override
    protected Object beginTask() {
        LOGGER.trace("address {}", (Object)this.address_.getClass().getSimpleName());
        this.openDataset(false);
        LOGGER.trace("opened? {}", (Object)(this.dataset_ != null ? 1 : 0));
        return null;
    }

    @Override
    protected void finishTask() {
        PanSourcesFrame sourcesFrame;
        block6: {
            if (this.dataset_ == null && this.dataset_ == null && this.tryAgainOnEDT_) {
                LOGGER.trace("Making second attempt on EDT");
                this.openDataset(true);
                LOGGER.trace("Opened? {}", (Object)(this.dataset_ != null ? 1 : 0));
            }
            if (this.errMsg_ != null) {
                LOGGER.trace("Error: dataset is {}", (Object)this.dataset_);
                SlowMessage.show(null, "File Error", "There was an error opening the dataset: " + this.errMsg_);
                return;
            }
            if (this.dataset_ == null) {
                LOGGER.trace("No error msg but dataset is null");
                SlowMessage.show(null, "File Error", "Somehow got a null but not an error when trying to open the dataset. Sorry; we know that isn't very helpful.");
                return;
            }
            sourcesFrame = PanSourcesFrame.getSharedInstance();
            try {
                LOGGER.trace("Adding dataset to Sources frame's list");
                sourcesFrame.addDataset(this.dataset_);
            }
            catch (Exception exc) {
                if (exc.toString().contains("already")) {
                    SlowMessage.show(null, "File Error", new StringBuilder("There is already a remote dataset open at that address."));
                }
                LOGGER.warn("Exception adding dataset to UI: {}", (Object)exc.getClass().getSimpleName());
                if (!LOGGER.isTraceEnabled()) break block6;
                exc.printStackTrace();
            }
        }
        sourcesFrame.reveal();
    }

    public void openDataset(boolean onEDT) {
        boolean headless = PlatformUtils.isHeadless();
        LOGGER.trace("EDT {}, headless {}", (Object)onEDT, (Object)headless);
        try {
            if (this.address_ instanceof File) {
                LOGGER.trace("File - {}", this.address_);
                this.dataset_ = new NcDataset((File)this.address_);
            } else if (this.address_ instanceof URL) {
                LOGGER.trace("URL - {}", this.address_);
                this.dataset_ = new NcDataset((URL)this.address_);
            } else if (this.address_ instanceof DatasetUrl) {
                LOGGER.trace("DatasetUrl - {}", (Object)((DatasetUrl)this.address_).getTrueurl());
                this.dataset_ = new NcDataset((DatasetUrl)this.address_);
            } else if (this.address_ instanceof String) {
                LOGGER.debug("String - {}", this.address_);
                this.dataset_ = new NcDataset((String)this.address_);
            } else {
                this.errMsg_ = "Address class is unexpected: " + this.address_.getClass().getSimpleName() + ".";
                LOGGER.warn("Unexpected address class, {}", (Object)this.address_.getClass().getSimpleName());
            }
        }
        catch (HeadlessException hexc) {
            if (headless) {
                this.errMsg_ = hexc.getMessage();
            } else {
                LOGGER.warn("HeadlessException opening dataset. Will try again on EDT.");
                this.tryAgainOnEDT_ = true;
                this.errMsg_ = null;
            }
        }
        catch (FileNotFoundException exc) {
            LOGGER.warn("FileNotFoundException opening dataset: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = "No dataset found at that address.";
        }
        catch (MalformedURLException exc) {
            LOGGER.warn("MalformedURLException opening dataset: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.toString();
        }
        catch (ConnectException exc) {
            LOGGER.warn("ConnectException opening dataset: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.getMessage();
        }
        catch (IOException exc) {
            this.errMsg_ = exc.getMessage();
            LOGGER.warn("IOException opening dataset: {}", (Object)this.errMsg_);
            this.errMsg_ = this.errMsg_.replaceAll(".*Exception: ", "");
            String lcmsg = this.errMsg_.replaceAll(".*: ", "").toLowerCase();
            if (lcmsg.contains("401") || lcmsg.contains("authoriz")) {
                if (onEDT) {
                    LOGGER.warn("On EDT... authorization failed, {}", (Object)this.errMsg_);
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    PanCredentialsProvider.setLastCredentialsRejected();
                    this.errMsg_ = "Authentication credentials were not accepted.";
                } else {
                    LOGGER.warn("Will try again on EDT");
                    this.tryAgainOnEDT_ = true;
                    this.errMsg_ = null;
                }
            } else if (lcmsg.matches(".*status.*403.*")) {
                this.errMsg_ = "Access is forbidden.";
            } else if (lcmsg.matches(".*status.*404.*")) {
                this.errMsg_ = "No resource was found at that address.";
            } else if (lcmsg.matches(".*status.*408.*")) {
                this.errMsg_ = "Request timed out.";
            } else if (lcmsg.matches(".*status.*414.*") || this.errMsg_.contains("414 Request")) {
                this.errMsg_ = "Server denied response; request path is much too long.";
            } else if (lcmsg.matches(".*response.*503.*")) {
                this.errMsg_ = "Service is unavailable; please try again later.";
            } else if (lcmsg.matches(".*clientprotocol.*")) {
                this.errMsg_ = "A protocol exception occurred.";
            } else if (this.errMsg_.contains("not a valid CDM file")) {
                this.errMsg_ = "File does not seem to be a netCDF or CDM format that I understand.";
            } else if (lcmsg.matches(".*could not find a table for grib file.*")) {
                this.errMsg_ = this.errMsg_ + "\nYou must first either open an appropriate local GRIB table or else turn off GRIB-1 \"strict mode\" in Preferences before opening this dataset.";
            } else if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
        }
        catch (NcNotAuthorizedException exc) {
            if (onEDT) {
                LOGGER.warn("NcNotAuthorizedException while on EDT.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                PanCredentialsProvider.setLastCredentialsRejected();
                this.errMsg_ = "Authentication credentials were not accepted.";
            } else {
                LOGGER.warn("NcNotAuthorizedException. Will try again on EDT.");
                this.tryAgainOnEDT_ = true;
                this.errMsg_ = null;
            }
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
        }
        catch (NcForbiddenException exc) {
            LOGGER.warn("NcForbiddenException accessing dataset");
            PanCredentialsProvider.setLastCredentialsRejected();
            this.errMsg_ = exc.getMessage();
        }
        catch (NcResourceNotFoundException exc) {
            this.errMsg_ = exc.getMessage();
        }
        catch (NcException exc) {
            LOGGER.warn("NcException accessing dataset: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.errMsg_ = exc.getMessage();
        }
        catch (Exception exc) {
            String lc;
            LOGGER.warn("Exception opening dataset: {}", (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if ((lc = exc.toString().toLowerCase()).contains("authoriz")) {
                if (!onEDT) {
                    LOGGER.warn("Will try again on EDT");
                    this.tryAgainOnEDT_ = true;
                    this.errMsg_ = null;
                } else {
                    LOGGER.warn("On EDT... authorization failed.");
                    PanCredentialsProvider.setLastCredentialsRejected();
                    this.errMsg_ = "Authorization required to access dataset.";
                }
            }
            if (lc.contains("connection refused")) {
                this.errMsg_ = "Remote connection was refused.";
            }
            if (lc.contains("parseexception") || lc.contains("parser")) {
                this.errMsg_ = "Unable to parse dataset structure or metadata.";
            }
            if (lc.contains("filenotfound")) {
                this.errMsg_ = "Dataset was not found.";
            }
            if (lc.contains("s3.model.nosuchkeyexception")) {
                this.errMsg_ = "S3 bucket/key combination not found.";
            }
            if (lc.contains("s3exception")) {
                this.errMsg_ = lc.contains("code: 403") ? "Apparent S3 permissions/authorization error." : (lc.contains("code: 404") ? "S3 bucket/key combination not found." : "Unrecognized S3 error.");
            }
            if (!onEDT) {
                this.tryAgainOnEDT_ = true;
                this.errMsg_ = null;
            }
            this.errMsg_ = exc.getMessage();
        }
        if (this.dataset_ == null && this.errMsg_ == null && !this.tryAgainOnEDT_) {
            this.errMsg_ = "Uncaught/unknown exception.";
        }
    }

    public NcDataset getDataset() {
        return this.dataset_;
    }

    public String getErrorMessage() {
        return this.errMsg_;
    }
}

