/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.overlay;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayFilenameFilter;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ui.ProjDoubleComponent;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.panoply.action.PanSaveImageAsAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.overlay.PanOverlayPanel;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanOverlayComboBox;
import gov.nasa.giss.panoply.ui.PanPrintablePanel;
import gov.nasa.giss.panoply.ui.PanProjectionComboBox;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanQuitWatcher;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanOverlayFrame
extends PanDisplayFrame
implements DropTargetListener,
Printable,
ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_2 = new PrintfFormat("%.2f");
    private static final PrintfFormat PFORMAT_7G = new PrintfFormat("%.7g");
    private static final int LABEL_FHGT = 12;
    private static final int LABEL_HGT = 18;
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private JPanel contentPanel_;
    private PanOverlayComboBox overlayCombo_;
    private PanOverlayPanel overlayPanel_;
    private JCheckBox overlayMaskInvertCB_;
    private PanButton prefBtn_;
    private PanProjectionComboBox projCombo_;
    private GTextField copLonTF_;
    private GTextField copLatTF_;
    private JLabel paramsLabel_;
    private QuickBox paramsBox_;
    private ProjParamComponent[] paramComponents_ = new ProjParamComponent[5];
    private PanButton fixConicBtn_;
    private final Hashtable<String, String> paramHash_ = new Hashtable(25);
    private String lastproj_;

    public static PanOverlayFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanOverlayFrame() {
        super("Panoply \u2014 Overlays");
        JMenuItem jmi;
        Action a;
        this.setResizable(false);
        PanMenuBar mbar = new PanMenuBar(this);
        this.setPanMenuBar(mbar);
        if (mbar != null && (a = (jmi = mbar.getItemForName("file-menu", "save-image")).getAction()) != null) {
            a.setEnabled(false);
        }
        this.createLayout();
        this.placeOnScreen();
        this.attachListeners();
    }

    private void createLayout() {
        JLabel overlayLabel = new JLabel("Overlay:\u2009");
        MapOverlay overlay = PanResourceUtils.getPreferredOverlay();
        this.overlayCombo_ = PanOverlayComboBox.create(false);
        if (overlay == null) {
            overlay = PanResourceUtils.getOverlay(0);
        }
        this.overlayCombo_.setSelectedItem(overlay.toString());
        this.overlayMaskInvertCB_ = new JCheckBox("Invert", PREFS.getBoolean(PanParamKeys.P_OVERLAY_INVERT[0]));
        this.prefBtn_ = PanButton.create(null, "Make Default 1");
        QuickBox selectBox = QuickBox.createHorizontalBox(overlayLabel, this.overlayCombo_, this.overlayMaskInvertCB_, Box.createHorizontalGlue(), this.prefBtn_);
        this.overlayPanel_ = new PanOverlayPanel();
        this.overlayPanel_.setOverlay(overlay);
        JLabel projLabel = new JLabel("Projection:\u2009");
        this.projCombo_ = PanProjectionComboBox.create(null, true);
        this.projCombo_.setSelectedItem(PREFS.getString("plot:proj.name"));
        this.projCombo_.setMaximumSize(this.projCombo_.getPreferredSize());
        JLabel centerLabel = new JLabel("Center on: ");
        JLabel lonLabel = new JLabel("Lon. ");
        JLabel degELabel = new JLabel("\u00b0E");
        JLabel latLabel = new JLabel(", Lat. ");
        JLabel degNLabel = new JLabel("\u00b0N");
        this.copLonTF_ = GTextField.createDoubleField(PREFS.getDouble("plot:proj.lon0"));
        this.copLatTF_ = GTextField.createDoubleField(PREFS.getDouble("plot:proj.lat0"));
        this.copLonTF_.setMaximumSize(this.copLonTF_.getPreferredSize());
        this.copLatTF_.setMaximumSize(this.copLatTF_.getPreferredSize());
        QuickBox projCenterBox = QuickBox.createLeftBox(centerLabel, lonLabel, this.copLonTF_, degELabel, latLabel, this.copLatTF_, degNLabel);
        this.paramsLabel_ = new JLabel("Add'l params:\u2009");
        this.paramsBox_ = QuickBox.createLeftBox(this.paramsLabel_);
        GuiUtils.matchLabelWidths(projLabel, centerLabel, this.paramsLabel_);
        this.contentPanel_ = new JPanel();
        this.contentPanel_.setLayout(new BoxLayout(this.contentPanel_, 1));
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.contentPanel_.setOpaque(false);
        this.contentPanel_.add(selectBox);
        this.contentPanel_.add(Box.createVerticalStrut(8));
        this.contentPanel_.add(this.overlayPanel_);
        this.contentPanel_.add(Box.createVerticalStrut(8));
        this.contentPanel_.add(QuickBox.createLeftBox(projLabel, this.projCombo_));
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(projCenterBox);
        this.contentPanel_.add(Box.createVerticalStrut(2));
        this.contentPanel_.add(this.paramsBox_);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.contentPanel_);
        contentPane.add(this.statusBar_);
        this.refresh();
        this.pack();
    }

    private void attachListeners() {
        GuiUtils.makeRecursiveDropTarget(this.overlayPanel_, this);
        this.overlayCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            MapOverlay oo = this.overlayCombo_.getSelectedOverlay();
            this.overlayPanel_.setOverlay(oo);
            this.refresh();
        });
        this.overlayMaskInvertCB_.addItemListener(e -> this.overlayPanel_.setOverlayInverted(e.getStateChange() == 1));
        this.projCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.projCombo_.isRefreshing()) {
                return;
            }
            String pname = this.projCombo_.getSelectedItem().toString();
            this.overlayPanel_.setProjection(pname);
            this.refresh();
        });
        FocusAdapter lonlatFL = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanOverlayFrame.this.handleCoP();
            }
        };
        this.copLonTF_.addFocusListener(lonlatFL);
        this.copLatTF_.addFocusListener(lonlatFL);
        this.copLonTF_.addActionListener(e -> this.handleCoP());
        this.copLatTF_.addActionListener(e -> this.handleCoP());
        this.prefBtn_.addActionListener(e -> {
            String oname = (String)this.overlayCombo_.getSelectedItem();
            MapOverlay oo = PanResourceUtils.getOverlay(oname);
            if (oo != null) {
                PanPreferences prefs = PanPreferences.getSharedInstance();
                prefs.setString(PanParamKeys.P_OVERLAY_NAME[0], oo.toString());
                if (oo instanceof PanMaskOverlay) {
                    boolean inverted = this.overlayMaskInvertCB_.isSelected();
                    prefs.setBoolean(PanParamKeys.P_OVERLAY_INVERT[0], inverted);
                }
            }
            if (PanPreferencesFrame.instanceExists()) {
                PanPreferencesFrame.getSharedInstance().refresh();
            }
        });
        PanResourceUtils.getOverlayList().addListDataListener(this);
    }

    private void handleCoP() {
        double lon = 0.0;
        double lat = 0.0;
        try {
            boolean shifted = false;
            for (lon = StringUtils.parseDouble(this.copLonTF_.getText()); lon > 180.0; lon -= 360.0) {
                shifted = true;
            }
            while (lon < -180.0) {
                lon += 360.0;
                shifted = true;
            }
            if (shifted) {
                this.copLonTF_.setText(PFORMAT_2.sprintfx(lon));
            }
        }
        catch (Exception exc) {
            lon = this.overlayPanel_.getProjection().getCenter().getLon();
            this.copLonTF_.setText(PFORMAT_2.sprintfx(lon));
        }
        try {
            lat = StringUtils.parseDouble(this.copLatTF_.getText());
            if (Math.abs(lat) > 90.0) {
                lat = 90.0 * Math.signum(lat);
                this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
            }
        }
        catch (Exception exc) {
            lat = this.overlayPanel_.getProjection().getCenter().getLat();
            this.copLatTF_.setText(PFORMAT_7G.sprintfx(lat));
        }
        this.overlayPanel_.getProjection().setCenter(lon, lat);
        this.overlayPanel_.repaint();
    }

    public final void setOverlay(MapOverlay oo) {
        this.overlayCombo_.setSelectedItem(oo.toString());
    }

    public final void setProjection(String pname) {
        this.overlayPanel_.setProjection(pname);
    }

    @Override
    public void refresh() {
        int i;
        MapOverlay oo = this.overlayCombo_.getSelectedOverlay();
        this.overlayMaskInvertCB_.setEnabled(oo instanceof PanMaskOverlay);
        AbstractProjection proj = this.overlayPanel_.getProjection();
        String projname = proj.getName();
        PanMenuBar mbar = this.getPanMenuBar();
        JMenuItem jmi = mbar.getItemForName("file-menu", "save-image-as");
        Action a = jmi.getAction();
        if (a != null) {
            ((PanSaveImageAsAction)a).setFnameRoot(projname.toLowerCase());
        }
        if (this.lastproj_ != null && projname.equals(this.lastproj_)) {
            return;
        }
        this.lastproj_ = projname;
        this.copLonTF_.setEnabled(proj.isRecenterableLon());
        this.copLatTF_.setEnabled(proj.isRecenterableLat());
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        this.paramsBox_.removeAll();
        this.paramsBox_.add(this.paramsLabel_);
        int pcount = proj.getExtraParamCount();
        if (pcount == 0) {
            this.paramsBox_.add(new JLabel("None"));
        }
        for (i = 0; i < this.paramComponents_.length; ++i) {
            this.paramComponents_[i] = null;
        }
        for (i = 0; i < pcount; ++i) {
            ProjParamComponent xcomp;
            if (i > 0) {
                this.paramsBox_.add(new JLabel(", "));
            }
            int pid = i;
            this.paramComponents_[i] = xcomp = proj.getParamComponent(i);
            this.paramsBox_.add(xcomp);
            xcomp.setMaximumSize(xcomp.getPreferredSize());
            xcomp.addChangeListener(e -> {
                this.overlayPanel_.repaint();
                this.paramHash_.put(projname + "-" + pid, xcomp.getStringValue());
                try {
                    if (proj.hasProperty(0x1000000)) {
                        this.copLonTF_.setEnabled(proj.isRecenterableLon());
                        this.copLonTF_.setText(PFORMAT_2.sprintfx(proj.getCenter().getLon()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            String sval = this.paramHash_.get(projname + "-" + pid);
            if (sval == null || sval.isEmpty()) {
                sval = pprefs.getParam(projname, pid);
            }
            if (sval == null || sval.isEmpty()) continue;
            try {
                xcomp.setValue(sval);
                continue;
            }
            catch (Exception exc) {
                LOGGER.trace("exc = {}", (Object)exc.toString());
            }
        }
        if (proj.hasProperty(16)) {
            if (this.fixConicBtn_ == null) {
                this.fixConicBtn_ = PanButton.create(null, "Autoset Parallels");
                this.fixConicBtn_.addActionListener(e -> this.fixConic());
            }
            this.paramsBox_.add(new JLabel(" \u2014 "));
            this.paramsBox_.add(this.fixConicBtn_);
        }
        this.paramsBox_.add(Box.createHorizontalGlue());
        this.paramsBox_.invalidate();
        this.pack();
        this.repaint();
        super.refresh();
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiUtils.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!OverlayFilenameFilter.isOverlayName(f)) continue;
                    addlist.add(f);
                }
                Object[] objectArray = PanResourceUtils.getOverlayList().addAlphabetic((Component)this, addlist);
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.contentPanel_.setBorder(PanGuiUtils.PADDED_FOCUSED_BORDER);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.contentPanel_.setBorder(PanGuiUtils.PADDED_UNFOCUSED_BORDER);
        this.repaint();
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        MapOverlay olay;
        if (e == null) {
            return;
        }
        Component cc = e.getComponent();
        if (cc == null) {
            return;
        }
        JFrame jf = null;
        if (cc instanceof JFrame) {
            jf = (JFrame)cc;
        } else if (cc instanceof JComponent) {
            jf = GuiUtils.getParentFrame((JComponent)cc);
        } else {
            return;
        }
        if (jf == this && (olay = PanResourceUtils.getOverlay(e.getIndex0())) != null) {
            EventQueue.invokeLater(() -> this.setOverlay(olay));
        }
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = this.overlayPanel_.getSize();
        double scaleX = pf.getImageableHeight() / (double)size.width;
        double scaleY = pf.getImageableWidth() / (double)(size.height + 18);
        double scale = Math.min(scaleY, scaleX);
        double tranX = 0.5 * (pf.getImageableWidth() + scale * (double)this.overlayPanel_.getHeight());
        g2d.translate(pf.getImageableX() + tranX, pf.getImageableY());
        g2d.rotate(1.5707963267948966);
        g2d.scale(scale, scale);
        this.overlayPanel_.print(g2d);
        return 0;
    }

    @Override
    public PanPrintablePanel getPrintable() {
        return this.overlayPanel_;
    }

    private void fixConic() {
        double lat;
        try {
            lat = StringUtils.parseDouble(this.copLatTF_.getText());
        }
        catch (Exception exc) {
            return;
        }
        ProjDoubleComponent p1field = (ProjDoubleComponent)this.paramComponents_[0];
        ProjDoubleComponent p2field = (ProjDoubleComponent)this.paramComponents_[1];
        ProjDoubleComponent hfield = (ProjDoubleComponent)this.paramComponents_[2];
        double h = (Double)hfield.getValue();
        if (h < 0.0) {
            h = 1.0;
        }
        double p1 = lat + 0.3 * h;
        double p2 = lat - 0.3 * h;
        if (p1 > 90.0) {
            p1 = 90.0;
        }
        if (p2 < -90.0) {
            p2 = -90.0;
        }
        p1field.setValue(p1);
        p2field.setValue(p2);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (!vis) {
            PanQuitWatcher.quitIfNone();
        }
    }

    private static class Singleton {
        private static final PanOverlayFrame INSTANCE = new PanOverlayFrame();

        private Singleton() {
        }
    }
}

