/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayXY;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridderXY;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Converter;
import ucar.units.Unit;

public class PanDataGeneral2D
extends PanData2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    protected PanAxisMethod xaxisMethod_ = PanAxisMethod.SCALAR;
    protected PanAxisMethod yaxisMethod_ = PanAxisMethod.SCALAR;
    private double logLBound_;
    private double logRBound_;
    private double logTBound_;
    private double logBBound_;
    private String xAxisUnitStr_;
    private String yAxisUnitStr_;
    protected Unit xAxisUdunits_;
    protected Unit yAxisUdunits_;
    private Converter[] xAxisUnitsConverter_;
    private Converter[] yAxisUnitsConverter_;
    private double customXLeft_ = Double.NaN;
    private double customXRight_ = Double.NaN;
    private double customYTop_ = Double.NaN;
    private double customYBottom_ = Double.NaN;
    private double xPerPxl_;
    private double yPerPxl_;
    protected double[] colX_;
    protected double[] colLogX_;
    protected double[] rowY_;
    protected double[] rowLogY_;

    public PanDataGeneral2D(PanPlotMeta pmeta, NcArray nca, Dimension size) {
        this(pmeta, nca, size.width, size.height);
    }

    public PanDataGeneral2D(PanPlotMeta pmeta, NcArray nca, int width, int height) {
        super(pmeta, nca, width, height);
        NcAxis xAxis = this.getXAxis();
        NcAxis yAxis = this.getYAxis();
        this.setXAxisUnits(this.getXAxis().getUnitsStr());
        this.setYAxisUnits(this.getYAxis().getUnitsStr());
        double[][] xbounds = xAxis.getBounds();
        double[][] ybounds = yAxis.getBounds();
        this.setGridLeftAndRight(xbounds[0][0], xbounds[xAxis.getLength() - 1][1]);
        this.setGridBottomAndTop(ybounds[yAxis.getLength() - 1][1], ybounds[0][0]);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayXY)) {
            throw new IllegalArgumentException("NcArray is not an NcArrayXY.");
        }
        return true;
    }

    protected void prepareXAxisUnits() {
        NcArray2D[] nca2D = new NcArray2D[]{(NcArray2D)this.ncArrays_[0], (NcArray2D)this.ncArrays_[1]};
        Unit[] udunits = new Unit[]{null, null};
        udunits[0] = nca2D[0] == null ? null : nca2D[0].getXAxis().getUdunits();
        udunits[1] = nca2D[1] == null ? null : nca2D[1].getXAxis().getUdunits();
        this.xAxisUnitsConverter_ = new Converter[]{null, null};
        if (udunits[0] != null) {
            try {
                this.xAxisUnitsConverter_[0] = udunits[0].getConverterTo(this.xAxisUdunits_);
            }
            catch (Exception exc) {
                this.xAxisUnitsConverter_[0] = null;
            }
        }
        if (udunits[1] != null) {
            try {
                this.xAxisUnitsConverter_[1] = udunits[1].getConverterTo(this.xAxisUdunits_);
            }
            catch (Exception exc) {
                this.xAxisUnitsConverter_[1] = null;
            }
        }
    }

    public String getDataXAxisUnits() {
        NcArray2D nca2D = (NcArray2D)this.ncArrays_[0];
        return nca2D.getXAxis().getUnitsStr();
    }

    @Override
    public String getXAxisUnits() {
        String xunits;
        String string = xunits = this.xAxisUdunits_ == null ? this.getXAxis().getUnitsStr() : this.xAxisUnitStr_;
        if (xunits == null || xunits.isEmpty() || "-".equals(xunits)) {
            return null;
        }
        return xunits;
    }

    public void setXAxisUnits(String unitsStr) {
        this.xAxisUnitStr_ = unitsStr;
        try {
            this.xAxisUdunits_ = NcUnitUtils.parse(unitsStr);
        }
        catch (Exception exc) {
            this.xAxisUnitStr_ = null;
            this.xAxisUdunits_ = null;
        }
        this.setBoundsChanged();
    }

    public PanAxisMethod getXAxisMethod() {
        return this.xaxisMethod_;
    }

    public void setXAxisMethod(PanAxisMethod method) {
        this.xaxisMethod_ = method;
        this.customXLeft_ = Double.NaN;
        this.customXRight_ = Double.NaN;
        this.setBoundsChanged();
    }

    public void setGridLeftAndRight(double left, double right) {
        this.customXLeft_ = left;
        this.customXRight_ = right;
        this.setBoundsChanged();
    }

    public double[] getDefaultLeftAndRight(PanAxisMethod method) {
        double lBound = Double.NaN;
        double rBound = Double.NaN;
        this.prepareXAxisUnits();
        for (int i = 0; i < 2; ++i) {
            double r;
            double l;
            if (this.ncArrays_[i] == null || this.comboType_ == PanCombinationType.A1_ONLY && i == 1 || this.comboType_ == PanCombinationType.A2_ONLY && i == 0) continue;
            NcAxis xAxis = ((NcArray2D)this.ncArrays_[i]).getXAxis();
            int isize = xAxis.getLength();
            if (method == PanAxisMethod.INDEX) {
                l = 0.0;
                r = isize;
                if (Double.isNaN(rBound)) {
                    lBound = l;
                    rBound = r;
                    continue;
                }
                lBound = Math.min(l, lBound);
                rBound = Math.max(r, rBound);
                continue;
            }
            double[][] xBounds = xAxis.getBounds();
            double[] xValues = xAxis.getValues();
            l = xBounds[0][0];
            r = xBounds[isize - 1][1];
            if (this.xAxisUnitsConverter_ != null && this.xAxisUnitsConverter_[i] != null) {
                l = this.xAxisUnitsConverter_[i].convert(l);
                r = this.xAxisUnitsConverter_[i].convert(r);
            }
            double rr = Math.max(l, r);
            double ll = Math.min(l, r);
            if (Double.isNaN(rBound)) {
                lBound = ll;
                rBound = rr;
                continue;
            }
            lBound = Math.min(ll, lBound);
            rBound = Math.max(rr, rBound);
        }
        if (method == PanAxisMethod.LOG10) {
            if (lBound <= 0.0) {
                lBound = 1.0E-50;
            }
            if (rBound <= 0.0) {
                rBound = 1.0E-50;
            }
        }
        return new double[]{lBound, rBound};
    }

    protected void prepareYAxisUnits() {
        NcArray2D[] nca2D = new NcArray2D[]{(NcArray2D)this.ncArrays_[0], (NcArray2D)this.ncArrays_[1]};
        Unit[] udunits = new Unit[]{null, null};
        udunits[0] = nca2D[0] == null ? null : nca2D[0].getYAxis().getUdunits();
        udunits[1] = nca2D[1] == null ? null : nca2D[1].getYAxis().getUdunits();
        this.yAxisUnitsConverter_ = new Converter[]{null, null};
        if (udunits[0] != null) {
            try {
                this.yAxisUnitsConverter_[0] = udunits[0].getConverterTo(this.yAxisUdunits_);
            }
            catch (Exception exc) {
                this.yAxisUnitsConverter_[0] = null;
            }
        }
        if (udunits[1] != null) {
            try {
                this.yAxisUnitsConverter_[1] = udunits[1].getConverterTo(this.yAxisUdunits_);
            }
            catch (Exception exc) {
                this.yAxisUnitsConverter_[1] = null;
            }
        }
    }

    public String getDataYAxisUnits() {
        NcArray2D nca2D = (NcArray2D)this.ncArrays_[0];
        return nca2D.getYAxis().getUnitsStr();
    }

    @Override
    public String getYAxisUnits() {
        String unitsStr;
        String string = unitsStr = this.yAxisUdunits_ == null ? this.getYAxis().getUnitsStr() : this.yAxisUnitStr_;
        if (unitsStr == null || unitsStr.isEmpty() || unitsStr.equals("-")) {
            return null;
        }
        return unitsStr;
    }

    public void setYAxisUnits(String unitsStr) {
        this.yAxisUnitStr_ = unitsStr;
        try {
            this.yAxisUdunits_ = NcUnitUtils.parse(unitsStr);
        }
        catch (Exception exc) {
            this.yAxisUnitStr_ = null;
            this.yAxisUdunits_ = null;
        }
        this.setBoundsChanged();
    }

    public PanAxisMethod getYAxisMethod() {
        return this.yaxisMethod_;
    }

    public void setYAxisMethod(PanAxisMethod method) {
        this.yaxisMethod_ = method;
        this.customYTop_ = Double.NaN;
        this.customYBottom_ = Double.NaN;
        this.setBoundsChanged();
    }

    public void setGridBottomAndTop(double bottom, double top) {
        this.customYBottom_ = bottom;
        this.customYTop_ = top;
        this.setBoundsChanged();
    }

    public double[] getDefaultBottomAndTop(PanAxisMethod method) {
        double bBound = Double.NaN;
        double tBound = Double.NaN;
        this.prepareYAxisUnits();
        PanPreferences prefs = PanPreferences.getSharedInstance();
        for (int i = 0; i < 2; ++i) {
            double tt;
            double bb;
            double t;
            double b;
            if (this.ncArrays_[i] == null || this.comboType_ == PanCombinationType.A1_ONLY && i == 1 || this.comboType_ == PanCombinationType.A2_ONLY && i == 0) continue;
            NcAxis yAxis = ((NcArray2D)this.ncArrays_[i]).getYAxis();
            int isize = yAxis.getLength();
            if (method == PanAxisMethod.INDEX) {
                b = isize;
                t = 0.0;
            } else {
                double[][] yBounds = yAxis.getBounds();
                double[] yValues = yAxis.getValues();
                b = yBounds[isize - 1][1];
                t = yBounds[0][0];
                if (this.yAxisUnitsConverter_ != null && this.yAxisUnitsConverter_[i] != null) {
                    b = this.yAxisUnitsConverter_[i].convert(b);
                    t = this.yAxisUnitsConverter_[i].convert(t);
                }
            }
            boolean showPosUp = false;
            if (method == PanAxisMethod.INDEX) {
                showPosUp = true;
            } else {
                boolean prefsPosUp = prefs.getBoolean("plot:xy.yaxis.posup");
                boolean bl = showPosUp = yAxis.hasPositive() && yAxis.isPositiveUp() || prefsPosUp && !yAxis.hasPositive();
                if (yAxis.hasPositive() && yAxis.isPositiveDown()) {
                    showPosUp = false;
                }
            }
            if (showPosUp) {
                bb = Math.min(t, b);
                tt = Math.max(t, b);
                if (Double.isNaN(tBound)) {
                    bBound = bb;
                    tBound = tt;
                    continue;
                }
                bBound = Math.min(b, bBound);
                tBound = Math.max(t, tBound);
                continue;
            }
            bb = Math.max(t, b);
            tt = Math.min(t, b);
            if (Double.isNaN(tBound)) {
                bBound = bb;
                tBound = tt;
                continue;
            }
            bBound = Math.max(b, bBound);
            tBound = Math.min(t, tBound);
        }
        if (method == PanAxisMethod.LOG10) {
            if (bBound <= 0.0) {
                bBound = 1.0E-50;
            }
            if (tBound <= 0.0) {
                tBound = 1.0E-50;
            }
        }
        return new double[]{bBound, tBound};
    }

    @Override
    protected void prepareXGrid() {
        this.prepareXAxisUnits();
        if (Double.isNaN(this.customXLeft_) || Double.isNaN(this.customXRight_)) {
            double[] defaults = this.getDefaultLeftAndRight(this.xaxisMethod_);
            this.lBound_ = defaults[0];
            this.rBound_ = defaults[1];
        } else {
            this.lBound_ = this.customXLeft_;
            this.rBound_ = this.customXRight_;
        }
        if (this.xaxisMethod_ == PanAxisMethod.LOG10) {
            if (this.lBound_ <= 0.0) {
                this.lBound_ = 1.0E-50;
            }
            if (this.rBound_ <= 0.0) {
                this.rBound_ = 1.0E-50;
            }
            this.logLBound_ = Math.log10(this.lBound_);
            this.logRBound_ = Math.log10(this.rBound_);
        } else {
            this.logLBound_ = Double.NaN;
            this.logRBound_ = Double.NaN;
        }
        if (this.colX_ == null || this.colX_.length != this.gridWidth_) {
            this.colX_ = new double[this.gridWidth_];
            this.colLogX_ = new double[this.gridWidth_];
        }
        if (this.xaxisMethod_ == PanAxisMethod.LOG10) {
            this.xPerPxl_ = (this.logRBound_ - this.logLBound_) / (double)this.gridWidth_;
            for (int j = 0; j < this.gridWidth_; ++j) {
                this.colLogX_[j] = this.logLBound_ + ((double)j + 0.5) * this.xPerPxl_;
                this.colX_[j] = Math.pow(10.0, this.colLogX_[j]);
            }
        } else {
            this.xPerPxl_ = (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
            for (int j = 0; j < this.gridWidth_; ++j) {
                this.colX_[j] = this.lBound_ + ((double)j + 0.5) * this.xPerPxl_;
                this.colLogX_[j] = Math.log10(this.colX_[j]);
            }
        }
    }

    @Override
    protected void prepareYGrid() {
        this.prepareYAxisUnits();
        if (Double.isNaN(this.customYTop_) || Double.isNaN(this.customYBottom_)) {
            double[] defaults = this.getDefaultBottomAndTop(this.yaxisMethod_);
            this.bBound_ = defaults[0];
            this.tBound_ = defaults[1];
        } else {
            this.bBound_ = this.customYBottom_;
            this.tBound_ = this.customYTop_;
        }
        if (this.yaxisMethod_ == PanAxisMethod.LOG10) {
            if (this.bBound_ <= 0.0) {
                this.bBound_ = 1.0E-50;
            }
            if (this.tBound_ <= 0.0) {
                this.tBound_ = 1.0E-50;
            }
            this.logBBound_ = Math.log10(this.bBound_);
            this.logTBound_ = Math.log10(this.tBound_);
        } else {
            this.logBBound_ = Double.NaN;
            this.logTBound_ = Double.NaN;
        }
        if (this.rowY_ == null || this.rowY_.length != this.gridHeight_) {
            this.rowY_ = new double[this.gridHeight_];
            this.rowLogY_ = new double[this.gridHeight_];
        }
        if (this.yaxisMethod_ == PanAxisMethod.LOG10) {
            this.yPerPxl_ = (this.logBBound_ - this.logTBound_) / (double)this.gridHeight_;
            for (int j = 0; j < this.gridHeight_; ++j) {
                this.rowLogY_[j] = this.logTBound_ + ((double)j + 0.5) * this.yPerPxl_;
                this.rowY_[j] = Math.pow(10.0, this.rowLogY_[j]);
            }
        } else {
            this.yPerPxl_ = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
            for (int j = 0; j < this.gridHeight_; ++j) {
                this.rowY_[j] = this.tBound_ + ((double)j + 0.5) * this.yPerPxl_;
                this.rowLogY_[j] = Math.log10(this.rowY_[j]);
            }
        }
    }

    @Override
    public double getColX(int col) {
        return this.colX_[col];
    }

    @Override
    public double getRowY(int row) {
        return this.rowY_[row];
    }

    @Override
    protected void regrid(NcArray nca, double[] target, boolean interpolated) {
        NcGridderXY gridder = (NcGridderXY)nca.getGridder();
        if (this.xaxisMethod_ == PanAxisMethod.INDEX) {
            gridder.setXAxisMethod(NcAxisMethod.INDEX);
        } else if (this.xaxisMethod_ == PanAxisMethod.LOG10) {
            gridder.setXAxisUdunits(this.xAxisUdunits_);
            gridder.setXAxisMethod(NcAxisMethod.LOG10);
        } else {
            gridder.setXAxisUdunits(this.xAxisUdunits_);
            gridder.setXAxisMethod(NcAxisMethod.SCALAR);
        }
        if (this.yaxisMethod_ == PanAxisMethod.INDEX) {
            gridder.setYAxisMethod(NcAxisMethod.INDEX);
        } else if (this.yaxisMethod_ == PanAxisMethod.LOG10) {
            gridder.setYAxisUdunits(this.yAxisUdunits_);
            gridder.setYAxisMethod(NcAxisMethod.LOG10);
        } else {
            gridder.setYAxisUdunits(this.yAxisUdunits_);
            gridder.setYAxisMethod(NcAxisMethod.SCALAR);
        }
        LOGGER.trace("L {}, T {}, R {}, B {}", this.lBound_, this.tBound_, this.rBound_, this.bBound_);
        gridder.setSize(this.gridWidth_, this.gridHeight_);
        gridder.setBounds(this.lBound_, this.tBound_, this.rBound_, this.bBound_);
        if (interpolated) {
            gridder.regridInterpolate(nca, target);
        } else {
            gridder.regridNoInterpolate(nca, target);
        }
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        if (this.gridWidth_ < 1 || this.gridHeight_ < 1) {
            return null;
        }
        double xx = this.xaxisMethod_ == PanAxisMethod.LOG10 ? Math.pow(10.0, this.logLBound_ + x * this.xPerPxl_) : this.lBound_ + x * this.xPerPxl_;
        double yy = this.yaxisMethod_ == PanAxisMethod.LOG10 ? Math.pow(10.0, this.logTBound_ + y * this.yPerPxl_) : this.tBound_ + y * this.yPerPxl_;
        return new Point2D.Double(xx, yy);
    }

    @Override
    public void describeDataAt(StringBuilder sb, int ii, int jj) {
        Objects.requireNonNull(sb, "StringBuilder cannot be null.");
        double x = this.colX_[ii];
        double y = this.rowY_[jj];
        this.formatCoordinates(sb, x, y);
        sb.append("Displayed value: ");
        double dd = this.valueAt(ii, jj);
        if (Double.isNaN(dd)) {
            sb.append("NaN");
        } else {
            sb.append(PFORMAT_10G.sprintfx(dd));
        }
        sb.append("\n \n");
        for (int i = 0; i < 2; ++i) {
            Unit uu;
            double val;
            int incol = -1;
            int inrow = -1;
            if (this.ncArrays_[i] == null || i == 0 && this.comboType_ == PanCombinationType.A2_ONLY || i == 1 && this.comboType_ == PanCombinationType.A1_ONLY) continue;
            NcArray2D nca2D = (NcArray2D)this.ncArrays_[i];
            if (this.xaxisMethod_ == PanAxisMethod.INDEX) {
                incol = (int)x;
            } else {
                val = x;
                if (this.xAxisUdunits_ != null) {
                    uu = nca2D.getXAxis().getUdunits();
                    try {
                        val = this.xAxisUdunits_.convertTo(val, uu);
                    }
                    catch (Exception exc) {
                        LOGGER.debug("Units exception - {}", (Object)exc.toString());
                    }
                }
                incol = nca2D.getXAxis().findNearestIndex(val);
            }
            if (this.yaxisMethod_ == PanAxisMethod.INDEX) {
                inrow = (int)y;
            } else {
                val = y;
                if (this.yAxisUdunits_ != null) {
                    uu = nca2D.getYAxis().getUdunits();
                    try {
                        val = this.yAxisUdunits_.convertTo(val, uu);
                    }
                    catch (Exception exc) {
                        LOGGER.trace("Units exception - {}", (Object)exc.toString());
                    }
                }
                inrow = nca2D.getYAxis().findNearestIndex(val);
            }
            sb.append("Array ").append(i + 1).append(": ");
            nca2D.describeCell(sb, this.scaleFormatter_, incol, inrow);
            sb.append('\n');
        }
    }

    private void formatCoordinates(StringBuilder sb, double x, double y) {
        Objects.requireNonNull(sb, "StringBuilder cannot be null.");
        StringBuilder xsb = new StringBuilder();
        if (this.xaxisMethod_ == PanAxisMethod.INDEX) {
            xsb.append("index");
        } else {
            String ss;
            String unitsStr = this.getXAxisUnits();
            if (unitsStr == null) {
                xsb.append("");
            } else if (NcUnitUtils.isDegreesEast(unitsStr)) {
                xsb.append("\u00b0E");
            } else if (NcUnitUtils.isDegreesNorth(unitsStr)) {
                xsb.append("\u00b0N");
            }
            if (xsb.length() == 0 && (ss = ((NcArray2D)this.ncArrays_[0]).getXAxis().getUnitsStr()) != null) {
                xsb.append(ss);
            }
        }
        NcAxis xAxis = this.getXAxis();
        if (xAxis instanceof NcTimeAxis) {
            xsb.append(" [").append(((NcTimeAxis)xAxis).formatValue(x)).append(']');
        }
        StringBuilder ysb = new StringBuilder();
        if (this.yaxisMethod_ == PanAxisMethod.INDEX) {
            ysb.append("index");
        } else {
            String ss;
            String unitsStr = this.getYAxisUnits();
            if (unitsStr == null) {
                ysb.append("");
            } else if (NcUnitUtils.isDegreesEast(unitsStr)) {
                ysb.append("\u00b0E");
            } else if (NcUnitUtils.isDegreesNorth(unitsStr)) {
                ysb.append("\u00b0N");
            }
            if (ysb.length() == 0 && (ss = ((NcArray2D)this.ncArrays_[0]).getYAxis().getUnitsStr()) != null) {
                ysb.append(ss);
            }
        }
        NcAxis yAxis = this.getYAxis();
        if (yAxis instanceof NcTimeAxis) {
            ysb.append(" [").append(((NcTimeAxis)yAxis).formatValue(y)).append(']');
        }
        sb.append("X: ").append(PFORMAT_10G.sprintfx(x)).append(' ').append((CharSequence)xsb).append('\n').append("Y: ").append(PFORMAT_10G.sprintfx(y)).append(' ').append((CharSequence)ysb).append('\n');
    }
}

