/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eckert1
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Eckert I";
    public static final int PROPERTIES = 8;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;

    public Eckert1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double x = lambdaRad * (1.0 - absPhiRad * 0.3183098861837907);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = absYOverRS;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = absXOverRS / (1.0 - Math.abs(phiRad) * 0.3183098861837907);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Eckert1 eckert1 = this;
        synchronized (eckert1) {
            double y;
            double yOverRS;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (yOverRS = (y = (double)iy + 0.5) * this.invRS_)) > 1.5707963267948966); ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) / (1.0 - phiRad * 0.3183098861837907)) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda > 179.99999) {
            return;
        }
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        if (dot0 == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        GraphicUtils.drawLine(g2d, dotN, dot0);
        GraphicUtils.drawLine(g2d, dot0, dotS);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        for (int i = 0; i < 2; ++i) {
            double lon = i == 0 ? this.lambdaC_ + 179.99999 : this.lambdaC_ - 179.99999;
            Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
            Point2D.Double dotN = this.transformLL2XY(lon, 90.0);
            Point2D.Double dotS = this.transformLL2XY(lon, -90.0);
            GraphicUtils.drawLine(g2d, dotN, dot0);
            GraphicUtils.drawLine(g2d, dot0, dotS);
        }
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + 179.99999, 90.0);
        GraphicUtils.drawLine(g2d, dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y);
        GraphicUtils.drawLine(g2d, dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
    }
}

