/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatPolyhedron;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatPolyhedron
extends NcArray2D
implements NcArrayLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double SMALL_VALUE = 1.0E-5;
    private VariableDS lonVarDS_;
    private VariableDS latVarDS_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private int cfIndex_;
    private int numXs_;
    private int numYs_;
    private int fDimIndex_ = -1;
    private int[][] npIndices_;
    private int[][] spIndices_;
    private int faces_;

    public NcArrayLonLatPolyhedron(NcVariable ncvar) throws NcException {
        super(ncvar);
        if (this.rank_ < 3) {
            throw new IllegalArgumentException("Variable must have at least three dimensions.");
        }
        this.createAxes();
        this.measureAxes();
        this.initGridArrays();
        this.initGridPoles();
    }

    @Override
    protected void createAxes() {
        VariableDS[] gridvars = NcArrayLonLatPolyhedron.getCoordinateVars(this.dataset_, this.njvarDS_);
        if (gridvars == null) {
            throw new NcNullException("Found null when retrieving coordinate vars.");
        }
        this.lonVarDS_ = gridvars[0];
        this.latVarDS_ = gridvars[1];
        Dimension fdim = this.lonVarDS_.getDimension(0);
        Dimension ydim = this.lonVarDS_.getDimension(1);
        Dimension xdim = this.lonVarDS_.getDimension(2);
        String fname = fdim.getShortName();
        String yname = ydim.getShortName();
        String xname = xdim.getShortName();
        this.numXs_ = xdim.getLength();
        this.numYs_ = ydim.getLength();
        this.faces_ = fdim.getLength();
        this.xAxis_ = new NcAxis(NcAxisType.GEOX, xname, this.numXs_);
        this.yAxis_ = new NcAxis(NcAxisType.GEOY, yname, this.numYs_);
        if (xname == null || xname.isEmpty()) {
            LOGGER.trace("xdim is unnamed; searching for var dims by size");
            Dimension d = this.njvarDS_.getDimension(this.rank_ - 1);
            if (d.getLength() == this.numXs_) {
                this.xDimIndex_ = this.rank_ - 1;
            }
            if ((d = this.njvarDS_.getDimension(this.rank_ - 2)).getLength() == this.numYs_) {
                this.yDimIndex_ = this.rank_ - 2;
            }
            if ((d = this.njvarDS_.getDimension(this.rank_ - 3)).getLength() == this.faces_) {
                this.fDimIndex_ = this.rank_ - 3;
            }
        } else {
            LOGGER.trace("searching for var dims by name");
            this.xDimIndex_ = this.findDimensionIndex(xname);
            this.yDimIndex_ = this.findDimensionIndex(yname);
            this.fDimIndex_ = this.findDimensionIndex(fname);
        }
        LOGGER.trace("** var dims for x {}, y {}, f {}", this.xDimIndex_, this.yDimIndex_, this.fDimIndex_);
        if (this.xDimIndex_ < 0) {
            throw new NcException("Could not find x/y dimension " + xname);
        }
        if (this.yDimIndex_ < 0) {
            throw new NcException("Could not find x/y dimension " + yname);
        }
        if (this.fDimIndex_ < 0) {
            throw new NcException("Could not find face dimension " + fname);
        }
    }

    private void initGridArrays() {
        try {
            this.lonArray_ = this.lonVarDS_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcException("Could not read lon coord var array");
        }
        try {
            this.latArray_ = this.latVarDS_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            throw new NcException("Could not read lat coord var array");
        }
    }

    private void initGridPoles() {
        LOGGER.trace("");
        ArrayList<Double> maxLats = new ArrayList<Double>(100);
        ArrayList<Double> minLats = new ArrayList<Double>(100);
        ArrayList<int[]> maxLatLoci = new ArrayList<int[]>(100);
        ArrayList<int[]> minLatLoci = new ArrayList<int[]>(100);
        double maxLat = 0.0;
        double minLat = 0.0;
        for (int iface = 0; iface < this.faces_; ++iface) {
            for (int j = 0; j < this.numYs_; ++j) {
                for (int i = 0; i < this.numXs_; ++i) {
                    int[] locus;
                    double lat = this.latitudeAt(iface, i, j);
                    if (lat > 80.0 && lat > maxLat) {
                        maxLat = lat;
                        locus = new int[]{iface, i, j};
                        maxLats.add(0, lat);
                        maxLatLoci.add(0, locus);
                        continue;
                    }
                    if (!(lat < -80.0) || !(lat < minLat)) continue;
                    minLat = lat;
                    locus = new int[]{iface, i, j};
                    minLats.add(0, lat);
                    minLatLoci.add(0, locus);
                }
                if (maxLats.size() > 90) {
                    maxLats.subList(5, maxLats.size()).clear();
                    maxLatLoci.subList(5, maxLatLoci.size()).clear();
                }
                if (minLats.size() <= 90) continue;
                minLats.subList(5, minLats.size()).clear();
                minLatLoci.subList(5, minLatLoci.size()).clear();
            }
        }
        if (maxLats.size() > 0) {
            if ((Double)maxLats.get(0) > 89.99999) {
                maxLats.subList(1, maxLats.size()).clear();
                maxLatLoci.subList(1, maxLatLoci.size()).clear();
            } else {
                maxLats.subList(4, maxLats.size()).clear();
                maxLatLoci.subList(4, maxLatLoci.size()).clear();
            }
            this.npIndices_ = (int[][])maxLatLoci.toArray((T[])new int[0][]);
        }
        if (minLats.size() > 0) {
            if ((Double)minLats.get(0) < -89.99999) {
                minLats.subList(1, minLats.size()).clear();
                minLatLoci.subList(1, minLatLoci.size()).clear();
            } else {
                minLats.subList(4, minLats.size()).clear();
                minLatLoci.subList(4, minLatLoci.size()).clear();
            }
            this.spIndices_ = (int[][])minLatLoci.toArray((T[])new int[0][]);
        }
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.xDimIndex_ || i == this.yDimIndex_ ? null : (i == this.fDimIndex_ ? null : this.ncvar_.getDimension(i));
        }
    }

    public int getFaceCount() {
        return this.faces_;
    }

    public void setFace(int face) {
        if (face < 0 || face >= this.faces_) {
            throw new IllegalArgumentException("Face must be in range [0," + (this.faces_ - 1) + "]");
        }
        this.setSliceIndex(this.fDimIndex_, face);
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        super.setSliceIndex(dimNum, index);
        if (dimNum == this.fDimIndex_) {
            this.cfIndex_ = index;
        }
    }

    public int[][] getNorthPoleCellIndices() {
        return this.npIndices_;
    }

    public int[][] getSouthPoleCellIndices() {
        return this.spIndices_;
    }

    public double valueAt(int face, int col, int row) {
        this.setFace(face);
        return super.valueAt(col, row);
    }

    public double longitudeAt(int face, int col, int row) {
        if (face < 0 || face >= this.faces_) {
            throw new IllegalArgumentException("Face must be in range [0," + (this.faces_ - 1) + "]");
        }
        this.lonIndex_.set(face, row, col);
        return this.lonArray_.getDouble(this.lonIndex_);
    }

    public double longitudeAt(int col, int row) {
        this.lonIndex_.set(this.cfIndex_, row, col);
        return this.lonArray_.getDouble(this.lonIndex_);
    }

    public double latitudeAt(int face, int col, int row) {
        if (face < 0 || face >= this.faces_) {
            throw new IllegalArgumentException("Face must be in range [0," + (this.faces_ - 1) + "]");
        }
        this.latIndex_.set(face, row, col);
        return this.latArray_.getDouble(this.latIndex_);
    }

    public double latitudeAt(int col, int row) {
        this.latIndex_.set(this.cfIndex_, row, col);
        double lat = this.latArray_.getDouble(this.latIndex_);
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return Double.NaN;
        }
        return lat;
    }

    public PointLL lonLatAt(int face, int col, int row) {
        if (face < 0 || face >= this.faces_ || row < 0 || row >= this.numYs_ || col < 0 || col >= this.numXs_) {
            return null;
        }
        return new PointLL(this.longitudeAt(face, col, row), this.latitudeAt(face, col, row));
    }

    public double[][] cornerLonLats(int col, int row) {
        return this.cornerLonLats(this.cfIndex_, col, row);
    }

    public double[][] cornerLonLats(int face, int col, int row) {
        double lat00;
        int i = col;
        int j = row;
        double lon00 = this.longitudeAt(face, col, row);
        if (NcArrayLonLat.isBadLonLat(lon00, lat00 = this.latitudeAt(face, col, row))) {
            return null;
        }
        boolean isNearPole = this.isNearPole(face, col, row);
        while (lon00 > 360.0) {
            lon00 -= 360.0;
        }
        while (lon00 < -360.0) {
            lon00 += 360.0;
        }
        int im1 = Math.max(i - 1, 0);
        int ip1 = Math.min(i + 1, this.numXs_ - 1);
        int jm1 = Math.max(j - 1, 0);
        int jp1 = Math.min(j + 1, this.numYs_ - 1);
        double lonMM = this.longitudeAt(face, im1, jm1);
        double lon0M = this.longitudeAt(face, i, jm1);
        double lonPM = this.longitudeAt(face, ip1, jm1);
        double lonP0 = this.longitudeAt(face, ip1, j);
        double lonPP = this.longitudeAt(face, ip1, jp1);
        double lon0P = this.longitudeAt(face, i, jp1);
        double lonMP = this.longitudeAt(face, im1, jp1);
        double lonM0 = this.longitudeAt(face, im1, j);
        double latMM = this.latitudeAt(face, im1, jm1);
        double lat0M = this.latitudeAt(face, i, jm1);
        double latPM = this.latitudeAt(face, ip1, jm1);
        double latP0 = this.latitudeAt(face, ip1, j);
        double latPP = this.latitudeAt(face, ip1, jp1);
        double lat0P = this.latitudeAt(face, i, jp1);
        double latMP = this.latitudeAt(face, im1, jp1);
        double latM0 = this.latitudeAt(face, im1, j);
        if (NcArrayLonLat.isBadLonLat(lonM0, latM0)) {
            lonM0 = lon00;
            latM0 = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonMM, latMM)) {
            lonMM = lon00;
            latMM = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lon0M, lat0M)) {
            lon0M = lon00;
            lat0M = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonPM, latPM)) {
            lonPM = lon00;
            latPM = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonP0, latP0)) {
            lonP0 = lon00;
            latP0 = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonPP, latPP)) {
            lonPP = lon00;
            latPP = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lon0P, lat0P)) {
            lon0P = lon00;
            lat0P = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonMP, latMP)) {
            lonMP = lon00;
            latMP = lat00;
        }
        if (lon00 - lonMM > 135.0) {
            lonMM += 360.0;
        }
        if (lon00 - lon0M > 135.0) {
            lon0M += 360.0;
        }
        if (lon00 - lonPM > 135.0) {
            lonPM += 360.0;
        }
        if (lon00 - lonP0 > 135.0) {
            lonP0 += 360.0;
        }
        if (lon00 - lonPP > 135.0) {
            lonPP += 360.0;
        }
        if (lon00 - lon0P > 135.0) {
            lon0P += 360.0;
        }
        if (lon00 - lonMP > 135.0) {
            lonMP += 360.0;
        }
        if (lon00 - lonM0 > 135.0) {
            lonM0 += 360.0;
        }
        if (lonMM - lon00 > 135.0) {
            lonMM -= 360.0;
        }
        if (lon0M - lon00 > 135.0) {
            lon0M -= 360.0;
        }
        if (lonPM - lon00 > 135.0) {
            lonPM -= 360.0;
        }
        if (lonP0 - lon00 > 135.0) {
            lonP0 -= 360.0;
        }
        if (lonPP - lon00 > 135.0) {
            lonPP -= 360.0;
        }
        if (lon0P - lon00 > 135.0) {
            lon0P -= 360.0;
        }
        if (lonMP - lon00 > 135.0) {
            lonMP -= 360.0;
        }
        if (lonM0 - lon00 > 135.0) {
            lonM0 -= 360.0;
        }
        if (lonM0 == lon00 && latM0 == lat00) {
            lonMM = lon0M - (lonPM - lon0M);
            latMM = lat0M - (latPM - lat0M);
            lonM0 = lon00 - (lonP0 - lon00);
            latM0 = lat00 - (latP0 - lat00);
            lonMP = lon0P - (lonPP - lon0P);
            latMP = lat0P - (latPP - lat0P);
        } else if (lonP0 == lon00 && latP0 == lat00) {
            lonPM = lon0M + (lon0M - lonMM);
            latPM = lat0M + (lat0M - latMM);
            lonP0 = lon00 + (lon00 - lonM0);
            latP0 = lat00 + (lat00 - latM0);
            lonPP = lon0P + (lon0P - lonMP);
            latPP = lat0P + (lat0P - latMP);
        }
        if (lon0M == lon00 && lat0M == lat00) {
            lonMM = lonM0 - (lonMP - lonM0);
            latMM = latM0 - (latMP - latM0);
            lon0M = lon00 - (lon0P - lon00);
            lat0M = lat00 - (lat0P - lat00);
            lonPM = lonP0 - (lonPP - lonP0);
            latPM = latP0 - (latPP - latP0);
        } else if (lon0P == lon00 && lat0P == lat00) {
            lonMP = lonM0 + (lonM0 - lonMM);
            latMP = latM0 + (latM0 - latMM);
            lon0P = lon00 + (lon00 - lon0M);
            lat0P = lat00 + (lat00 - lat0M);
            lonPP = lonP0 + (lonP0 - lonPM);
            latPP = latP0 + (latP0 - latPM);
        }
        double[] cornerMM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonMM, latMM, lonM0, latM0);
        double[] cornerPM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonPM, latPM, lonP0, latP0);
        double[] cornerPP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonPP, latPP, lonP0, latP0);
        double[] cornerMP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonMP, latMP, lonM0, latM0);
        if (isNearPole) {
            double llon;
            double llat;
            double d = llat = lat00 > 0.0 ? 90.0 : -90.0;
            if (this.isNearPole(face, im1, jm1)) {
                llon = lon00;
                cornerMM = new double[]{llon, llat};
            }
            if (this.isNearPole(face, ip1, jm1)) {
                llon = lon00;
                cornerPM = new double[]{llon, llat};
            }
            if (this.isNearPole(face, ip1, jp1)) {
                llon = lon00;
                cornerPP = new double[]{llon, llat};
            }
            if (isNearPole && this.isNearPole(face, im1, jp1)) {
                llon = lon00;
                cornerMP = new double[]{llon, llat};
            }
        }
        return new double[][]{cornerMM, cornerPM, cornerPP, cornerMP};
    }

    @Override
    protected void findExtremaImpl() {
        double[] range = this.getActualRangeAttrValues();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        for (int iface = 0; iface < this.faces_; ++iface) {
            for (int j = 0; j < this.numYs_; ++j) {
                for (int i = 0; i < this.numXs_; ++i) {
                    this.findExtremaTestValue(this.valueAt(iface, i, j));
                }
            }
        }
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double mindist = Double.POSITIVE_INFINITY;
        double cosLat = Math.cos(lat * (Math.PI / 180));
        double sinLat = Math.sin(lat * (Math.PI / 180));
        int face = -1;
        int col = -1;
        int row = -1;
        for (int iface = 0; iface < this.faces_; ++iface) {
            for (int i = 0; i < this.numXs_; ++i) {
                for (int j = 0; j < this.numYs_; ++j) {
                    double lat1;
                    double lon1;
                    try {
                        lon1 = this.longitudeAt(iface, i, j);
                        lat1 = this.latitudeAt(iface, i, j);
                    }
                    catch (Exception exc) {
                        continue;
                    }
                    if (Double.isNaN(lon1) || Double.isNaN(lat1)) continue;
                    double cosLat1 = Math.cos(lat1 * (Math.PI / 180));
                    double sinLat1 = Math.sin(lat1 * (Math.PI / 180));
                    double dlon = lon1 - lon;
                    double cosAngle = cosLat * cosLat1 * Math.cos(dlon * (Math.PI / 180)) + sinLat * sinLat1;
                    double angle = Math.acos(cosAngle);
                    if (angle == 0.0) {
                        return new int[]{i, j};
                    }
                    if (!(angle < mindist)) continue;
                    mindist = angle;
                    face = iface;
                    col = i;
                    row = j;
                }
            }
        }
        if (face < 0) {
            return null;
        }
        return new int[]{face, col, row};
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatPolyhedron();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int face = index[0];
        int col = index[1];
        int row = index[2];
        if (face < 0 || face >= this.faces_ || col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        PointLL ll = this.lonLatAt(face, col, row);
        double lon = ll.getLon();
        double lat = ll.getLat();
        LOGGER.trace("pt [{}, {}, {}], lat {}", face, col, row, lat);
        double gv = this.valueAt(face, col, row);
        sb.append("Face ").append("Cell [").append(face + 1).append(',').append(col + 1).append(',').append(row + 1).append(']').append(" at ").append('[').append(NcUtils.formatLongitude(lon)).append(' ').append(NcUtils.formatLatitude(lat)).append(']').append(", ").append("value = ").append(valFormat.sprintfx(gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        LOGGER.trace("----- -----");
        LOGGER.trace("{}", (Object)ncvar.getShortName());
        NcDataset ncd = ncvar.getDataset();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatPolyhedron.canGridVariable(ncd, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS) {
        LOGGER.trace("----- -----");
        LOGGER.trace("{}", (Object)varDS.getShortName());
        VariableDS[] gridvars = NcArrayLonLatPolyhedron.getCoordinateVars(ncd, varDS);
        boolean canGrid = gridvars != null;
        LOGGER.trace("- canGrid {}", (Object)canGrid);
        return canGrid;
    }

    private static VariableDS[] getCoordinateVars(NcDataset ncd, VariableDS varDS) {
        VariableDS[] vars = NcArrayLonLatPolyhedron.getCoordinateVarsCS(varDS);
        if (vars != null) {
            LOGGER.trace("getCoordinateVarsCS apparently successful");
            return vars;
        }
        return NcArrayLonLatPolyhedron.getCoordinateVarsNoCS(ncd, varDS);
    }

    private static VariableDS[] getCoordinateVarsCS(VariableDS varDS) {
        List csList = varDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            LOGGER.trace("No/empty csList");
            return null;
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        if (cs == null) {
            LOGGER.trace("CS 0 is null");
            return null;
        }
        LOGGER.trace("Found a coordinate system to work with");
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null && latax == null) {
            return null;
        }
        LOGGER.trace("lon {}, lat {}", (Object)lonax.getShortName(), (Object)latax.getShortName());
        if (NcArrayLonLatPolyhedron.validateCoordinateVars(varDS, lonax, latax)) {
            return new VariableDS[]{lonax, latax};
        }
        return null;
    }

    private static VariableDS[] getCoordinateVarsNoCS(NcDataset ncd, VariableDS varDS) {
        String[] tokens = NcUtils.parseCoordinatesAttribute(varDS);
        if (tokens == null || tokens.length == 0) {
            LOGGER.trace("No/empty coordinates attribute");
            return null;
        }
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        for (String token : tokens) {
            LOGGER.trace("-- looking for coords var '{}'", (Object)token);
            VariableDS tokenVar = ncd.getVariableDS(token);
            if (tokenVar == null) {
                LOGGER.trace("-- Found no var named '{}'", (Object)token);
                continue;
            }
            String unitsStr = NcUtils.getUnitsStr(tokenVar);
            LOGGER.trace("-- var '{}' has units '{}'", (Object)tokenVar.getShortName(), (Object)unitsStr);
            if (NcUnitUtils.isDegreesEast(unitsStr) || "longitude".equalsIgnoreCase(tokenVar.getShortName())) {
                LOGGER.trace("-- Found var '{}' -- appears to be lon var", (Object)token);
                lonVarDS = tokenVar;
                continue;
            }
            if (NcUnitUtils.isDegreesNorth(unitsStr) || "latitude".equalsIgnoreCase(tokenVar.getShortName())) {
                LOGGER.trace("-- Found var '{}' -- appears to be lat var", (Object)token);
                latVarDS = tokenVar;
                continue;
            }
            LOGGER.trace("-- Found var '{}' but it appears to be neither lon or lat", (Object)token);
        }
        if (lonVarDS == null || latVarDS == null) {
            return null;
        }
        if (NcArrayLonLatPolyhedron.validateCoordinateVars(varDS, lonVarDS, latVarDS)) {
            return new VariableDS[]{lonVarDS, latVarDS};
        }
        return null;
    }

    private static boolean validateCoordinateVars(VariableDS varDS, VariableDS lonax, VariableDS latax) {
        LOGGER.trace("");
        if (lonax == null || latax == null) {
            LOGGER.trace("-- lonax and/or latax is null");
            return false;
        }
        LOGGER.trace("-- lonax {}, rank {}", (Object)lonax.getShortName(), (Object)lonax.getRank());
        LOGGER.trace("-- latax {}, rank {}", (Object)latax.getShortName(), (Object)latax.getRank());
        int[] lonshape = lonax.getShape();
        if (lonshape.length != 3 || lonshape[0] < 2 || lonshape[1] < 2 || lonshape[2] < 2) {
            LOGGER.trace("-- lonax looks unusable");
            return false;
        }
        int[] latshape = latax.getShape();
        if (latshape.length != 3 || latshape[0] < 2 || latshape[1] < 2 || latshape[2] < 2) {
            LOGGER.trace("-- latax looks unusable");
            return false;
        }
        if (lonshape[0] != latshape[0] || lonshape[1] != latshape[1] || lonshape[2] != latshape[2]) {
            LOGGER.trace("-- lonax latax shape mismatch");
            return false;
        }
        Dimension d11 = lonax.getDimension(0);
        Dimension d12 = lonax.getDimension(1);
        Dimension d13 = lonax.getDimension(2);
        Dimension d21 = latax.getDimension(0);
        Dimension d22 = latax.getDimension(1);
        Dimension d23 = latax.getDimension(2);
        if (!(d11.equals(d21) && d12.equals(d22) && d13.equals(d23))) {
            LOGGER.trace("-- lonax latax dimension mismatch");
            return false;
        }
        String dim1Name = d11.getShortName();
        if (!("face".equalsIgnoreCase(dim1Name) || "tile".equalsIgnoreCase(dim1Name) || "nface".equalsIgnoreCase(dim1Name) || "ntile".equalsIgnoreCase(dim1Name))) {
            LOGGER.trace("Lon var's first dimension has 'bad' name {}", (Object)dim1Name);
            return false;
        }
        int didx1 = NcUtils.findDimensionIndex(varDS, d11);
        int didx2 = NcUtils.findDimensionIndex(varDS, d12);
        int didx3 = NcUtils.findDimensionIndex(varDS, d13);
        if (didx1 < 0 || didx2 < 0 || didx3 < 0) {
            LOGGER.trace("Data variable does not seem to include lon var's dimensions");
            return false;
        }
        LOGGER.trace("Face count {}", (Object)lonshape[0]);
        return true;
    }

    public boolean isNearPole(int iface, int iii, int jjj) {
        int i;
        for (i = 0; i < this.npIndices_.length; ++i) {
            if (this.npIndices_[i][0] != iface || this.npIndices_[i][1] != iii || this.npIndices_[i][2] != jjj) continue;
            return true;
        }
        for (i = 0; i < this.spIndices_.length; ++i) {
            if (this.spIndices_[i][0] != iface || this.spIndices_[i][1] != iii || this.spIndices_[i][2] != jjj) continue;
            return true;
        }
        return false;
    }

    @Override
    public LonLatEdges getLonLatEdges() {
        return LonLatEdges.ENTIRE_GLOBE;
    }
}

