from mipylib.numeric import stats

x = arange(-5, 5, 0.01)
aa = [1, 2, 5, 10000]
ss = ['-b', '-r', '-c', '-g']

#PDF
subplot(1,2,1)
for a,s in zip(aa,ss):
    y = stats.t.pdf(x, a)
    plot(x, y, s, linewidth=1, label=r'df = %i' % a)
#grid(True)
legend(loc='upper left', facecolor='w')
ylim(0, 0.4)
xlim(-5, 5)
title('PDF')

#CDF
subplot(1,2,2)
for a,s in zip(aa,ss):
    y = stats.t.cdf(x, a)
    plot(x, y, s, linewidth=1, label=r'df = %i' % a)
#grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 1)
xlim(-5, 5)
title('CDF')

suptitle('Student-T distribution')