from mipylib.numeric import stats

x = arange(0.01, 5, 0.01)
aa = [0.5, 1, 1.5, 2.5]
ss = ['-b', '-r', '-c', '-g']

#PDF
subplot(1,2,1)
for a,s in zip(aa,ss):
    y = stats.expon.pdf(x, a)
    plot(x, y, s, linewidth=2, label=r'$\lambda = %.1f$' % a)
grid(True)
legend(loc='upper right', facecolor='w')
ylim(0, 2)
xlim(0, 5)
title('PDF')

#CDF
subplot(1,2,2)
for a,s in zip(aa,ss):
    y = stats.expon.cdf(x, a)
    plot(x, y, s, linewidth=2, label=r'$\lambda = %.1f$' % a)
grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 1)
xlim(0, 5)
title('CDF')

suptitle('Exponential distribution')