/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.exception;

import org.apache.commons.math4.legacy.exception.util.ExceptionContext;
import org.apache.commons.math4.legacy.exception.util.ExceptionContextProvider;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;

public class NullArgumentException
extends NullPointerException
implements ExceptionContextProvider {
    private static final long serialVersionUID = 20150225L;
    private final ExceptionContext context = new ExceptionContext(this);

    public NullArgumentException() {
        this(LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
    }

    public NullArgumentException(Localizable pattern, Object ... arguments) {
        this.context.addMessage(pattern, arguments);
    }

    @Override
    public ExceptionContext getContext() {
        return this.context;
    }

    @Override
    public String getMessage() {
        return this.context.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.context.getLocalizedMessage();
    }

    public static void check(Object o, Localizable pattern, Object ... args) {
        if (o == null) {
            throw new NullArgumentException(pattern, args);
        }
    }

    public static void check(Object o) {
        if (o == null) {
            throw new NullArgumentException();
        }
    }
}

