/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.radar.CCRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.GenericHeader;
import org.meteoinfo.data.meteodata.radar.PARadarDataInfo;
import org.meteoinfo.data.meteodata.radar.RadarDataType;
import org.meteoinfo.data.meteodata.radar.SABRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.SCRadarDataInfo;
import org.meteoinfo.data.meteodata.radar.StandardRadarDataInfo;

public class RadarDataUtil {
    public static RadarDataType getRadarDataType(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            byte[] bytes = new byte[136];
            raf.read(bytes);
            byte[] magicBytes = Arrays.copyOf(bytes, 4);
            int magic = DataConvert.bytes2Int((byte[])magicBytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            if (magic == 1297371986) {
                return RadarDataType.STANDARD;
            }
            magicBytes = Arrays.copyOfRange(bytes, 14, 16);
            if (Arrays.equals(magicBytes, new byte[]{1, 0})) {
                return RadarDataType.SAB;
            }
            magicBytes = Arrays.copyOfRange(bytes, 8, 12);
            if (Arrays.equals(magicBytes, new byte[]{16, 0, 0, 0})) {
                return RadarDataType.PA;
            }
            String radarT = new String(bytes);
            if (radarT.contains("CINRAD/SC") || radarT.contains("CINRAD/CD")) {
                return RadarDataType.SC;
            }
            if (radarT.contains("CINRADC")) {
                return RadarDataType.CC;
            }
            if (!radarT.contains("CINRADC") && radarT.contains("CINRAD/CC")) {
                return RadarDataType.CC20;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static InputStream getInputStream(String fileName) throws IOException {
        String fileExtent;
        switch (fileExtent = FilenameUtils.getExtension((String)fileName).toLowerCase()) {
            case "bz2": {
                return new BZip2CompressorInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
            }
            case "gz": {
                return new GzipCompressorInputStream((InputStream)new FileInputStream(fileName));
            }
        }
        return new BufferedInputStream(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));
    }

    public static RadarDataType getRadarDataType(String fileName) {
        try {
            InputStream inputStream = RadarDataUtil.getInputStream(fileName);
            byte[] bytes = new byte[136];
            inputStream.read(bytes);
            inputStream.close();
            byte[] magicBytes = Arrays.copyOf(bytes, 4);
            int magic = DataConvert.bytes2Int((byte[])magicBytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            if (magic == 1297371986) {
                byte[] inBytes = Arrays.copyOf(bytes, GenericHeader.length);
                GenericHeader genericHeader = new GenericHeader(inBytes);
                switch (genericHeader.genericType) {
                    case 1: {
                        return RadarDataType.STANDARD;
                    }
                    case 16: {
                        return RadarDataType.PA;
                    }
                }
                return null;
            }
            String radarT = new String(bytes);
            if (radarT.contains("CINRAD/SC") || radarT.contains("CINRAD/CD")) {
                return RadarDataType.SC;
            }
            if (radarT.contains("CINRADC")) {
                return RadarDataType.CC;
            }
            if (!radarT.contains("CINRADC") && radarT.contains("CINRAD/CC")) {
                return RadarDataType.CC20;
            }
            magicBytes = Arrays.copyOf(bytes, 128);
            SABRadarDataInfo.RadialHeader radialHeader = new SABRadarDataInfo.RadialHeader(magicBytes);
            if (radialHeader.messageType != 1) {
                return null;
            }
            if (radialHeader.mSecond > 86400000) {
                return null;
            }
            LocalDateTime dateTime = radialHeader.getDateTime();
            if (dateTime.getYear() >= 1990 && dateTime.getYear() <= LocalDateTime.now().getYear()) {
                return RadarDataType.SAB;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static DataInfo getDataInfo(RadarDataType radarDataType) {
        if (radarDataType == null) {
            return null;
        }
        switch (radarDataType) {
            case STANDARD: {
                return new StandardRadarDataInfo();
            }
            case PA: {
                return new PARadarDataInfo();
            }
            case SAB: {
                return new SABRadarDataInfo();
            }
            case CC: {
                return new CCRadarDataInfo();
            }
            case SC: {
                return new SCRadarDataInfo();
            }
        }
        return null;
    }

    public static DataInfo getDataInfo(RandomAccessFile raf) {
        RadarDataType radarDataType = RadarDataUtil.getRadarDataType(raf);
        return RadarDataUtil.getDataInfo(radarDataType);
    }

    public static DataInfo getDataInfo(String fileName) {
        RadarDataType radarDataType = RadarDataUtil.getRadarDataType(fileName);
        return RadarDataUtil.getDataInfo(radarDataType);
    }
}

