/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.transform;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.math.transform.FastFourierTransform;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;

public class FastFourierTransformND
extends FastFourierTransform {
    public FastFourierTransformND() {
    }

    public FastFourierTransformND(boolean inverse) {
        super(inverse);
    }

    @Override
    public Array apply(Array f) {
        ArrayList<Integer> axes = new ArrayList<Integer>();
        for (int i = f.getRank() - 1; i >= 0; --i) {
            axes.add(i);
        }
        return this.apply(f, axes);
    }

    public Array apply(Array f, List<Integer> axes) {
        f = f.copyIfView();
        int[] shape = f.getShape();
        Array r = Array.factory((DataType)DataType.COMPLEX, (int[])shape);
        try {
            FastFourierTransform fastFourierTransform = new FastFourierTransform(this.normalization, this.inverse);
            int axisIdx = 0;
            for (int axis : axes) {
                if (axis < 0) {
                    axis = shape.length + axis;
                }
                Index indexr = r.getIndex();
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = indexr.getCurrentCounter();
                    if (current[axis] == 0) {
                        ArrayList<Range> ranges = new ArrayList<Range>();
                        for (int j = 0; j < shape.length; ++j) {
                            if (j == axis) {
                                ranges.add(new Range(0, shape[j] - 1, 1));
                                continue;
                            }
                            ranges.add(new Range(current[j], current[j], 1));
                        }
                        Array data = axisIdx == 0 ? ArrayMath.section((Array)f, ranges).copy() : ArrayMath.section((Array)r, ranges).copy();
                        data = fastFourierTransform.apply(data);
                        ArrayMath.setSection((Array)r, ranges, (Array)data);
                    }
                    indexr.incr();
                    ++i;
                }
                ++axisIdx;
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        return r;
    }
}

