/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats.kde;

import com.google.common.primitives.Doubles;
import java.util.List;
import java.util.Random;
import org.apache.commons.math4.core.jdkmath.AccurateMath;

public class Helpers {
    private static Random ms_rand = new Random(System.currentTimeMillis());

    public static int nextInt(int n) {
        return ms_rand.nextInt(n);
    }

    public static double euclidianDistance(double[] point1, double[] point2) {
        double sum = 0.0;
        for (int d = 0; d < point1.length; ++d) {
            sum += AccurateMath.pow((double)(point1[d] - point2[d]), (int)2);
        }
        return Math.sqrt(sum);
    }

    public static double logSumExp(List<Double> valsLogSpace) {
        return Helpers.logSumExp(Doubles.toArray(valsLogSpace));
    }

    public static double logSumExp(double[] valsLogSpace) {
        double A = Helpers.max(valsLogSpace);
        double sum = 0.0;
        for (double v : valsLogSpace) {
            double expVal = v - A;
            sum += Math.exp(expVal);
        }
        return A + Math.log(sum);
    }

    public static double[] makeSequence(double start, double end, int length) {
        if (start > end) {
            System.err.println("Cant make sequance with start > end");
            return null;
        }
        double[] seq = new double[length];
        double by = (end - start) / (double)(length - 1);
        double value = start;
        int i = 0;
        while (i < length) {
            seq[i] = value;
            ++i;
            value += by;
        }
        return seq;
    }

    public static int maxInd(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        int maxInd = -1;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            maxInd = i;
            max = a[i];
        }
        return maxInd;
    }

    public static double max(double[] a) {
        return a[Helpers.maxInd(a)];
    }
}

