/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.fitting;

import org.meteoinfo.math.fitting.OLSTrendLine;

public class PolyTrendLine
extends OLSTrendLine {
    final int degree;

    public PolyTrendLine(int degree) {
        if (degree < 0) {
            throw new IllegalArgumentException("The degree of the polynomial must not be negative");
        }
        this.degree = degree;
    }

    @Override
    protected double[] xVector(double x) {
        double[] poly = new double[this.degree + 1];
        double xi = 1.0;
        for (int i = 0; i <= this.degree; ++i) {
            poly[i] = xi;
            xi *= x;
        }
        return poly;
    }

    @Override
    protected boolean logY() {
        return false;
    }
}

