/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.DefaultThemeMeta;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeMetaListener;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.gui.dock.themes.nostack.NoStackAcceptance;
import bibliothek.gui.dock.themes.nostack.NoStackTitleFactory;
import bibliothek.gui.dock.title.DockTitleFactory;

public class NoStackTheme
implements DockTheme {
    private DockTheme base;
    private NoStackAcceptance acceptance = new NoStackAcceptance();

    public static <T extends DockTheme> ThemeFactory getFactory(Class<T> theme) {
        final ThemePropertyFactory<T> factory = new ThemePropertyFactory<T>(theme);
        return new ThemeFactory(){

            @Override
            public DockTheme create(DockController controller) {
                return new NoStackTheme(factory.create(controller));
            }

            @Override
            public ThemeMeta createMeta(DockController controller) {
                return new Meta(this, controller, factory.createMeta(controller));
            }
        };
    }

    public NoStackTheme(DockTheme base) {
        if (base == null) {
            throw new IllegalArgumentException("Base theme must not be null");
        }
        this.base = base;
    }

    @Override
    public Combiner getCombiner(DockStation station) {
        return this.base.getCombiner(station);
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation station) {
        return this.base.getDisplayFactory(station);
    }

    @Override
    public StationPaint getPaint(DockStation station) {
        return this.base.getPaint(station);
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController controller) {
        return new NoStackTitleFactory(this.base.getTitleFactory(controller));
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController controller) {
        return this.base.getMovingImageFactory(controller);
    }

    @Override
    public DockableSelection getDockableSelection(DockController controller) {
        return this.base.getDockableSelection(controller);
    }

    @Override
    public void install(DockController controller, DockThemeExtension[] extensions) {
        this.base.install(controller, extensions);
        controller.addAcceptance(this.acceptance);
    }

    @Override
    public void uninstall(DockController controller) {
        this.base.uninstall(controller);
        controller.removeAcceptance(this.acceptance);
    }

    private static class Meta
    extends DefaultThemeMeta
    implements ThemeMetaListener {
        private ThemeMeta meta;

        public Meta(ThemeFactory factory, DockController controller, ThemeMeta meta) {
            super(factory, controller, "theme.small", "theme.small.description", meta.getAuthors(), meta.getWebpages());
            this.meta = meta;
        }

        @Override
        public void addListener(ThemeMetaListener listener) {
            if (!this.hasListeners()) {
                this.meta.addListener(this);
            }
            super.addListener(listener);
        }

        @Override
        public void removeListener(ThemeMetaListener listener) {
            super.removeListener(listener);
            if (!this.hasListeners()) {
                this.meta.removeListener(this);
            }
        }

        @Override
        public String getName() {
            String small = super.getName();
            String factory = this.meta.getName();
            return small + " \"" + factory + "\"";
        }

        @Override
        public String[] getAuthors() {
            String[] authors = this.getAuthors();
            String BENI = "Benjamin Sigg";
            for (String author : authors) {
                if (!author.equals("Benjamin Sigg")) continue;
                return authors;
            }
            String[] result = new String[authors.length + 1];
            System.arraycopy(authors, 0, result, 0, authors.length);
            result[authors.length] = "Benjamin Sigg";
            return result;
        }

        @Override
        public void authorsChanged(ThemeMeta meta) {
            this.setAuthors(meta.getAuthors());
        }

        @Override
        public void webpagesChanged(ThemeMeta meta) {
            this.setWebpages(meta.getWebpages());
        }

        @Override
        public void descriptionChanged(ThemeMeta meta) {
        }

        @Override
        public void nameChanged(ThemeMeta meta) {
            this.fireNameChanged();
        }
    }
}

