/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.CStationContainerListener;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.common.location.CMinimizedLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.util.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;

public class CContentArea
extends JPanel
implements CStationContainer {
    public static final Path TYPE_ID_CENTER = new Path(new String[]{"dock", "CContentArea", "center"});
    public static final Path TYPE_ID_MINIMIZE = new Path(new String[]{"dock", "CContentArea", "minimize"});
    private CenterStation center;
    private MinimizeStation north;
    private MinimizeStation south;
    private MinimizeStation east;
    private MinimizeStation west;
    private Component[] cornerComponents = new Component[8];
    private String uniqueId;
    private CControl control;
    private CStation<?>[] stations;

    public CContentArea(CControl control, String uniqueId) {
        this.control = control;
        this.uniqueId = uniqueId;
        CBaseLocation base = new CBaseLocation(this);
        this.center = new CenterStation(this.getCenterIdentifier(), base.normal());
        this.north = new MinimizeStation(this.getNorthIdentifier(), new CMinimizedLocation(base, Side.NORTH));
        this.south = new MinimizeStation(this.getSouthIdentifier(), new CMinimizedLocation(base, Side.SOUTH));
        this.east = new MinimizeStation(this.getEastIdentifier(), new CMinimizedLocation(base, Side.EAST));
        this.west = new MinimizeStation(this.getWestIdentifier(), new CMinimizedLocation(base, Side.WEST));
        this.center.getStation().setExpandOnDoubleclick(false);
        this.north.setDirection(FlapDockStation.Direction.SOUTH);
        this.south.setDirection(FlapDockStation.Direction.NORTH);
        this.east.setDirection(FlapDockStation.Direction.WEST);
        this.west.setDirection(FlapDockStation.Direction.EAST);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.center.getStation()), "Center");
        this.add((Component)this.north, "North");
        this.add((Component)this.south, "South");
        this.add((Component)this.east, "East");
        this.add((Component)this.west, "West");
        this.stations = new CStation[]{this.north, this.south, this.east, this.west, this.center};
    }

    protected void addStations(CStation<?> ... stations) {
        CStation[] temp = new CStation[this.stations.length + stations.length];
        System.arraycopy(this.stations, 0, temp, 0, this.stations.length);
        System.arraycopy(stations, 0, temp, this.stations.length, stations.length);
        this.stations = temp;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void addStationContainerListener(CStationContainerListener listener) {
    }

    @Override
    public void removeStationContainerListener(CStationContainerListener listener) {
    }

    public CControl getControl() {
        return this.control;
    }

    public CStation<?>[] getStations() {
        CStation[] copy = new CStation[this.stations.length];
        System.arraycopy(this.stations, 0, copy, 0, this.stations.length);
        return copy;
    }

    @Override
    public int getStationCount() {
        return this.stations.length;
    }

    @Override
    public CStation<?> getStation(int index) {
        return this.stations[index];
    }

    public int indexOf(CStation<?> child) {
        for (int i = 0; i < this.stations.length; ++i) {
            if (this.stations[i] != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    public CStation<?> getDefaultStation() {
        return this.center;
    }

    @Override
    public CStation<?> getDefaultStation(ExtendedMode mode) {
        if (mode == ExtendedMode.MINIMIZED) {
            return this.north;
        }
        if (mode == ExtendedMode.NORMALIZED) {
            return this.center;
        }
        if (mode == ExtendedMode.MAXIMIZED) {
            return this.center;
        }
        return null;
    }

    public void deploy(CGrid grid) {
        this.getCenter().dropTree((SplitDockTree)grid.toTree());
    }

    public void setCornerComponent(Component component, Corner corner, boolean horizontal) {
        int index = corner.ordinal() * 2;
        if (horizontal) {
            ++index;
        }
        if (this.cornerComponents[index] != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (horizontal) {
                        this.north.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.west.remove(this.cornerComponents[index]);
                    break;
                }
                case NORTH_EAST: {
                    if (horizontal) {
                        this.north.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.east.remove(this.cornerComponents[index]);
                    break;
                }
                case SOUTH_WEST: {
                    if (horizontal) {
                        this.south.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.west.remove(this.cornerComponents[index]);
                    break;
                }
                case SOUTH_EAST: {
                    if (horizontal) {
                        this.south.remove(this.cornerComponents[index]);
                        break;
                    }
                    this.east.remove(this.cornerComponents[index]);
                }
            }
        }
        this.cornerComponents[index] = component;
        if (component != null) {
            switch (corner) {
                case NORTH_WEST: {
                    if (horizontal) {
                        this.north.add(component, "West");
                        break;
                    }
                    this.west.add(component, "North");
                    break;
                }
                case NORTH_EAST: {
                    if (horizontal) {
                        this.north.add(component, "East");
                        break;
                    }
                    this.east.add(component, "North");
                    break;
                }
                case SOUTH_WEST: {
                    if (horizontal) {
                        this.south.add(component, "West");
                        break;
                    }
                    this.west.add(component, "South");
                    break;
                }
                case SOUTH_EAST: {
                    if (horizontal) {
                        this.south.add(component, "East");
                        break;
                    }
                    this.east.add(component, "South");
                }
            }
        }
    }

    public Component getCornerComponent(Corner corner, boolean horizontal) {
        int index = corner.ordinal() * 2;
        if (horizontal) {
            ++index;
        }
        return this.cornerComponents[index];
    }

    public void setMinimumAreaSize(Dimension size) {
        this.north.getStation().setMinimumSize(size);
        this.south.getStation().setMinimumSize(size);
        this.west.getStation().setMinimumSize(size);
        this.east.getStation().setMinimumSize(size);
    }

    public SplitDockStation getCenter() {
        return this.center.getStation();
    }

    public CGridArea getCenterArea() {
        return this.center;
    }

    public FlapDockStation getNorth() {
        return this.north.getStation();
    }

    public CMinimizeArea getNorthArea() {
        return this.north;
    }

    public FlapDockStation getSouth() {
        return this.south.getStation();
    }

    public CMinimizeArea getSouthArea() {
        return this.south;
    }

    public FlapDockStation getEast() {
        return this.east.getStation();
    }

    public CMinimizeArea getEastArea() {
        return this.east;
    }

    public FlapDockStation getWest() {
        return this.west.getStation();
    }

    public CMinimizeArea getWestArea() {
        return this.west;
    }

    public String getCenterIdentifier() {
        return CContentArea.getCenterIdentifier(this.uniqueId);
    }

    public static String getCenterIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " center";
    }

    public String getNorthIdentifier() {
        return CContentArea.getNorthIdentifier(this.uniqueId);
    }

    public static String getNorthIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " north";
    }

    public String getSouthIdentifier() {
        return CContentArea.getSouthIdentifier(this.uniqueId);
    }

    public static String getSouthIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " south";
    }

    public String getEastIdentifier() {
        return CContentArea.getEastIdentifier(this.uniqueId);
    }

    public static String getEastIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " east";
    }

    public String getWestIdentifier() {
        return CContentArea.getWestIdentifier(this.uniqueId);
    }

    public static String getWestIdentifier(String uniqueCenterId) {
        return uniqueCenterId + " west";
    }

    @Override
    public CStation<?> getMatchingStation(CStationContainer container, CStation<?> station) {
        int index;
        CContentArea other;
        if (container == this) {
            return station;
        }
        if (container instanceof CContentArea && (other = (CContentArea)container).getStationCount() == this.getStationCount() && (index = other.indexOf(station)) != -1) {
            return this.getStation(index);
        }
        return null;
    }

    private class CenterStation
    extends CGridArea {
        private CLocation location;

        public CenterStation(String id, CLocation location) {
            super(CContentArea.this.control, id);
            this.location = location;
        }

        @Override
        public Path getTypeId() {
            return TYPE_ID_CENTER;
        }

        @Override
        public CLocation getStationLocation() {
            return this.location;
        }
    }

    private class MinimizeStation
    extends CMinimizeArea {
        private CLocation location;

        public MinimizeStation(String id, CLocation location) {
            this.location = location;
            this.init(CContentArea.this.control, id);
        }

        @Override
        public Path getTypeId() {
            return TYPE_ID_MINIMIZE;
        }

        @Override
        public CLocation getStationLocation() {
            return this.location;
        }
    }

    public static enum Corner {
        SOUTH_EAST,
        SOUTH_WEST,
        NORTH_EAST,
        NORTH_WEST;

    }
}

