/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.ojalgo.type.function.AutoConsumer;

final class QueuedConsumer<T>
implements AutoConsumer<T> {
    private volatile boolean myActive;
    private final int myBatchSize;
    private final Consumer<T>[] myConsumers;
    private final Future<?>[] myFutures;
    private final BlockingQueue<T> myQueue;

    QueuedConsumer(ExecutorService executor, BlockingQueue<T> queue, Consumer<T> ... consumers) {
        this.myQueue = queue;
        this.myConsumers = consumers;
        this.myBatchSize = Math.max(3, queue.remainingCapacity() / (2 + consumers.length));
        this.myActive = true;
        this.myFutures = new Future[consumers.length];
        for (int i = 0; i < consumers.length; ++i) {
            this.myFutures[i] = executor.submit(new Worker<T>(this, consumers[i]));
        }
    }

    @Override
    public void close() throws Exception {
        this.myActive = false;
        try {
            for (int i = 0; i < this.myFutures.length; ++i) {
                this.myFutures[i].get();
                if (!(this.myConsumers[i] instanceof AutoCloseable)) continue;
                ((AutoCloseable)((Object)this.myConsumers[i])).close();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
    }

    @Override
    public void write(T item) {
        try {
            this.myQueue.put(item);
        }
        catch (InterruptedException cause) {
            throw new RuntimeException(cause);
        }
    }

    int drainTo(List<T> batchContainer) {
        return this.myQueue.drainTo(batchContainer, this.myBatchSize);
    }

    boolean isMoreToCome() {
        return this.myActive || this.myQueue.size() > 0;
    }

    List<T> newBatchContainer() {
        return new ArrayList(this.myBatchSize);
    }

    static final class Worker<T>
    implements Runnable {
        private final Consumer<T> myConsumer;
        private final QueuedConsumer<T> myParent;

        Worker(QueuedConsumer<T> parent, Consumer<T> consumer) {
            this.myParent = parent;
            this.myConsumer = consumer;
        }

        @Override
        public void run() {
            List<T> batchContainer = this.myParent.newBatchContainer();
            while (this.myParent.drainTo(batchContainer) != 0 || this.myParent.isMoreToCome()) {
                if (batchContainer.size() != 0) {
                    if (this.myConsumer instanceof AutoConsumer) {
                        ((AutoConsumer)this.myConsumer).writeBatch(batchContainer);
                    } else {
                        for (T item : batchContainer) {
                            this.myConsumer.accept(item);
                        }
                    }
                    batchContainer.clear();
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException cause) {
                    throw new RuntimeException(cause);
                }
            }
        }
    }
}

