/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.scedasticity;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.SampleSet;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;

public interface ScedasticityModel {
    public double getMean();

    default public double getStandardDeviation() {
        return PrimitiveMath.SQRT.invoke(this.getVariance());
    }

    public double getVariance();

    public void initialise(double var1, double var3);

    public void update(double var1);

    default public PrimitiveSeries variances(PrimitiveSeries values) {
        SampleSet statistics = SampleSet.wrap(values);
        double mean = statistics.getMean();
        double variance = statistics.getVariance();
        this.initialise(mean, variance);
        double[] data = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            data[i] = this.getVariance();
            this.update(values.value(i));
        }
        return DataSeries.wrap(data);
    }
}

