/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.Spliterators;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.operation.COPY;
import org.ojalgo.array.operation.Exchange;
import org.ojalgo.array.operation.FillAll;
import org.ojalgo.array.operation.FillMatchingSingle;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationUnary;
import org.ojalgo.array.operation.OperationVoid;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;

public abstract class ReferenceTypeArray<N extends Comparable<N>>
extends PlainArray<N>
implements Mutate1D.Sortable {
    public final N[] data;

    ReferenceTypeArray(DenseArray.Factory<N> factory, int length) {
        super(factory, length);
        Scalar.Factory scalarFactory = factory.scalar();
        this.data = scalarFactory.newArrayInstance(length);
        Comparable zero = (Comparable)scalarFactory.zero().get();
        Arrays.fill(this.data, zero);
    }

    ReferenceTypeArray(DenseArray.Factory<N> factory, N[] data) {
        super(factory, data.length);
        this.data = data;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof ReferenceTypeArray)) {
            return false;
        }
        ReferenceTypeArray other = (ReferenceTypeArray)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        FillMatchingSingle.fill(this.data, values, this.factory().scalar());
    }

    @Override
    public void fillMatching(Access1D<N> left, BinaryFunction<N> function, Access1D<N> right) {
        int limit = MissingMath.toMinIntExact(this.count(), left.count(), right.count());
        for (int i = 0; i < limit; ++i) {
            this.data[i] = function.invoke(left.get(i), right.get(i));
        }
    }

    @Override
    public void fillMatching(UnaryFunction<N> function, Access1D<N> arguments) {
        int limit = MissingMath.toMinIntExact(this.count(), arguments.count());
        for (int i = 0; i < limit; ++i) {
            this.data[i] = function.invoke(arguments.get(i));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + Arrays.hashCode(this.data);
    }

    @Override
    public final void reset() {
        Arrays.fill(this.data, this.valueOf(PrimitiveMath.ZERO));
    }

    public final Spliterator<N> spliterator() {
        return Spliterators.spliterator(this.data, 0, this.data.length, 1040);
    }

    protected final N[] copyOfData() {
        return (Comparable[])COPY.copyOf(this.data);
    }

    @Override
    protected final void exchange(int firstA, int firstB, int step, int count) {
        Exchange.exchange(this.data, (int)firstA, (int)firstB, (int)step, (int)count);
    }

    @Override
    protected final void fill(int first, int limit, int step, N value) {
        FillAll.fill(this.data, (int)first, (int)limit, (int)step, value);
    }

    @Override
    protected final void fill(int first, int limit, int step, NullaryFunction<?> supplier) {
        FillAll.fill(this.data, (int)first, (int)limit, (int)step, supplier, this.factory().scalar());
    }

    @Override
    protected final void fillOne(int index, N value) {
        this.data[index] = value;
    }

    @Override
    protected final void fillOne(int index, NullaryFunction<?> supplier) {
        this.data[index] = this.valueOf((Comparable<?>)supplier.get());
    }

    @Override
    protected final N get(int index) {
        return this.data[index];
    }

    @Override
    protected final void modify(int first, int limit, int step, Access1D<N> left, BinaryFunction<N> function) {
        OperationBinary.invoke(this.data, (int)first, (int)limit, (int)step, left, function, (Access1D)this);
    }

    @Override
    protected final void modify(int first, int limit, int step, BinaryFunction<N> function, Access1D<N> right) {
        OperationBinary.invoke(this.data, (int)first, (int)limit, (int)step, (Access1D)this, function, right);
    }

    @Override
    protected final void modify(int first, int limit, int step, UnaryFunction<N> function) {
        OperationUnary.invoke(this.data, (int)first, (int)limit, (int)step, (Access1D)this, function);
    }

    @Override
    protected final void modifyOne(int index, UnaryFunction<N> modifier) {
        this.data[index] = modifier.invoke(this.data[index]);
    }

    @Override
    protected final int searchAscending(N value) {
        return Arrays.binarySearch(this.data, value);
    }

    @Override
    protected final void set(int index, Comparable<?> value) {
        this.data[index] = this.valueOf(value);
    }

    @Override
    protected final void set(int index, double value) {
        this.data[index] = this.valueOf(value);
    }

    @Override
    protected final void set(int index, float value) {
        this.data[index] = this.valueOf(value);
    }

    @Override
    protected final void visit(int first, int limit, int step, VoidFunction<N> visitor) {
        OperationVoid.invoke(this.data, (int)first, (int)limit, (int)step, visitor);
    }

    @Override
    protected void visitOne(int index, VoidFunction<N> visitor) {
        visitor.invoke(this.data[index]);
    }

    @Override
    final void modify(long extIndex, int intIndex, Access1D<N> left, BinaryFunction<N> function) {
        this.data[intIndex] = function.invoke(left.get(extIndex), this.data[intIndex]);
    }

    @Override
    final void modify(long extIndex, int intIndex, BinaryFunction<N> function, Access1D<N> right) {
        this.data[intIndex] = function.invoke(this.data[intIndex], right.get(extIndex));
    }

    @Override
    final void modify(long extIndex, int intIndex, UnaryFunction<N> function) {
        this.data[intIndex] = function.invoke(this.data[intIndex]);
    }

    final N valueOf(Comparable<?> number) {
        return this.factory().scalar().cast(number);
    }

    final N valueOf(double value) {
        return this.factory().scalar().cast(value);
    }

    final N valueOf(float value) {
        return this.factory().scalar().cast(value);
    }
}

