/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.console.editor;

import java.io.Writer;
import javax.swing.JTextArea;

public class JTextAreaWriter
extends Writer {
    private final JTextArea _jta;
    private final int _maxBuffSize;
    private final StringBuffer _stringBuffer = new StringBuffer();
    private final int _maxLength = 10000;

    public JTextAreaWriter(JTextArea ta) {
        this(ta, -1);
    }

    public JTextAreaWriter(JTextArea ta, int maxBuffSize) {
        this._jta = ta;
        this._jta.setWrapStyleWord(false);
        this._maxBuffSize = maxBuffSize;
    }

    private void flushBufferToTextArea() {
        boolean onLastPosition = this._jta.getCaretPosition() == this._jta.getText().length();
        this._jta.append(this._stringBuffer.toString());
        if (onLastPosition) {
            this._jta.setCaretPosition(this._jta.getText().length());
        }
        this._stringBuffer.setLength(0);
    }

    public synchronized String toString() {
        this.flushBufferToTextArea();
        return this._jta.getText();
    }

    @Override
    public synchronized void flush() {
        this.flushBufferToTextArea();
    }

    @Override
    public synchronized void write(int b) {
        if (this._stringBuffer.length() >= this._maxBuffSize || b == 10) {
            this.flushBufferToTextArea();
        }
        if (this._jta.getText().length() > 10000) {
            this._jta.setText("");
        }
        this._stringBuffer.append((char)b);
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) {
        String line = new String(cbuf, off, len);
        if (this._jta.getLineCount() > 10000) {
            this._jta.setText("");
        }
        this._jta.append(line);
    }

    @Override
    public void close() {
    }
}

