/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.LayerTypes;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.layout.ElementType;
import org.meteoinfo.geo.layout.LayoutElement;
import org.meteoinfo.geo.layout.LayoutMap;
import org.meteoinfo.geo.layout.MapLayout;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.ResizeAbility;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.LabelBreak;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.VectorBreak;
import org.meteoinfo.geometry.shape.EllipseShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.render.java2d.Draw;
import org.meteoinfo.ui.event.IMapViewUpdatedListener;
import org.meteoinfo.ui.event.ISizeChangedListener;
import org.meteoinfo.ui.event.MapViewUpdatedEvent;
import org.meteoinfo.ui.event.SizeChangedEvent;

public class LayoutGraphic
extends LayoutElement {
    private MapLayout _mapLayout;
    private LayoutMap _layoutMap;
    private Graphic _graphic;
    private boolean _updatingSize = false;
    private boolean _isTitle = false;
    private boolean _isPaint;
    private boolean _antiAlias = true;

    public LayoutGraphic(Graphic aGraphic, MapLayout aMapLayout) {
        this.setElementType(ElementType.LAYOUT_GRAPHIC);
        this.setResizeAbility(ResizeAbility.RESIZE_ALL);
        this._mapLayout = aMapLayout;
        this._isPaint = true;
        this.setGraphic(aGraphic);
        if (this._graphic.getLegend() != null && this._graphic.getLegend().getBreakType() == BreakTypes.LABEL_BREAK) {
            ((LabelBreak)this._graphic.getLegend()).addSizeChangedListener(new ISizeChangedListener(){

                public void sizeChangedEvent(SizeChangedEvent event) {
                    LayoutGraphic.this.updateControlSize();
                }
            });
        }
    }

    public LayoutGraphic(Graphic aGraphic, MapLayout aMapLayout, LayoutMap aLayoutMap) {
        this.setElementType(ElementType.LAYOUT_GRAPHIC);
        this.setResizeAbility(ResizeAbility.RESIZE_ALL);
        this._mapLayout = aMapLayout;
        this._isPaint = true;
        this.setGraphic(aGraphic);
        if (this._graphic.getLegend() != null && this._graphic.getLegend().getBreakType() == BreakTypes.LABEL_BREAK) {
            ((LabelBreak)this._graphic.getLegend()).addSizeChangedListener(new ISizeChangedListener(){

                public void sizeChangedEvent(SizeChangedEvent event) {
                    LayoutGraphic.this.updateControlSize();
                }
            });
        }
        this._layoutMap = aLayoutMap;
        this._layoutMap.addMapViewUpdatedListener(new IMapViewUpdatedListener(){

            public void mapViewUpdatedEvent(MapViewUpdatedEvent event) {
                if (LayoutGraphic.this._graphic.getLegend().getBreakType() == BreakTypes.VECTOR_BREAK) {
                    for (int i = 0; i < LayoutGraphic.this._layoutMap.getMapFrame().getMapView().getLayerNum(); ++i) {
                        MapLayer aLayer = (MapLayer)LayoutGraphic.this._layoutMap.getMapFrame().getMapView().getLayers().get(LayoutGraphic.this._layoutMap.getMapFrame().getMapView().getLayerNum() - 1 - i);
                        if (aLayer.getLayerType() != LayerTypes.VECTOR_LAYER || !aLayer.isVisible() || aLayer.getLayerDrawType() != LayerDrawType.VECTOR) continue;
                        LayoutGraphic.this.setVisible(true);
                        float zoom = ((VectorLayer)aLayer).getDrawingZoom();
                        ((VectorBreak)LayoutGraphic.this._graphic.getLegend()).setZoom(zoom);
                        LayoutGraphic.this.updateControlSize();
                        break;
                    }
                }
            }
        });
    }

    public Graphic getGraphic() {
        return this._graphic;
    }

    public void setGraphic(Graphic graphic) {
        this._graphic = graphic;
        if (this._graphic.getShape() != null) {
            switch (this._graphic.getShape().getShapeType()) {
                case POINT: {
                    if (this._graphic.getLegend().getBreakType() == BreakTypes.POINT_BREAK) {
                        this.setResizeAbility(ResizeAbility.SAME_WIDTH_HEIGHT);
                        break;
                    }
                    if (this._graphic.getLegend().getBreakType() != BreakTypes.LABEL_BREAK) break;
                    this.setResizeAbility(ResizeAbility.NONE);
                    break;
                }
                case CIRCLE: {
                    this.setResizeAbility(ResizeAbility.SAME_WIDTH_HEIGHT);
                    break;
                }
                case WIND_ARROW: {
                    this.setResizeAbility(ResizeAbility.NONE);
                    break;
                }
                default: {
                    this.setResizeAbility(ResizeAbility.RESIZE_ALL);
                }
            }
            this.updateControlSize();
        }
    }

    public boolean isTitle() {
        return this._isTitle;
    }

    public void setIsTitle(boolean istrue) {
        this._isTitle = istrue;
    }

    public boolean isPaint() {
        return this._isPaint;
    }

    public void setIsPaint(boolean istrue) {
        this._isPaint = istrue;
    }

    public void setLabelText(String text) {
        switch (this._graphic.getShape().getShapeType()) {
            case POINT: {
                if (this._graphic.getLegend().getBreakType() != BreakTypes.LABEL_BREAK) break;
                ((LabelBreak)this._graphic.getLegend()).setText(text);
                this.updateControlSize();
            }
        }
    }

    public void updateControlSize() {
        if (this._graphic.getShape() == null) {
            return;
        }
        this._updatingSize = true;
        switch (this._graphic.getShape().getShapeType()) {
            case POINT: {
                PointShape aPS = (PointShape)this._graphic.getShape();
                this.setLeft((int)aPS.getPoint().X);
                this.setTop((int)aPS.getPoint().Y);
                if (this._graphic.getLegend().getBreakType() == BreakTypes.POINT_BREAK) {
                    PointBreak aPB = (PointBreak)this._graphic.getLegend();
                    this.setLeft(this.getLeft() - (int)(aPB.getSize() / 2.0f));
                    this.setTop(this.getTop() - (int)(aPB.getSize() / 2.0f));
                    this.setWidth((int)Math.ceil(aPB.getSize()));
                    this.setHeight((int)Math.ceil(aPB.getSize()));
                    break;
                }
                if (this._graphic.getLegend().getBreakType() != BreakTypes.LABEL_BREAK) break;
                LabelBreak aLB = (LabelBreak)this._graphic.getLegend();
                BufferedImage image = new BufferedImage(this._mapLayout.getPageBounds().width, this._mapLayout.getPageBounds().height, 2);
                Graphics2D g = (Graphics2D)image.getGraphics();
                g.setFont(aLB.getFont());
                Dimension aSF = Draw.getStringDimension((List)aLB.getTexts(), (int)aLB.getLineSpace(), (Graphics2D)g);
                this.setLeft(this.getLeft() - aSF.width / 2);
                this.setTop(this.getTop() - aSF.height * 2 / 3);
                this.setWidth((int)Math.ceil(aSF.width));
                this.setHeight((int)Math.ceil(aSF.getHeight()));
                break;
            }
            case WIND_ARROW: {
                WindArrow aWA = (WindArrow)this._graphic.getShape();
                this.setLeft((int)aWA.getPoint().X);
                this.setTop((int)aWA.getPoint().Y);
                if (aWA.length == 0.0f) {
                    aWA.length = 20.0f;
                }
                this.setWidth((int)(aWA.length * ((VectorBreak)this._graphic.getLegend()).getZoom()));
                this.setHeight(20);
                break;
            }
            case CIRCLE: 
            case POLYLINE: 
            case POLYGON: 
            case RECTANGLE: 
            case CURVE_LINE: 
            case CURVE_POLYGON: 
            case ELLIPSE: {
                Extent extent = this._graphic.getShape().getExtent();
                this.setLeft((int)Math.ceil(extent.minX));
                this.setTop((int)Math.ceil(extent.minY));
                this.setWidth((int)Math.ceil(extent.getWidth()));
                this.setHeight((int)Math.ceil(extent.getHeight()));
            }
        }
        this._updatingSize = false;
    }

    public void verticeEditUpdate(int vIdx, double newX, double newY) {
        List points = this._graphic.getShape().getPoints();
        switch (this._graphic.getShape().getShapeType()) {
            case POLYGON: 
            case RECTANGLE: 
            case CURVE_POLYGON: {
                int last = points.size() - 1;
                if (vIdx == 0) {
                    if (((PointD)points.get((int)0)).X != ((PointD)points.get((int)last)).X || ((PointD)points.get((int)0)).Y != ((PointD)points.get((int)last)).Y) break;
                    ((PointD)points.get((int)last)).X = newX;
                    ((PointD)points.get((int)last)).Y = newY;
                    break;
                }
                if (vIdx != last || ((PointD)points.get((int)0)).X != ((PointD)points.get((int)last)).X || ((PointD)points.get((int)0)).Y != ((PointD)points.get((int)last)).Y) break;
                ((PointD)points.get((int)0)).X = newX;
                ((PointD)points.get((int)0)).Y = newY;
            }
        }
        PointD aP = (PointD)points.get(vIdx);
        aP.X = newX;
        aP.Y = newY;
        this._graphic.getShape().setPoints(points);
        this.updateControlSize();
    }

    @Override
    public void paint(Graphics2D g) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void paintOnLayout(Graphics2D g, PointF pageLocation, float zoom) {
        if (this.isDrawBackColor()) {
            PointF aP = this.pageToScreen(this.getLeft(), this.getTop(), pageLocation, zoom);
            Rectangle rect = new Rectangle((int)aP.X, (int)aP.Y, (int)((float)this.getWidth() * zoom), (int)((float)this.getHeight() * zoom));
            g.setColor(this.getBackColor());
            g.fill(rect);
        }
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.paintGraphics(g, pageLocation, zoom);
    }

    public void paintGraphics(Graphics2D g, PointF pageLocation, float zoom) {
        block0 : switch (this._graphic.getShape().getShapeType()) {
            case POINT: {
                PointD dPoint = (PointD)this._graphic.getShape().getPoints().get(0);
                PointF aPoint = this.pageToScreen((float)dPoint.X, (float)dPoint.Y, pageLocation, zoom);
                if (this._graphic.getLegend().getBreakType() == BreakTypes.POINT_BREAK) {
                    PointBreak aPB = (PointBreak)((PointBreak)this._graphic.getLegend()).clone();
                    float size = aPB.getSize();
                    aPB.setSize(aPB.getSize() * zoom);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Draw.drawPoint((PointF)aPoint, (PointBreak)aPB, (Graphics2D)g);
                    aPB.setSize(size);
                    if (this._antiAlias) break;
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    break;
                }
                if (this._graphic.getLegend().getBreakType() != BreakTypes.LABEL_BREAK) break;
                LabelBreak aLB = (LabelBreak)((LabelBreak)this._graphic.getLegend()).clone();
                Font font = new Font(aLB.getFont().getFontName(), aLB.getFont().getStyle(), aLB.getFont().getSize());
                aLB.setFont(new Font(font.getFontName(), font.getStyle(), (int)((float)font.getSize() * zoom)));
                Rectangle rect = new Rectangle();
                Draw.drawLabelPoint((PointF)aPoint, (LabelBreak)aLB, (Graphics2D)g, (Rectangle)rect);
                this.setBounds(rect);
                aLB.setFont(font);
                break;
            }
            case WIND_ARROW: {
                PointD dPoint = (PointD)this._graphic.getShape().getPoints().get(0);
                PointF aPoint = this.pageToScreen((float)dPoint.X, (float)dPoint.Y, pageLocation, zoom);
                WindArrow aArraw = (WindArrow)this._graphic.getShape();
                VectorBreak aVB = (VectorBreak)this._graphic.getLegend();
                Draw.drawArraw((Color)aVB.getColor(), (PointF)aPoint, (WindArrow)aArraw, (Graphics2D)g, (double)(aVB.getZoom() * zoom));
                Font drawFont = new Font("Arial", 0, (int)(12.0f * zoom));
                FontMetrics metrics = g.getFontMetrics(drawFont);
                String drawStr = DataConvert.removeTailingZeros((String)String.valueOf(aArraw.length));
                Dimension fsize = new Dimension(metrics.stringWidth(drawStr), metrics.getHeight());
                g.setColor(aVB.getColor());
                g.setFont(drawFont);
                g.drawString(drawStr, aPoint.X, aPoint.Y + (float)fsize.height);
                break;
            }
            case CIRCLE: 
            case POLYLINE: 
            case POLYGON: 
            case RECTANGLE: 
            case CURVE_LINE: 
            case CURVE_POLYGON: 
            case ELLIPSE: {
                List pList = this._graphic.getShape().getPoints();
                PointF[] points = new PointF[pList.size()];
                for (int i = 0; i < pList.size(); ++i) {
                    points[i] = this.pageToScreen((float)((PointD)pList.get((int)i)).X, (float)((PointD)pList.get((int)i)).Y, pageLocation, zoom);
                }
                switch (this._graphic.getShape().getShapeType()) {
                    case POLYLINE: {
                        PolylineBreak aPLB = (PolylineBreak)((PolylineBreak)this._graphic.getLegend()).clone();
                        float size = aPLB.getWidth();
                        aPLB.setWidth(size * zoom);
                        Draw.drawPolyline((PointF[])points, (PolylineBreak)((PolylineBreak)this._graphic.getLegend()), (Graphics2D)g);
                        aPLB.setWidth(size);
                        break block0;
                    }
                    case POLYGON: 
                    case RECTANGLE: {
                        PolygonBreak aPGB = (PolygonBreak)((PolygonBreak)this._graphic.getLegend()).clone();
                        float size = aPGB.getOutlineSize();
                        aPGB.setOutlineSize(size * zoom);
                        Draw.drawPolygon((PointF[])points, (PolygonBreak)((PolygonBreak)this._graphic.getLegend()), (Graphics2D)g);
                        aPGB.setOutlineSize(size);
                        break block0;
                    }
                    case CIRCLE: {
                        PolygonBreak aPGB = (PolygonBreak)((PolygonBreak)this._graphic.getLegend()).clone();
                        float size = aPGB.getOutlineSize();
                        aPGB.setOutlineSize(size * zoom);
                        Draw.drawCircle((PointF[])points, (PolygonBreak)((PolygonBreak)this._graphic.getLegend()), (Graphics2D)g);
                        aPGB.setOutlineSize(size);
                        break block0;
                    }
                    case CURVE_LINE: {
                        PolylineBreak aPLB = (PolylineBreak)((PolylineBreak)this._graphic.getLegend()).clone();
                        float size = aPLB.getWidth();
                        aPLB.setWidth(size * zoom);
                        Draw.drawCurveLine((PointF[])points, (PolylineBreak)((PolylineBreak)this._graphic.getLegend()), (Graphics2D)g);
                        aPLB.setWidth(size);
                        break block0;
                    }
                    case CURVE_POLYGON: {
                        PolygonBreak aPGB = (PolygonBreak)((PolygonBreak)this._graphic.getLegend()).clone();
                        float size = aPGB.getOutlineSize();
                        aPGB.setOutlineSize(size * zoom);
                        Draw.drawCurvePolygon((PointF[])points, (PolygonBreak)((PolygonBreak)this._graphic.getLegend()), (Graphics2D)g);
                        aPGB.setOutlineSize(size);
                        break block0;
                    }
                    case ELLIPSE: {
                        PolygonBreak aPGB = (PolygonBreak)((PolygonBreak)this._graphic.getLegend()).clone();
                        float size = aPGB.getOutlineSize();
                        aPGB.setOutlineSize(size * zoom);
                        float angle = ((EllipseShape)this._graphic.getShape()).getAngle();
                        Draw.drawEllipse((PointF[])points, (float)angle, (PolygonBreak)((PolygonBreak)this._graphic.getLegend()), (Graphics2D)g);
                        aPGB.setOutlineSize(size);
                    }
                }
            }
        }
    }

    @Override
    public void moveUpdate() {
        if (this._graphic.getShape() != null) {
            List points = this._graphic.getShape().getPoints();
            Extent aExtent = this._graphic.getShape().getExtent();
            double minX = aExtent.minX;
            double minY = aExtent.minY;
            if (this._graphic.getShape().getShapeType() == ShapeTypes.POINT) {
                if (this._graphic.getLegend().getBreakType() == BreakTypes.POINT_BREAK) {
                    minY -= (double)(this.getHeight() / 2);
                } else if (this._graphic.getLegend().getBreakType() == BreakTypes.LABEL_BREAK) {
                    minY -= (double)(this.getHeight() * 2 / 3);
                }
            }
            int shiftX = this.getLeft() - (int)minX;
            int shiftY = this.getTop() - (int)minY;
            for (int i = 0; i < points.size(); ++i) {
                PointD aP = (PointD)points.get(i);
                aP.X += (double)shiftX;
                aP.Y += (double)shiftY;
            }
            this._graphic.getShape().setPoints(points);
        }
    }

    @Override
    public void resizeUpdate() {
        if (this._graphic.getShape() != null) {
            switch (this._graphic.getShape().getShapeType()) {
                case POINT: {
                    if (this._graphic.getLegend().getBreakType() != BreakTypes.POINT_BREAK) break;
                    PointBreak aPB = (PointBreak)this._graphic.getLegend();
                    aPB.setSize((float)this.getWidth());
                    this.updateControlSize();
                    break;
                }
                case POLYLINE: 
                case POLYGON: 
                case CURVE_LINE: 
                case CURVE_POLYGON: {
                    this.moveUpdate();
                    List points = this._graphic.getShape().getPoints();
                    Extent aExtent = this._graphic.getShape().getExtent();
                    int deltaX = this.getWidth() - (int)aExtent.getWidth();
                    int deltaY = this.getHeight() - (int)aExtent.getHeight();
                    for (int i = 0; i < points.size(); ++i) {
                        PointD aP = (PointD)points.get(i);
                        aP.X += (double)deltaX * (aP.X - aExtent.minX) / aExtent.getWidth();
                        aP.Y += (double)deltaY * (aP.Y - aExtent.minY) / aExtent.getHeight();
                    }
                    this._graphic.getShape().setPoints(points);
                    break;
                }
                case RECTANGLE: 
                case ELLIPSE: {
                    ArrayList<PointD> points = new ArrayList<PointD>();
                    points.add(new PointD((double)this.getLeft(), (double)this.getTop()));
                    points.add(new PointD((double)this.getLeft(), (double)this.getBottom()));
                    points.add(new PointD((double)this.getRight(), (double)this.getBottom()));
                    points.add(new PointD((double)this.getRight(), (double)this.getTop()));
                    if (this._graphic.getShape().getShapeType() == ShapeTypes.RECTANGLE) {
                        points.add((PointD)((PointD)points.get(0)).clone());
                    }
                    this._graphic.getShape().setPoints(points);
                    break;
                }
                case CIRCLE: {
                    ArrayList<PointD> points = new ArrayList<PointD>();
                    points.add(new PointD((double)this.getLeft(), (double)(this.getTop() + this.getWidth() / 2)));
                    points.add(new PointD((double)(this.getLeft() + this.getWidth() / 2), (double)this.getTop()));
                    points.add(new PointD((double)(this.getLeft() + this.getWidth()), (double)(this.getTop() + this.getWidth() / 2)));
                    points.add(new PointD((double)(this.getLeft() + this.getWidth() / 2), (double)(this.getTop() + this.getWidth())));
                    this._graphic.getShape().setPoints(points);
                }
            }
        }
    }

    @Override
    public void fireLocationChangedEvent() {
        super.fireLocationChangedEvent();
        if (!this._updatingSize) {
            this.moveUpdate();
        }
    }
}

