/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.special;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;

public class LambertW {
    public static int MAXIT = 15;
    public static double EPS = 1.0E-15;

    public static void setEPS(double eps) {
        EPS = eps;
    }

    public static Complex W0(Complex z) {
        return LambertW.eval(z, 0);
    }

    public static Array W0(Array z) {
        Array r = Array.factory((DataType)DataType.COMPLEX, (int[])z.getShape());
        IndexIterator iterR = r.getIndexIterator();
        IndexIterator iterZ = z.getIndexIterator();
        while (iterR.hasNext()) {
            iterR.setComplexNext(LambertW.eval(iterZ.getComplexNext(), 0));
        }
        return r;
    }

    public static Complex Wk(Complex z, int k) {
        return LambertW.eval(z, k);
    }

    public static Array Wk(Array z, int k) {
        Array r = Array.factory((DataType)DataType.COMPLEX, (int[])z.getShape());
        IndexIterator iterR = r.getIndexIterator();
        IndexIterator iterZ = z.getIndexIterator();
        while (iterR.hasNext()) {
            iterR.setComplexNext(LambertW.eval(iterZ.getComplexNext(), k));
        }
        return r;
    }

    private static Complex eval(Complex z, int k) {
        if (z.real() == Double.NEGATIVE_INFINITY || z.imag() == Double.NEGATIVE_INFINITY || Double.isNaN(z.real()) || Double.isNaN(z.imag())) {
            return new Complex(Double.NaN, Double.NaN);
        }
        if (k == 0 && z.real() == -0.36787944117144233 && z.imag() == 0.0) {
            return new Complex(-1.0, 0.0);
        }
        if (k == 0 && z.real() == 0.0 && z.imag() == 0.0) {
            return new Complex(0.0, 0.0);
        }
        Complex w = LambertW.initialGuess(z, k);
        for (int iter = 0; iter < MAXIT; ++iter) {
            Complex e = w.exp();
            Complex f = w.multiply(e).subtract(z);
            Complex df = e.multiply(w.add(new Complex(1.0, 0.0)));
            Complex ddf = e.multiply(w.add(new Complex(2.0, 0.0)));
            Complex delta = f.multiply(df).divide(df.multiply(df).subtract(f.multiply(ddf).multiply(0.5)));
            w = w.subtract(delta);
            if (delta.abs() < EPS * w.abs()) break;
        }
        return w;
    }

    private static Complex initialGuess(Complex z, int k) {
        if (k == 0) {
            return LambertW.initialGuess0(z);
        }
        return LambertW.initialGuessK(z, k);
    }

    private static Complex initialGuess0(Complex z) {
        double x = z.real();
        double y = z.imag();
        if (Math.abs(y) < 1.0E-15 && Math.abs(x) <= 0.5) {
            if (x == 0.0) {
                return new Complex(0.0, 0.0);
            }
            double L1 = Math.log(1.0 + x);
            return new Complex(L1 / (1.0 + L1), 0.0);
        }
        return z.log();
    }

    private static Complex initialGuessK(Complex z, int k) {
        Complex logZ = z.log();
        Complex twoPiK = new Complex(0.0, Math.PI * 2 * (double)k);
        return logZ.add(twoPiK);
    }
}

