/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionIndicator {
    private static final byte[] MAGIC = new byte[]{71, 82, 73, 66};
    private final long messageLength;
    private final int discipline;
    private final long startPos;

    public Grib2SectionIndicator(RandomAccessFile raf) throws IOException {
        this.startPos = raf.getFilePointer();
        byte[] b = new byte[4];
        raf.readFully(b);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == MAGIC[i]) continue;
            throw new IllegalArgumentException("Not a GRIB record");
        }
        raf.skipBytes(2);
        this.discipline = raf.read();
        int edition = raf.read();
        if (edition != 2) {
            throw new IllegalArgumentException("Not a GRIB-2 record");
        }
        this.messageLength = GribNumbers.int8(raf);
    }

    public Grib2SectionIndicator(long startPos, long messageLength, int discipline) {
        this.startPos = startPos;
        this.messageLength = messageLength;
        this.discipline = discipline;
    }

    public long getMessageLength() {
        return this.messageLength;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public long getEndPos() {
        return this.startPos + this.messageLength;
    }

    public int getDiscipline() {
        return this.discipline;
    }
}

