/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.DAPNode;
import opendap.dap.DataReadException;
import opendap.dap.PrimitiveVector;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;

public class BooleanPrimitiveVector
extends PrimitiveVector {
    private boolean[] vals;

    public BooleanPrimitiveVector(BaseType var) {
        super(var);
    }

    @Override
    public int getLength() {
        return this.vals.length;
    }

    @Override
    public void setLength(int len) {
        this.vals = new boolean[len];
    }

    public final boolean getValue(int i) {
        return this.vals[i];
    }

    public final void setValue(int i, boolean newVal) {
        this.vals[i] = newVal;
    }

    @Override
    public void printVal(PrintWriter os, String space) {
        int len = this.vals.length;
        for (int i = 0; i < len - 1; ++i) {
            os.print(this.vals[i]);
            os.print(", ");
        }
        if (len > 0) {
            os.print(this.vals[len - 1]);
        }
    }

    @Override
    public void printSingleVal(PrintWriter os, int index) {
        os.print(this.vals[index]);
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = source.readBoolean();
            if (statusUI == null) continue;
            statusUI.incrementByteCount(1);
            if (!statusUI.userCancelled()) continue;
            throw new DataReadException("User cancelled");
        }
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        for (int i = 0; i < this.vals.length; ++i) {
            sink.writeBoolean(this.vals[i]);
        }
    }

    public void externalize(DataOutputStream sink, int start, int stop, int stride) throws IOException {
        for (int i = start; i <= stop; i += stride) {
            sink.writeBoolean(this.vals[i]);
        }
    }

    @Override
    public Object getInternalStorage() {
        return this.vals;
    }

    @Override
    public void setInternalStorage(Object o) {
        this.vals = (boolean[])o;
    }

    @Override
    public PrimitiveVector subset(int start, int stop, int stride) {
        BooleanPrimitiveVector n = new BooleanPrimitiveVector(this.getTemplate());
        stride = Math.max(stride, 1);
        stop = Math.max(start, stop);
        int length = 1 + (stop - start) / stride;
        n.setLength(length);
        int count = 0;
        for (int i = start; i <= stop; i += stride) {
            n.setValue(count, this.vals[i]);
            ++count;
        }
        return n;
    }

    @Override
    public String getTypeName() {
        return "BooleanPrimitiveVector";
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        BooleanPrimitiveVector v = (BooleanPrimitiveVector)super.cloneDAG(map);
        if (this.vals != null) {
            v.vals = new boolean[this.vals.length];
            System.arraycopy(this.vals, 0, v.vals, 0, this.vals.length);
        }
        return v;
    }
}

