/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabStateInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.ArchGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.EclipseDockTitleEvent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.title.ActionsDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;

@Deprecated
public class DockTitleTab
implements TabComponent,
EclipseTabStateInfo {
    public static final TabPainter FACTORY = DockTitleTab.createFactory(ArchGradientPainter.FACTORY);
    private DockStation station;
    private Dockable dockable;
    private DockTitleRequest title;
    private TabPlacement placement;
    private EclipseTheme theme;
    private JPanel content;
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
    private boolean focused;
    private boolean selected;
    private boolean paintIconWhenInactive;
    private MouseInputListener mouseListener = new MouseInputListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
            for (MouseListener m : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                m.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            for (MouseListener m : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                m.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            for (MouseListener m : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                m.mouseExited(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            for (MouseListener m : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                m.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            for (MouseListener m : DockTitleTab.this.mouseListeners.toArray(new MouseListener[DockTitleTab.this.mouseListeners.size()])) {
                m.mouseReleased(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            for (MouseMotionListener m : DockTitleTab.this.mouseMotionListeners.toArray(new MouseMotionListener[DockTitleTab.this.mouseMotionListeners.size()])) {
                m.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            for (MouseMotionListener m : DockTitleTab.this.mouseMotionListeners.toArray(new MouseMotionListener[DockTitleTab.this.mouseMotionListeners.size()])) {
                m.mouseMoved(e);
            }
        }
    };

    public static final TabPainter createFactory(final TabPainter fallback) {
        return new TabPainter(){

            @Override
            public TabComponent createTabComponent(EclipseTabPane pane, Dockable dockable) {
                DockTitleVersion version;
                DockStation station = pane.getStation();
                DockController controller = station.getController();
                DockTitleVersion dockTitleVersion = version = controller == null ? null : controller.getDockTitleManager().getVersion("eclipse.tab");
                if (version == null) {
                    return fallback.createTabComponent(pane, dockable);
                }
                pane.setContentBorderAt(pane.indexOf(dockable), null);
                return new DockTitleTab(station, dockable, version, pane.getTheme());
            }

            @Override
            public InvisibleTab createInvisibleTab(InvisibleTabPane pane, Dockable dockable) {
                return fallback.createInvisibleTab(pane, dockable);
            }

            @Override
            public TabPanePainter createDecorationPainter(EclipseTabPane pane) {
                return fallback.createDecorationPainter(pane);
            }

            @Override
            public Border getFullBorder(BorderedComponent owner, DockController controller, Dockable dockable) {
                return BorderFactory.createLineBorder((Color)controller.getColors().get("stack.border"));
            }
        };
    }

    public DockTitleTab(DockStation station, final Dockable dockable, DockTitleVersion title, EclipseTheme theme) {
        this.content = new JPanel(new BorderLayout());
        this.content.setOpaque(false);
        this.station = station;
        this.dockable = dockable;
        this.theme = theme;
        this.title = new DockTitleRequest(station, dockable, title){

            @Override
            protected void answer(DockTitle previous, DockTitle title) {
                if (previous != null) {
                    DockTitleTab.this.content.removeAll();
                    dockable.unbind(previous);
                    previous.removeMouseInputListener(DockTitleTab.this.mouseListener);
                }
                if (title != null) {
                    dockable.bind(title);
                    title.addMouseInputListener(DockTitleTab.this.mouseListener);
                    DockTitleTab.this.updateOrientation();
                    DockTitleTab.this.content.add(title.getComponent(), "Center");
                    DockTitleTab.this.fire();
                }
            }
        };
    }

    @Override
    public EclipseTabStateInfo getEclipseTabStateInfo() {
        return this;
    }

    @Override
    public void setConfiguration(TabConfiguration configuration) {
    }

    @Override
    public void setOrientation(TabPlacement orientation) {
        this.placement = orientation;
        this.updateOrientation();
    }

    private void updateOrientation() {
        DockTitle title = (DockTitle)this.title.getAnswer();
        if (this.placement != null && title != null) {
            switch (this.placement) {
                case TOP_OF_DOCKABLE: {
                    title.setOrientation(DockTitle.Orientation.NORTH_SIDED);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    title.setOrientation(DockTitle.Orientation.SOUTH_SIDED);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    title.setOrientation(DockTitle.Orientation.WEST_SIDED);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    title.setOrientation(DockTitle.Orientation.EAST_SIDED);
                }
            }
        }
    }

    @Override
    public void setTab(EclipseTab tab) {
    }

    @Override
    public void bind() {
        this.title.install();
        this.title.request();
        this.fire();
    }

    @Override
    public void unbind() {
        this.title.uninstall();
        this.title.requestNull();
    }

    public void addMouseListener(MouseListener listener) {
        this.mouseListeners.add(listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListeners.add(listener);
    }

    @Override
    public Component getComponent() {
        return this.content;
    }

    @Override
    public Dimension getMinimumSize(TabComponent[] tabs) {
        return this.getComponent().getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(TabComponent[] tabs) {
        return this.getComponent().getPreferredSize();
    }

    @Override
    public DockElement getElement() {
        return this.title.getTarget();
    }

    @Override
    public Dockable getDockable() {
        return this.title.getTarget();
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        DockTitle current = (DockTitle)this.title.getAnswer();
        if (current == null) {
            return null;
        }
        return current.getPopupLocation(click, popupTrigger);
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.mouseListeners.add(listener);
        this.mouseMotionListeners.add(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.mouseListeners.remove(listener);
        this.mouseMotionListeners.remove(listener);
    }

    @Override
    public Insets getOverlap(TabComponent other) {
        return new Insets(0, 0, 0, 0);
    }

    public void removeMouseListener(MouseListener listener) {
        this.mouseListeners.remove(listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListeners.remove(listener);
    }

    @Override
    public void setFocused(boolean focused) {
        this.focused = focused;
        this.fire();
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setPaintIconWhenInactive(boolean paint) {
        this.paintIconWhenInactive = paint;
        this.fire();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.fire();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setIcon(Icon icon) {
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public void setTooltip(String tooltip) {
    }

    public void update() {
        this.fire();
    }

    protected void fire() {
        DockTitle answer = (DockTitle)this.title.getAnswer();
        if (answer != null) {
            EclipseDockTitleEvent eclipseEvent = new EclipseDockTitleEvent(this.station, this.dockable, this.selected, this.focused, this.paintIconWhenInactive);
            answer.changed(eclipseEvent);
            EclipseDockActionSource actions = new EclipseDockActionSource(this.theme, this.dockable.getGlobalActionOffers(), this.getEclipseTabStateInfo(), true);
            ActionsDockTitleEvent actionEvent = new ActionsDockTitleEvent(this.station, this.dockable, actions);
            answer.changed(actionEvent);
        }
    }
}

