/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.Collections;
import java.util.List;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.oned.Interval;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineSubset;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

public abstract class LineConvexSubset
extends LineSubset
implements HyperplaneConvexSubset<Vector2D> {
    LineConvexSubset(Line line) {
        super(line);
    }

    @Override
    public List<LineConvexSubset> toConvex() {
        return Collections.singletonList(this);
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract Vector2D getStartPoint();

    public abstract double getSubspaceStart();

    public abstract Vector2D getEndPoint();

    public abstract double getSubspaceEnd();

    public Interval getSubspaceRegion() {
        double start = this.getSubspaceStart();
        double end = this.getSubspaceEnd();
        return Interval.of(start, end, this.getPrecision());
    }

    public Interval getInterval() {
        return this.getSubspaceRegion();
    }

    public Split<LineConvexSubset> split(Hyperplane<Vector2D> splitter) {
        Line splitterLine = (Line)splitter;
        Line thisLine = this.getLine();
        Vector2D intersection = splitterLine.intersection(thisLine);
        if (intersection == null) {
            return this.getNonIntersectingSplitResult(splitterLine, this);
        }
        return this.splitOnIntersection(splitterLine, intersection);
    }

    public Vector2D closest(Vector2D pt) {
        Line line = this.getLine();
        double abscissa = line.abscissa(pt);
        return line.toSpace(this.closestAbscissa(abscissa));
    }

    public abstract LineConvexSubset transform(Transform<Vector2D> var1);

    public abstract LineConvexSubset reverse();

    abstract double closestAbscissa(double var1);

    abstract Split<LineConvexSubset> splitOnIntersection(Line var1, Vector2D var2);
}

