from mipylib.numeric import stats

x = arange(0, 3, 0.01)
aa = [0.5, 1, 1.5, 5]
bb = [1, 1, 1, 1]
ss = ['-b', '-r', '-c', '-g']

#PDF
subplot(1,2,1)
for a,b,s in zip(aa,bb,ss):
    y = stats.weibull.pdf(x, a, b)
    plot(x, y, s, linewidth=1, label=r'$\lambda = %i$, k = %i$' % (a, b))
#grid(True)
legend(loc='upper right', facecolor='w')
ylim(0, 2.5)
xlim(0, 3)
title('PDF')

#CDF
subplot(1,2,2)
for a,b,s in zip(aa,bb,ss):
    y = stats.weibull.cdf(x, a, b)
    plot(x, y, s, linewidth=1, label=r'$\lambda = %i$, k = %i$' % (a, b))
#grid(True)
legend(loc='lower right', facecolor='w')
ylim(0, 1.05)
xlim(0, 3)
title('CDF')

suptitle('Weibull distribution')