/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.opengl.GL2;
import java.nio.IntBuffer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.meteoinfo.chart.jogl.Lighting;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.render.GraphicRender;

public abstract class JOGLGraphicRender
implements GraphicRender {
    protected GL2 gl;
    protected boolean orthographic = true;
    protected Transform transform;
    protected int[] viewport = new int[4];
    protected float[] mvmatrix = new float[16];
    protected float[] projmatrix = new float[16];
    protected Matrix4f viewProjMatrix = new Matrix4f();
    protected Matrix4f modelViewMatrix = new Matrix4f();
    protected Matrix4f projectionMatrix = new Matrix4f();
    protected Matrix4f modelViewMatrixR = new Matrix4f();
    protected boolean useShader = false;
    protected Lighting lighting = new Lighting();
    protected float dpiScale = 1.0f;

    public JOGLGraphicRender(GL2 gl) {
        this.gl = gl;
        this.updateMatrix();
    }

    public boolean isOrthographic() {
        return this.orthographic;
    }

    public void setOrthographic(boolean value) {
        this.orthographic = value;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform value) {
        this.transform = value;
    }

    public void setTransform(Transform value, boolean alwaysUpdateBuffers) {
        this.transform = value;
    }

    public int getWidth() {
        return this.viewport[2];
    }

    public int getHeight() {
        return this.viewport[3];
    }

    public void setLighting(Lighting lighting) {
        this.lighting = lighting;
    }

    public float getDpiScale() {
        return this.dpiScale;
    }

    public void setDpiScale(float value) {
        this.dpiScale = value;
    }

    protected int getTextureID() {
        IntBuffer intBuffer = IntBuffer.allocate(1);
        this.gl.glGenTextures(1, intBuffer);
        return intBuffer.get(0);
    }

    protected Matrix4f toMatrix(float[] data) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.set(data);
        return matrix4f;
    }

    public void updateMatrix() {
        this.gl.glGetIntegerv(2978, this.viewport, 0);
        this.gl.glGetFloatv(2982, this.mvmatrix, 0);
        this.gl.glGetFloatv(2983, this.projmatrix, 0);
        this.modelViewMatrix = this.toMatrix(this.mvmatrix);
        this.projectionMatrix = this.toMatrix(this.projmatrix);
        this.viewProjMatrix = this.projectionMatrix.mul((Matrix4fc)this.modelViewMatrix);
    }

    public void setRotateModelView(Matrix4f value) {
        this.modelViewMatrixR = value;
    }
}

