/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.ErrorFunction;
import org.ojalgo.random.AbstractContinuous;

public class Normal
extends AbstractContinuous {
    private final double myLocation;
    private final double myScale;

    public static Normal of(double location, double scale) {
        return new Normal(location, scale);
    }

    public static Normal standard() {
        return new Normal();
    }

    public Normal() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public Normal(double location, double scale) {
        this.myLocation = location;
        this.myScale = scale;
    }

    @Override
    public double getDensity(double value) {
        double tmpVal = (value - this.myLocation) / this.myScale;
        return PrimitiveMath.EXP.invoke(tmpVal * tmpVal / -PrimitiveMath.TWO) / (this.myScale * PrimitiveMath.SQRT_TWO_PI);
    }

    @Override
    public double getDistribution(double value) {
        return (PrimitiveMath.ONE + ErrorFunction.erf((value - this.myLocation) / (this.myScale * PrimitiveMath.SQRT_TWO))) / PrimitiveMath.TWO;
    }

    @Override
    public double getExpected() {
        return this.myLocation;
    }

    @Override
    public double getQuantile(double probability) {
        this.checkProbabilty(probability);
        return this.myScale * PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(PrimitiveMath.TWO * probability - PrimitiveMath.ONE) + this.myLocation;
    }

    @Override
    public double getStandardDeviation() {
        return this.myScale;
    }

    @Override
    protected double generate() {
        return this.random().nextGaussian() * this.myScale + this.myLocation;
    }
}

