/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.util.Set;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;

class SpecialOrderedSet
extends ExpressionsBasedModel.Presolver {
    private final Expression myExpression;
    private final Structure1D.IntIndex[] mySequence;
    private final int myType;

    SpecialOrderedSet(Structure1D.IntIndex[] sequence, int type, Expression expression) {
        super(0);
        this.mySequence = sequence;
        this.myType = type;
        this.myExpression = expression;
    }

    @Override
    public boolean simplify(Expression expression, Set<Structure1D.IntIndex> remaining, BigDecimal lower, BigDecimal upper, NumberContext precision) {
        if (!expression.equals(this.myExpression)) {
            return false;
        }
        if (remaining.size() != expression.getLinearEntrySet().size()) {
            return false;
        }
        int first = -1;
        int limit = -1;
        for (int i = 0; i < this.mySequence.length; ++i) {
            Structure1D.IntIndex index = this.mySequence[1];
            if (remaining.contains(index) || expression.resolve(index).getValue().signum() == 0) continue;
            if (first == -1) {
                first = i;
            }
            limit = i + 1;
        }
        int count = limit - first;
        if (count > this.myType) {
            expression.setInfeasible();
            return false;
        }
        boolean didFixVariable = false;
        for (int i = first + 1; i < limit; ++i) {
            Structure1D.IntIndex index = this.mySequence[i];
            Variable variable = expression.resolve(index);
            if (!remaining.contains(index)) {
                if (variable.getValue().signum() != 0) continue;
                expression.setInfeasible();
                continue;
            }
            if (!variable.isInteger()) continue;
            variable.setFixed(BigDecimal.ONE);
            didFixVariable = true;
        }
        int remainingCount = this.myType - count;
        if (count > 0 && remainingCount > 0) {
            Variable variable;
            Structure1D.IntIndex index;
            int i;
            int lim = first - remainingCount;
            for (i = 0; i < lim; ++i) {
                index = this.mySequence[i];
                variable = expression.resolve(index);
                if (!remaining.contains(index)) {
                    if (variable.getValue().signum() == 0) continue;
                    expression.setInfeasible();
                    continue;
                }
                variable.setFixed(BigDecimal.ZERO);
                didFixVariable = true;
            }
            lim = this.mySequence.length;
            for (i = limit + remainingCount; i < lim; ++i) {
                index = this.mySequence[i];
                variable = expression.resolve(index);
                if (!remaining.contains(index)) {
                    if (variable.getValue().signum() == 0) continue;
                    expression.setInfeasible();
                    continue;
                }
                variable.setFixed(BigDecimal.ZERO);
                didFixVariable = true;
            }
        }
        return didFixVariable;
    }
}

