/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection;

import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class GeodeticCalculator {
    private final Ellipsoid ellipsoid;
    private final double semiMajorAxis;
    private final double flattening;
    private Geodesic geod;

    public GeodeticCalculator() {
        this(Ellipsoid.WGS84);
    }

    public GeodeticCalculator(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.semiMajorAxis = ellipsoid.getA();
        this.flattening = (ellipsoid.getA() - ellipsoid.getB()) / ellipsoid.getA();
        this.geod = new Geodesic(this.semiMajorAxis, this.flattening);
    }

    public GeodeticCalculator(String ellipsoidName) {
        Ellipsoid ellipsoid = Ellipsoid.WGS84;
        for (Ellipsoid e : Ellipsoid.ellipsoids) {
            if (!e.shortName.equalsIgnoreCase(ellipsoidName)) continue;
            ellipsoid = e;
            break;
        }
        this.ellipsoid = ellipsoid;
        this.semiMajorAxis = ellipsoid.getA();
        this.flattening = (ellipsoid.getA() - ellipsoid.getB()) / ellipsoid.getA();
        this.geod = new Geodesic(this.semiMajorAxis, this.flattening);
    }

    public GeodeticCalculator(double semiMajorAxis, double flattening) {
        double e2 = 2.0 * flattening - flattening * flattening;
        this.ellipsoid = new Ellipsoid("custom", semiMajorAxis, e2, "custom");
        this.semiMajorAxis = semiMajorAxis;
        this.flattening = flattening;
        this.geod = new Geodesic(semiMajorAxis, flattening);
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public GeodesicData forward(double lon, double lat, double azimuth, double distance) {
        return this.geod.Direct(lat, lon, azimuth, distance);
    }

    public Array[] forward(Array lons, Array lats, Array azimuths, Array distances) {
        lons = lons.copyIfView();
        lats = lats.copyIfView();
        azimuths = azimuths.copyIfView();
        distances = distances.copyIfView();
        Array lons2 = Array.factory((DataType)lons.getDataType(), (int[])lons.getShape());
        Array lats2 = Array.factory((DataType)lons.getDataType(), (int[])lons.getShape());
        Array azimuths2 = Array.factory((DataType)lons.getDataType(), (int[])lons.getShape());
        int i = 0;
        while ((long)i < lons.getSize()) {
            GeodesicData geodesicData = this.forward(lons.getDouble(i), lats.getDouble(i), azimuths.getDouble(i), distances.getDouble(i));
            lons2.setDouble(i, geodesicData.lon2);
            lats2.setDouble(i, geodesicData.lat2);
            azimuths2.setDouble(i, geodesicData.azi2);
            ++i;
        }
        return new Array[]{lons2, lats2, azimuths2};
    }

    public GeodesicData inverse(double lon1, double lat1, double lon2, double lat2) {
        return this.geod.Inverse(lat1, lon1, lat2, lon2);
    }

    public Array[] inverse(Array lons1, Array lats1, Array lons2, Array lats2) {
        lons1 = lons1.copyIfView();
        lats1 = lats1.copyIfView();
        lons2 = lons2.copyIfView();
        lats2 = lats2.copyIfView();
        Array azimuths1 = Array.factory((DataType)lons1.getDataType(), (int[])lons1.getShape());
        Array azimuths2 = Array.factory((DataType)lons1.getDataType(), (int[])lons1.getShape());
        Array distances = Array.factory((DataType)lons1.getDataType(), (int[])lons1.getShape());
        int i = 0;
        while ((long)i < lons1.getSize()) {
            GeodesicData geodesicData = this.inverse(lons1.getDouble(i), lats1.getDouble(i), lons2.getDouble(i), lats2.getDouble(i));
            azimuths1.setDouble(i, geodesicData.azi1);
            azimuths2.setDouble(i, geodesicData.azi2);
            distances.setDouble(i, geodesicData.s12);
            ++i;
        }
        return new Array[]{azimuths1, azimuths2, distances};
    }
}

