/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.meteodata;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.meteodata.ITrajDataInfo;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModel;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.TrajectoryInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.geo.layer.ImageLayer;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.RasterLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.layer.WorldFilePara;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.legend.ArrowBreak;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.MarkerType;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.geometry.shape.StationModelShape;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.geometry.shape.WindBarb;
import org.meteoinfo.math.meteo.MeteoMath;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.render.java2d.ContourDraw;
import org.meteoinfo.render.java2d.Draw;
import org.meteoinfo.table.DataTable;
import org.meteoinfo.table.Field;
import wcontour.Contour;
import wcontour.global.PointD;
import wcontour.global.PolyLine;
import wcontour.global.Polygon;

public class DrawMeteoData {
    public static VectorLayer createPolylineLayer(XYListDataset data, LegendScheme ls, String layerName, String fieldName) {
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYLINE);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            double[] xd = data.getXValues(i);
            double[] yd = data.getYValues(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (int j = 0; j < xd.length; ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xd[j];
                aPoint.Y = yd[j];
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)i);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            int shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                layer.editCellValue(fieldName, shapeNum, (Object)i);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(List<Array> xdata, List<Array> ydata, LegendScheme ls, String layerName, String fieldName) {
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYLINE);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        for (int i = 0; i < xdata.size(); ++i) {
            Array xd = xdata.get(i);
            Array yd = ydata.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            IndexIterator xIter = xd.getIndexIterator();
            IndexIterator yIter = yd.getIndexIterator();
            while (xIter.hasNext()) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)i);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            int shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                layer.editCellValue(fieldName, shapeNum, (Object)i);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(XYListDataset data, LegendScheme ls, String layerName, String fieldName, double westLon, double eastLon) {
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYLINE);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            double[] xd = data.getXValues(i);
            double[] yd = data.getYValues(i);
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            ArrayList ppList = new ArrayList();
            double preLon = 0.0;
            for (int j = 0; j < xd.length; ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xd[j];
                aPoint.Y = yd[j];
                if (j == 0) {
                    preLon = xd[j];
                    pList.add(aPoint);
                    continue;
                }
                if (Math.abs(aPoint.X - preLon) > 350.0) {
                    if (aPoint.X > preLon) {
                        pList.add(new org.meteoinfo.common.PointD(westLon, aPoint.Y));
                    } else {
                        pList.add(new org.meteoinfo.common.PointD(eastLon, aPoint.Y));
                    }
                    if (pList.size() > 1) {
                        ppList.add(new ArrayList(pList));
                    }
                    pList.clear();
                    pList.add(aPoint);
                } else {
                    pList.add(aPoint);
                }
                preLon = xd[j];
            }
            if (pList.size() > 1) {
                ppList.add(pList);
            }
            for (List list : ppList) {
                PolylineShape aPolyline = new PolylineShape();
                aPolyline.setPoints(list);
                aPolyline.setValue((double)i);
                aPolyline.setExtent(GeometryUtil.getPointsExtent((List)list));
                int shapeNum = layer.getShapeNum();
                try {
                    if (!layer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                    layer.editCellValue(fieldName, shapeNum, (Object)i);
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(List<Array> xdata, List<Array> ydata, LegendScheme ls, String layerName, String fieldName, double westLon, double eastLon) {
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYLINE);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        for (int i = 0; i < xdata.size(); ++i) {
            org.meteoinfo.common.PointD aPoint;
            double preLon;
            ArrayList<org.meteoinfo.common.PointD> pList;
            Array xd = xdata.get(i);
            Array yd = ydata.get(i);
            ArrayList ppList = new ArrayList();
            IndexIterator xIter = xd.getIndexIterator();
            IndexIterator yIter = yd.getIndexIterator();
            if (xd.getRank() == 1) {
                pList = new ArrayList<org.meteoinfo.common.PointD>();
                preLon = 0.0;
                int j = 0;
                while (xIter.hasNext()) {
                    aPoint = new org.meteoinfo.common.PointD();
                    aPoint.X = xIter.getDoubleNext();
                    aPoint.Y = yIter.getDoubleNext();
                    if (j == 0) {
                        preLon = aPoint.X;
                        pList.add(aPoint);
                    } else {
                        if (Double.isNaN(aPoint.X)) {
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                        } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                            if (aPoint.X > preLon) {
                                pList.add(new org.meteoinfo.common.PointD(westLon, aPoint.Y));
                            } else {
                                pList.add(new org.meteoinfo.common.PointD(eastLon, aPoint.Y));
                            }
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                            pList.add(aPoint);
                        } else {
                            pList.add(aPoint);
                        }
                        preLon = aPoint.X;
                    }
                    ++j;
                }
                if (pList.size() > 1) {
                    ppList.add(pList);
                }
            } else {
                int[] shape = xd.getShape();
                int ny = shape[0];
                int n = shape[1];
                for (int k = 0; k < ny; ++k) {
                    pList = new ArrayList();
                    preLon = 0.0;
                    for (int j = 0; j < n; ++j) {
                        aPoint = new org.meteoinfo.common.PointD();
                        aPoint.X = xIter.getDoubleNext();
                        aPoint.Y = yIter.getDoubleNext();
                        if (j == 0) {
                            preLon = aPoint.X;
                            pList.add(aPoint);
                            continue;
                        }
                        if (Double.isNaN(aPoint.X)) {
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                        } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                            if (aPoint.X > preLon) {
                                pList.add(new org.meteoinfo.common.PointD(westLon, aPoint.Y));
                            } else {
                                pList.add(new org.meteoinfo.common.PointD(eastLon, aPoint.Y));
                            }
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                            pList.add(aPoint);
                        } else {
                            pList.add(aPoint);
                        }
                        preLon = aPoint.X;
                    }
                    if (pList.size() <= 1) continue;
                    ppList.add(pList);
                }
            }
            int k = 0;
            for (List list : ppList) {
                PolylineShape aPolyline = new PolylineShape();
                aPolyline.setPoints(list);
                aPolyline.setValue((double)k);
                aPolyline.setExtent(GeometryUtil.getPointsExtent((List)list));
                int shapeNum = layer.getShapeNum();
                try {
                    if (layer.editInsertShape((Shape)aPolyline, shapeNum)) {
                        layer.editCellValue(fieldName, shapeNum, (Object)k);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
                ++k;
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(Array xdata, Array ydata, Array zdata, LegendScheme ls, String layerName, String fieldName, double westLon, double eastLon) {
        PointZ aPoint;
        double preLon;
        ArrayList<PointZ> pList;
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYLINE_Z);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        ArrayList ppList = new ArrayList();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if (xdata.getRank() == 1) {
            pList = new ArrayList<PointZ>();
            preLon = 0.0;
            int j = 0;
            while (xIter.hasNext()) {
                aPoint = new PointZ();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                aPoint.Z = zIter.getDoubleNext();
                if (j == 0) {
                    preLon = aPoint.X;
                    pList.add(aPoint);
                } else {
                    if (Double.isNaN(aPoint.X)) {
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                    } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                        if (aPoint.X > preLon) {
                            pList.add(new PointZ(westLon, aPoint.Y, aPoint.Z));
                        } else {
                            pList.add(new PointZ(eastLon, aPoint.Y, aPoint.Z));
                        }
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                        pList.add(aPoint);
                    } else {
                        pList.add(aPoint);
                    }
                    preLon = aPoint.X;
                }
                ++j;
            }
            if (pList.size() > 1) {
                ppList.add(pList);
            }
        } else {
            int[] shape = xdata.getShape();
            int n = shape[0];
            int nx = shape[1];
            for (int i = 0; i < n; ++i) {
                pList = new ArrayList();
                preLon = 0.0;
                for (int j = 0; j < nx; ++j) {
                    aPoint = new PointZ();
                    aPoint.X = xIter.getDoubleNext();
                    aPoint.Y = yIter.getDoubleNext();
                    aPoint.Z = zIter.getDoubleNext();
                    if (j == 0) {
                        preLon = aPoint.X;
                        pList.add(aPoint);
                        continue;
                    }
                    if (Double.isNaN(aPoint.X)) {
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                    } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                        if (aPoint.X > preLon) {
                            pList.add(new PointZ(westLon, aPoint.Y, aPoint.Z));
                        } else {
                            pList.add(new PointZ(eastLon, aPoint.Y, aPoint.Z));
                        }
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                        pList.add(aPoint);
                    } else {
                        pList.add(aPoint);
                    }
                    preLon = aPoint.X;
                }
                if (pList.size() <= 1) continue;
                ppList.add(pList);
            }
        }
        for (List list : ppList) {
            PolylineZShape aPolyline = new PolylineZShape();
            aPolyline.setPoints(list);
            aPolyline.setValue(0.0);
            aPolyline.setExtent(GeometryUtil.getPointsExtent((List)list));
            int shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                layer.editCellValue(fieldName, shapeNum, (Object)0);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(layerName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(Array xdata, Array ydata, Array zdata, LegendScheme ls, String layerName, String fieldName) {
        PointZ aPoint;
        double preLon;
        ArrayList<PointZ> pList;
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYLINE_Z);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        ArrayList ppList = new ArrayList();
        IndexIterator xIter = xdata.getIndexIterator();
        IndexIterator yIter = ydata.getIndexIterator();
        IndexIterator zIter = zdata.getIndexIterator();
        if (xdata.getRank() == 1) {
            pList = new ArrayList<PointZ>();
            preLon = 0.0;
            int j = 0;
            while (xIter.hasNext()) {
                aPoint = new PointZ();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                aPoint.Z = zIter.getDoubleNext();
                if (j == 0) {
                    preLon = aPoint.X;
                    pList.add(aPoint);
                } else {
                    if (Double.isNaN(aPoint.X)) {
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                    } else {
                        pList.add(aPoint);
                    }
                    preLon = aPoint.X;
                }
                ++j;
            }
            if (pList.size() > 1) {
                ppList.add(pList);
            }
        } else {
            int[] shape = xdata.getShape();
            int n = shape[0];
            int nx = shape[1];
            for (int i = 0; i < n; ++i) {
                pList = new ArrayList();
                preLon = 0.0;
                for (int j = 0; j < nx; ++j) {
                    aPoint = new PointZ();
                    aPoint.X = xIter.getDoubleNext();
                    aPoint.Y = yIter.getDoubleNext();
                    aPoint.Z = zIter.getDoubleNext();
                    if (j == 0) {
                        preLon = aPoint.X;
                        pList.add(aPoint);
                        continue;
                    }
                    if (Double.isNaN(aPoint.X)) {
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                    } else {
                        pList.add(aPoint);
                    }
                    preLon = aPoint.X;
                }
                if (pList.size() <= 1) continue;
                ppList.add(pList);
            }
        }
        for (List list : ppList) {
            PolylineZShape aPolyline = new PolylineZShape();
            aPolyline.setPoints(list);
            aPolyline.setValue(0.0);
            aPolyline.setExtent(GeometryUtil.getPointsExtent((List)list));
            int shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                layer.editCellValue(fieldName, shapeNum, (Object)0);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(layerName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createContourLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.UNIQUE_VALUE, ShapeTypes.POLYLINE);
        return DrawMeteoData.createContourLayer(gridData, ls, lName, fieldName, true);
    }

    public static VectorLayer createContourLayer(GridData gridData, String lName, String fieldName, boolean isSmooth) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.UNIQUE_VALUE, ShapeTypes.POLYLINE);
        return DrawMeteoData.createContourLayer(gridData, ls, lName, fieldName, isSmooth);
    }

    public static VectorLayer createContourLayer(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        GridData gridData = new GridData(data, x, y);
        return DrawMeteoData.createContourLayer(gridData, aLS, lName, fieldName, isSmooth);
    }

    public static VectorLayer createContourLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        Object[] cbs;
        List ContourLines;
        LegendScheme ls = aLS.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
            gridData.yReverse();
        }
        if ((ContourLines = (List)(cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1))[0]).isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        aLayer.editAddField(aDC);
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double aValue = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (int j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(aValue);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                aLayer.editCellValue(fieldName, shapeNum, (Object)aValue);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName);
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.CONTOUR);
        aLayer.getLabelSet().setDrawLabels(true);
        aLayer.getLabelSet().setDrawShadow(true);
        aLayer.getLabelSet().setShadowColor(Color.white);
        aLayer.getLabelSet().setYOffset(3);
        aLayer.getLabelSet().setFieldName(fieldName);
        aLayer.getLabelSet().setColorByLegend(true);
        aLayer.getLabelSet().setDynamicContourLabel(true);
        int decimaln = MIMath.getDecimalNum((double)cValues[0]);
        if (cValues.length > 1) {
            int decimaln2 = MIMath.getDecimalNum((double)(cValues[1] - cValues[0]));
            decimaln = Math.max(decimaln, decimaln2);
        }
        aLayer.getLabelSet().setDecimalDigits(decimaln);
        return aLayer;
    }

    public static VectorLayer createContourLayer(double[][] data, double[] xArray, double[] yArray, double missingValue, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        int[][] S1;
        LegendScheme ls = aLS.convertTo(ShapeTypes.POLYLINE);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        Object[] cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])xArray, (double[])yArray, (double)missingValue, (int[][])(S1 = new int[data.length][data[0].length]));
        List ContourLines = (List)cbs[0];
        if (ContourLines.isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        aLayer.editAddField(aDC);
        for (PolyLine aLine : ContourLines) {
            double aValue = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (PointD p : aLine.PointList) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = p.X;
                aPoint.Y = p.Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(aValue);
            aPolyline.setExtent(GeometryUtil.getPointsExtent(pList));
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                aLayer.editCellValue(fieldName, shapeNum, (Object)aValue);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName);
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.CONTOUR);
        aLayer.getLabelSet().setDrawLabels(true);
        aLayer.getLabelSet().setDrawShadow(true);
        aLayer.getLabelSet().setShadowColor(Color.white);
        aLayer.getLabelSet().setYOffset(3);
        aLayer.getLabelSet().setFieldName(fieldName);
        aLayer.getLabelSet().setColorByLegend(true);
        aLayer.getLabelSet().setDynamicContourLabel(true);
        return aLayer;
    }

    public static VectorLayer createShadedLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POLYGON);
        return DrawMeteoData.createShadedLayer(gridData, ls, lName, fieldName, true);
    }

    public static VectorLayer createShadedLayer(GridData gridData, String lName, String fieldName, boolean isSmooth) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POLYGON);
        return DrawMeteoData.createShadedLayer(gridData, ls, lName, fieldName, isSmooth);
    }

    /*
     * Unable to fully structure code
     */
    public static VectorLayer createShadedLayer(Array va, Array xa, Array ya, LegendScheme ls, String lName, String fieldName, boolean isSmooth) {
        minData = ArrayMath.min((Array)va).doubleValue();
        maxData = ArrayMath.max((Array)va).doubleValue();
        ls = ls.convertTo(ShapeTypes.POLYGON);
        cValues = ls.getValues(minData, maxData);
        nv = cValues.length;
        shape = va.getShape();
        S1 = new int[shape[0]][shape[1]];
        x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xa);
        y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ya);
        if (x[1] - x[0] < 0.0) {
            ArrayUtils.reverse((double[])x);
            va = va.flip(1);
        }
        if (y[1] - y[0] < 0.0) {
            ArrayUtils.reverse((double[])y);
            va = va.flip(0);
        }
        missingValue = -9999.0;
        data = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)va, (double)missingValue);
        cbs = ContourDraw.tracingContourLines((double[][])data, (double[])cValues, (double[])x, (double[])y, (double)missingValue, (int[][])S1);
        contourLines = (List)cbs[0];
        borders = (List)cbs[1];
        if (isSmooth) {
            contourLines = Contour.smoothLines((List)contourLines);
        }
        contourPolygons = ContourDraw.tracingPolygons((double[][])data, (List)contourLines, (List)borders, (double[])cValues);
        layer = new VectorLayer(ShapeTypes.POLYGON);
        field = new Field(fieldName + "_Low", DataType.DOUBLE);
        layer.editAddField(field);
        field = new Field(fieldName + "_High", DataType.DOUBLE);
        layer.editAddField(field);
        cbb = ls.findLegendBreak((Number)0);
        extendType = ls.getExtendType();
        block14: for (i = 0; i < contourPolygons.size(); ++i) {
            block30: {
                block31: {
                    block32: {
                        block28: {
                            block29: {
                                poly = (Polygon)contourPolygons.get(i);
                                v = poly.LowValue;
                                valueIdx = Arrays.binarySearch(cValues, v);
                                if (valueIdx < 0) {
                                    valueIdx = valueIdx == -1 ? 0 : -valueIdx;
                                }
                                if (valueIdx != nv - 1) break block28;
                                if (!poly.IsHighCenter) break block29;
                                if (!(maxData > ls.getMaxValue())) ** GOTO lbl-1000
                                switch (1.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        continue block14;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        min = v;
                                        max = maxData;
                                        break;
                                    }
                                }
                                break block30;
                            }
                            if (!(poly.HighValue > ls.getMaxValue())) ** GOTO lbl-1000
                            switch (1.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                                case 1: 
                                case 2: {
                                    continue block14;
                                }
                                default: lbl-1000:
                                // 2 sources

                                {
                                    max = v;
                                    min = cValues[valueIdx - 1];
                                    break;
                                }
                            }
                            break block30;
                        }
                        if (valueIdx != 0) break block31;
                        if (!poly.IsHighCenter) break block32;
                        if (!(v < ls.getMinValue())) ** GOTO lbl-1000
                        switch (1.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                            case 1: 
                            case 3: {
                                continue block14;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                min = v;
                                max = cValues[valueIdx + 1];
                                break;
                            }
                        }
                        break block30;
                    }
                    if (!(minData < ls.getMinValue())) ** GOTO lbl-1000
                    switch (1.$SwitchMap$org$meteoinfo$geometry$colors$ExtendType[extendType.ordinal()]) {
                        case 1: 
                        case 3: {
                            continue block14;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            max = poly.HighValue;
                            min = minData;
                            break;
                        }
                    }
                    break block30;
                }
                if (poly.LowValue == poly.HighValue) {
                    if (poly.IsHighCenter) {
                        min = v;
                        max = cValues[valueIdx + 1];
                    } else {
                        max = v;
                        min = cValues[valueIdx - 1];
                    }
                } else {
                    min = v;
                    max = poly.HighValue;
                }
            }
            pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (Object pointList : poly.OutLine.PointList) {
                aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = pointList.X;
                aPoint.Y = pointList.Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = min;
            aPolygonShape.highValue = max;
            if (poly.HasHoles()) {
                for (PolyLine holeLine : poly.HoleLines) {
                    pList = new ArrayList<E>();
                    for (PointD pointList : holeLine.PointList) {
                        aPoint = new org.meteoinfo.common.PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape((Shape)aPolygonShape, shapeNum)) continue;
                layer.editCellValue(fieldName + "_Low", shapeNum, (Object)aPolygonShape.lowValue);
                layer.editCellValue(fieldName + "_High", shapeNum, (Object)aPolygonShape.highValue);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(lName);
        ls.setFieldName(fieldName + "_Low");
        layer.setLegendScheme(ls);
        layer.setLayerDrawType(LayerDrawType.SHADED);
        return layer;
    }

    public static VectorLayer createShadedLayer_bak(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        GridData gridData = new GridData(data, x, y);
        return DrawMeteoData.createShadedLayer(gridData, aLS, lName, fieldName, isSmooth);
    }

    public static VectorLayer createShadedLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        LegendScheme ls = aLS.convertTo(ShapeTypes.POLYGON);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.getYNum()][gridData.getXNum()];
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        if (gridData.getXDelta() < 0.0) {
            ArrayUtils.reverse((double[])xArray);
            gridData.xReverse();
        }
        if (gridData.getYDelta() < 0.0) {
            ArrayUtils.reverse((double[])yArray);
            gridData.yReverse();
        }
        Object[] cbs = ContourDraw.tracingContourLines((double[][])gridData.getData(), (double[])cValues, (double[])xArray, (double[])yArray, (double)gridData.getDoubleMissingValue(), (int[][])S1);
        List ContourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        List ContourPolygons = ContourDraw.tracingPolygons((double[][])gridData.getData(), (List)ContourLines, (List)borders, (double[])cValues);
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON);
        Field aDC = new Field(fieldName + "_Low", DataType.DOUBLE);
        aLayer.editAddField(aDC);
        aDC = new Field(fieldName + "_High", DataType.DOUBLE);
        aLayer.editAddField(aDC);
        for (Polygon aPolygon : ContourPolygons) {
            int valueIdx;
            org.meteoinfo.common.PointD aPoint;
            double aValue = aPolygon.LowValue;
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (Object pointList : aPolygon.OutLine.PointList) {
                aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)pointList).X;
                aPoint.Y = ((PointD)pointList).Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonShape aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(GeometryUtil.getPointsExtent(pList));
            aPolygonShape.lowValue = aValue;
            if (aPolygon.HasHoles()) {
                for (PolyLine holeLine : aPolygon.HoleLines) {
                    if (holeLine.PointList.size() < 3) continue;
                    pList = new ArrayList();
                    for (PointD pointList : holeLine.PointList) {
                        aPoint = new org.meteoinfo.common.PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, aValue)) < 0) {
                valueIdx = -valueIdx - 1;
            }
            aPolygonShape.highValue = valueIdx >= cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!aPolygon.IsHighCenter && aPolygon.HighValue == aPolygon.LowValue) {
                aPolygonShape.highValue = aValue;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPolygonShape, shapeNum)) continue;
                aLayer.editCellValue(fieldName + "_Low", shapeNum, (Object)aPolygonShape.lowValue);
                aLayer.editCellValue(fieldName + "_High", shapeNum, (Object)aPolygonShape.highValue);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName + "_Low");
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.SHADED);
        return aLayer;
    }

    public static VectorLayer createGridFillLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POLYGON);
        return DrawMeteoData.createGridFillLayer(gridData, ls, lName, fieldName);
    }

    public static VectorLayer createGridFillLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        aLayer.editAddField(aDC);
        double XDelt = gridData.getXDelta();
        double YDelt = gridData.getYDelta();
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                ArrayList<org.meteoinfo.common.PointD> PList = new ArrayList<org.meteoinfo.common.PointD>();
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xArray[j] - XDelt / 2.0;
                aPoint.Y = yArray[i] - YDelt / 2.0;
                PList.add(aPoint);
                aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xArray[j] - XDelt / 2.0;
                aPoint.Y = yArray[i] + YDelt / 2.0;
                PList.add(aPoint);
                aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xArray[j] + XDelt / 2.0;
                aPoint.Y = yArray[i] + YDelt / 2.0;
                PList.add(aPoint);
                aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xArray[j] + XDelt / 2.0;
                aPoint.Y = yArray[i] - YDelt / 2.0;
                PList.add(aPoint);
                PList.add((org.meteoinfo.common.PointD)PList.get(0));
                PolygonShape aPGS = new PolygonShape();
                aPGS.highValue = aPGS.lowValue = gridData.getDoubleValue(i, j);
                aPGS.setPoints(PList);
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aPGS, shapeNum)) continue;
                    aLayer.editCellValue(fieldName, shapeNum, (Object)gridData.getDoubleValue(i, j));
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POLYGON));
        aLayer.setLayerDrawType(LayerDrawType.GRID_FILL);
        return aLayer;
    }

    public static VectorLayer createGridFillLayer(Array x_s, Array y_s, Array a, LegendScheme ls, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        aLayer.editAddField(aDC);
        int colNum = (int)x_s.getSize();
        int rowNum = (int)y_s.getSize();
        double x1 = 0.0;
        double y1 = 0.0;
        for (int i = 0; i < rowNum; ++i) {
            double yd;
            double y2;
            if (i == 0) {
                y1 = y_s.getDouble(i);
            }
            double y = y_s.getDouble(i);
            if (i < rowNum - 1) {
                y2 = y_s.getDouble(i + 1);
                yd = y2 - y;
            } else {
                y2 = y_s.getDouble(i - 1);
                yd = y - y2;
            }
            if (i == 0) {
                y1 -= yd * 0.5;
            }
            y2 = y + yd * 0.5;
            for (int j = 0; j < colNum; ++j) {
                double v;
                double xd;
                double x2;
                if (j == 0) {
                    x1 = x_s.getDouble(j);
                }
                double x = x_s.getDouble(j);
                if (j < colNum - 1) {
                    x2 = x_s.getDouble(j + 1);
                    xd = x2 - x;
                } else {
                    x2 = x_s.getDouble(j - 1);
                    xd = x - x2;
                }
                if (j == 0) {
                    x1 -= xd * 0.5;
                }
                x2 = x + xd * 0.5;
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                points.add(new org.meteoinfo.common.PointD(x1, y1));
                points.add(new org.meteoinfo.common.PointD(x1, y2));
                points.add(new org.meteoinfo.common.PointD(x2, y2));
                points.add(new org.meteoinfo.common.PointD(x2, y1));
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                ps.setPoints(points);
                ps.lowValue = v = a.getDouble(i * colNum + j);
                ps.highValue = v;
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape((Shape)ps, shapeNum)) {
                        aLayer.editCellValue(fieldName, shapeNum, (Object)v);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
                x1 = x2;
            }
            y1 = y2;
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName);
        aLayer.setLegendScheme(ls.convertTo(ShapeTypes.POLYGON));
        aLayer.setLayerDrawType(LayerDrawType.GRID_FILL);
        return aLayer;
    }

    public static VectorLayer createGridPointLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POINT);
        return DrawMeteoData.createGridPointLayer(gridData, ls, lName, fieldName);
    }

    public static VectorLayer createGridPointLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        aLayer.editAddField(aDC);
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xArray[j];
                aPoint.Y = yArray[i];
                PointShape aPointShape = new PointShape();
                aPointShape.setPoint(aPoint);
                aPointShape.setValue(gridData.getDoubleValue(i, j));
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aPointShape, shapeNum)) continue;
                    aLayer.editCellValue(fieldName, shapeNum, (Object)gridData.getDoubleValue(i, j));
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.GRID_POINT);
        return aLayer;
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.blue, 10.0f);
        ls.asArrow();
        return DrawMeteoData.createGridVectorLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, LegendScheme ls, String lName, boolean isUV) {
        ls.asArrow();
        return DrawMeteoData.createGridVectorLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, GridData gridData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POINT);
        for (int i = 0; i < ls.getBreakNum(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
            ls.setLegendBreak(i, (ColorBreak)new ArrowBreak(aPB));
        }
        return DrawMeteoData.createGridVectorLayer(uData, vData, gridData, ls, true, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, GridData gridData, LegendScheme ls, String lName, boolean isUV) {
        ls.asArrow();
        return DrawMeteoData.createGridVectorLayer(uData, vData, gridData, ls, true, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, GridData gridData, LegendScheme ls, boolean ifColor, String lName, boolean isUV) {
        int i;
        GridData windSpeedData;
        GridData windDirData;
        if (isUV) {
            GridData[] uv = DataMath.getDSFromUV((GridData)uData, (GridData)vData);
            windDirData = uv[0];
            windSpeedData = uv[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        float size = 6.0f;
        int XNum = uData.getXNum();
        int YNum = uData.getYNum();
        String columnName = lName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifColor && ifAdd) {
            aLayer.editAddField(columnName, DataType.FLOAT);
        }
        double[] xArray = uData.getXArray();
        double[] yArray = uData.getYArray();
        for (i = 0; i < YNum; ++i) {
            for (int j = 0; j < XNum; ++j) {
                double windDir = windDirData.getDoubleValue(i, j);
                double windSpeed = windSpeedData.getDoubleValue(i, j);
                if (MIMath.doubleEquals((double)windDir, (double)windDirData.getDoubleMissingValue()) || MIMath.doubleEquals((double)windSpeed, (double)windSpeedData.getDoubleMissingValue())) continue;
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xArray[j];
                aPoint.Y = yArray[i];
                WindArrow aArraw = new WindArrow();
                aArraw.angle = windDir;
                aArraw.length = (float)windSpeed;
                aArraw.size = size;
                aArraw.setPoint(aPoint);
                if (ifColor) {
                    aArraw.setValue(gridData.getDoubleValue(i, j));
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aArraw, shapeNum)) continue;
                    if (isUV) {
                        aLayer.editCellValue("U", shapeNum, (Object)uData.getDoubleValue(i, j));
                        aLayer.editCellValue("V", shapeNum, (Object)vData.getDoubleValue(i, j));
                    }
                    aLayer.editCellValue("WindDirection", shapeNum, (Object)aArraw.angle);
                    aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(aArraw.length));
                    if (!ifColor || !ifAdd) continue;
                    aLayer.editCellValue(columnName, shapeNum, (Object)gridData.getDoubleValue(i, j));
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        if (ifColor && ifAdd) {
            ls.setFieldName(columnName);
        } else {
            ls.setFieldName("WindSpeed");
        }
        LegendScheme nls = ls.convertTo(ShapeTypes.POINT);
        nls.asArrow();
        if (ls.getShapeType() != nls.getShapeType()) {
            for (i = 0; i < nls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)nls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(nls);
        aLayer.setLayerDrawType(LayerDrawType.VECTOR);
        return aLayer;
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.blue, 10.0f);
        ls.asArrow();
        return DrawMeteoData.createGridBarbLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, LegendScheme ls, String lName, boolean isUV) {
        ls.asArrow();
        return DrawMeteoData.createGridBarbLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, GridData gridData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POINT);
        for (int i = 0; i < ls.getBreakNum(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
        }
        return DrawMeteoData.createGridBarbLayer(uData, vData, gridData, ls, true, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, GridData gridData, LegendScheme aLS, String lName, boolean isUV) {
        return DrawMeteoData.createGridBarbLayer(uData, vData, gridData, aLS, true, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, GridData gridData, LegendScheme aLS, boolean ifColor, String lName, boolean isUV) {
        int i;
        GridData windSpeedData;
        GridData windDirData;
        if (isUV) {
            GridData[] wwData = DataMath.getDSFromUV((GridData)uData, (GridData)vData);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        int XNum = windDirData.getXNum();
        int YNum = windDirData.getYNum();
        String columnName = lName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifColor && ifAdd) {
            aLayer.editAddField(columnName, DataType.FLOAT);
        }
        double[] xArray = windDirData.getXArray();
        double[] yArray = windDirData.getYArray();
        for (i = 0; i < YNum; ++i) {
            for (int j = 0; j < XNum; ++j) {
                double windDir = windDirData.getDoubleValue(i, j);
                double windSpeed = windSpeedData.getDoubleValue(i, j);
                if (MIMath.doubleEquals((double)windDir, (double)windDirData.getDoubleMissingValue()) || MIMath.doubleEquals((double)windSpeed, (double)windSpeedData.getDoubleMissingValue())) continue;
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xArray[j];
                aPoint.Y = yArray[i];
                WindBarb aWB = Draw.calWindBarb((float)((float)windDir), (float)((float)windSpeed), (double)0.0, (float)10.0f, (org.meteoinfo.common.PointD)aPoint);
                if (ifColor) {
                    aWB.setValue(gridData.getDoubleValue(i, j));
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aWB, shapeNum)) continue;
                    if (isUV) {
                        aLayer.editCellValue("U", shapeNum, (Object)uData.getDoubleValue(i, j));
                        aLayer.editCellValue("V", shapeNum, (Object)vData.getDoubleValue(i, j));
                    }
                    aLayer.editCellValue("WindDirection", shapeNum, (Object)aWB.angle);
                    aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(aWB.windSpeed));
                    if (!ifColor || !ifAdd) continue;
                    aLayer.editCellValue(columnName, shapeNum, (Object)gridData.getDoubleValue(i, j));
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        if (ifColor && ifAdd) {
            aLS.setFieldName(columnName);
        } else {
            aLS.setFieldName("WindSpeed");
        }
        LegendScheme ls = aLS.convertTo(ShapeTypes.POINT);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.BARB);
        return aLayer;
    }

    public static VectorLayer createStreamlineLayer(GridData uData, GridData vData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYLINE, Color.blue, 1.0f);
        return DrawMeteoData.createStreamlineLayer(uData, vData, 4, ls, lName, isUV);
    }

    public static VectorLayer createStreamlineLayer(GridData uData, GridData vData, int density, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYLINE, Color.blue, 1.0f);
        return DrawMeteoData.createStreamlineLayer(uData, vData, density, ls, lName, isUV);
    }

    public static VectorLayer createStreamlineLayer(Array udata, Array vdata, Array xdata, Array ydata, int density, LegendScheme ls, String lName, boolean isUV) {
        if (!isUV) {
            Array[] uvData = MeteoMath.ds2uv((Array)udata, (Array)vdata);
            udata = uvData[0];
            vdata = uvData[1];
        }
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
        List streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE_Z);
        aLayer.editAddField("ID", DataType.INT);
        for (int i = 0; i < streamlines.size() - 1; ++i) {
            PolyLine aLine = (PolyLine)streamlines.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (int j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)density);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName("ID");
        if (ls.getShapeType() != ShapeTypes.POLYLINE) {
            ls = ls.convertTo(ShapeTypes.POLYLINE);
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.STREAMLINE);
        return aLayer;
    }

    public static VectorLayer createStreamlineLayer(Array udata, Array vdata, Array xdata, Array ydata, Array cdata, int density, LegendScheme ls, String lName, boolean isUV) {
        if (!isUV) {
            Array[] uvData = MeteoMath.ds2uv((Array)udata, (Array)vdata);
            udata = uvData[0];
            vdata = uvData[1];
        }
        double[][] u = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)udata);
        double[][] v = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)vdata);
        double[] x = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)xdata);
        double[] y = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)ydata);
        List streamlines = Contour.tracingStreamline((double[][])u, (double[][])v, (double[])x, (double[])y, (int)density);
        int ny = u.length;
        int nx = u[0].length;
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE_Z);
        aLayer.editAddField("ID", DataType.INT);
        for (int i = 0; i < streamlines.size() - 1; ++i) {
            PolyLine aLine = (PolyLine)streamlines.get(i);
            PolylineZShape aPolyline = new PolylineZShape();
            ArrayList<PointZ> pList = new ArrayList<PointZ>();
            double c = 0.0;
            for (int j = 0; j < aLine.PointList.size(); ++j) {
                PointZ p = new PointZ();
                p.X = ((PointD)aLine.PointList.get((int)j)).X;
                p.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                int[] idx = ArrayUtil.gridIndex((Array)xdata, (Array)ydata, (double)p.X, (double)p.Y);
                if (idx != null) {
                    int yi = idx[0];
                    int xi = idx[1];
                    c = cdata.getDouble(yi * nx + xi);
                }
                p.Z = c;
                pList.add(p);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)density);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName("Geometry_Z");
        if (ls.getShapeType() != ShapeTypes.POLYLINE) {
            ls = ls.convertTo(ShapeTypes.POLYLINE);
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.STREAMLINE);
        return aLayer;
    }

    public static VectorLayer createStreamlineLayer(GridData uData, GridData vData, int density, LegendScheme aLS, String lName, boolean isUV) {
        GridData vGridData;
        GridData uGridData;
        uData.asAscending();
        vData.asAscending();
        if (isUV) {
            uGridData = uData;
            vGridData = vData;
        } else {
            GridData[] uvData = DataMath.getUVFromDS((GridData)uData, (GridData)vData);
            uGridData = uvData[0];
            vGridData = uvData[1];
        }
        List streamlines = Contour.tracingStreamline((double[][])uGridData.getData(), (double[][])vGridData.getData(), (double[])uGridData.getXArray(), (double[])vGridData.getYArray(), (double)uGridData.getDoubleMissingValue(), (int)density);
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE);
        aLayer.editAddField("ID", DataType.INT);
        for (int i = 0; i < streamlines.size() - 1; ++i) {
            PolyLine aLine = (PolyLine)streamlines.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.common.PointD> pList = new ArrayList<org.meteoinfo.common.PointD>();
            for (int j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue((double)density);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPolyline, shapeNum)) continue;
                aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName("ID");
        if (aLS.getShapeType() != ShapeTypes.POLYLINE) {
            aLS = aLS.convertTo(ShapeTypes.POLYLINE);
        }
        aLayer.setLegendScheme(aLS);
        aLayer.setLayerDrawType(LayerDrawType.STREAMLINE);
        return aLayer;
    }

    public static ImageLayer createImageLayer(Array x, Array y, Graphic graphic, String layerName) {
        BufferedImage image = ((ImageShape)graphic.getShape()).getImage();
        return DrawMeteoData.createImageLayer(x, y, image, layerName);
    }

    public static ImageLayer createImageLayer(Array x, Array y, BufferedImage image, String layerName) {
        x = x.copyIfView();
        y = y.copyIfView();
        ImageLayer aImageLayer = new ImageLayer();
        aImageLayer.setImage(image);
        aImageLayer.setLayerName(layerName);
        aImageLayer.setVisible(true);
        WorldFilePara aWFP = new WorldFilePara();
        double xdelta = x.getDouble(1) - x.getDouble(0);
        double ydelta = y.getDouble(1) - y.getDouble(0);
        aWFP.xUL = x.getDouble(0) - xdelta / 2.0;
        aWFP.yUL = y.getDouble(y.getShape()[0] - 1) + ydelta / 2.0;
        aWFP.xScale = xdelta;
        aWFP.yScale = -ydelta;
        aWFP.xRotate = 0.0;
        aWFP.yRotate = 0.0;
        aImageLayer.setWorldFilePara(aWFP);
        double XBR = (double)aImageLayer.getImage().getWidth() * aImageLayer.getWorldFilePara().xScale + aImageLayer.getWorldFilePara().xUL;
        double YBR = (double)aImageLayer.getImage().getHeight() * aImageLayer.getWorldFilePara().yScale + aImageLayer.getWorldFilePara().yUL;
        Extent aExtent = new Extent();
        aExtent.minX = aImageLayer.getWorldFilePara().xUL;
        aExtent.minY = YBR;
        aExtent.maxX = XBR;
        aExtent.maxY = aImageLayer.getWorldFilePara().yUL;
        aImageLayer.setExtent(aExtent);
        aImageLayer.setLayerDrawType(LayerDrawType.IMAGE);
        aImageLayer.setMaskout(true);
        return aImageLayer;
    }

    public static RasterLayer createRasterLayer(GridData gridData, String lName) {
        LegendScheme ls;
        boolean isUnique = gridData.testUniqueValues();
        if (isUnique) {
            List values = gridData.getUniqueValues();
            ls = LegendManage.createUniqValueLegendScheme(values, ShapeTypes.POLYGON);
        } else {
            ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POLYGON);
        }
        return DrawMeteoData.createRasterLayer(gridData, lName, ls);
    }

    public static RasterLayer createRasterLayer(GridArray gridData, String lName) {
        LegendScheme ls;
        boolean isUnique = gridData.testUniqueValues();
        if (isUnique) {
            List values = gridData.getUniqueValues();
            ls = LegendManage.createUniqValueLegendScheme(values, ShapeTypes.POLYGON);
        } else {
            ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GRADUATED_COLOR, ShapeTypes.POLYGON);
        }
        return DrawMeteoData.createRasterLayer(gridData, lName, ls);
    }

    public static RasterLayer createRasterLayer(GridArray gridData, String LName, LegendScheme aLS) {
        RasterLayer aRLayer = new RasterLayer();
        aRLayer.setGridData(gridData);
        aRLayer.setShapeType(ShapeTypes.IMAGE);
        aRLayer.setLegendScheme(aLS.convertTo(ShapeTypes.IMAGE));
        aRLayer.setLayerName(LName);
        aRLayer.setVisible(true);
        aRLayer.setLayerDrawType(LayerDrawType.RASTER);
        aRLayer.setMaskout(true);
        return aRLayer;
    }

    public static RasterLayer createRasterLayer(Array data, Array xa, Array ya, double missingValue, String LName, LegendScheme aLS) {
        GridArray gridData = new GridArray(data, xa, ya, (Number)missingValue);
        return DrawMeteoData.createRasterLayer(gridData, LName, aLS);
    }

    public static RasterLayer createRasterLayer(GridData gridData, String LName, LegendScheme aLS) {
        RasterLayer aRLayer = new RasterLayer();
        aRLayer.setGridData(gridData.toGridArray());
        aRLayer.setShapeType(ShapeTypes.IMAGE);
        aRLayer.setLegendScheme(aLS.convertTo(ShapeTypes.IMAGE));
        aRLayer.setLayerName(LName);
        aRLayer.setVisible(true);
        aRLayer.setLayerDrawType(LayerDrawType.RASTER);
        aRLayer.setMaskout(true);
        return aRLayer;
    }

    public static RasterLayer createRasterLayer(GridData gridData, String LName, String paletteFile) {
        RasterLayer aRLayer = new RasterLayer();
        aRLayer.setGridData(gridData.toGridArray());
        aRLayer.setPalette(paletteFile);
        aRLayer.setLayerName(LName);
        aRLayer.setVisible(true);
        aRLayer.setLayerDrawType(LayerDrawType.RASTER);
        aRLayer.setMaskout(true);
        return aRLayer;
    }

    public static VectorLayer createSTPointLayer(StationData stationData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromStationData(stationData, LegendType.GRADUATED_COLOR, ShapeTypes.POINT);
        return DrawMeteoData.createSTPointLayer(stationData, ls, lName, fieldName);
    }

    public static VectorLayer createSTPointLayer(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName) {
        if (data.getRank() == 2 && x.getRank() == 1) {
            Array[] xy = ArrayUtil.meshgrid((Array)x, (Array)y);
            x = xy[0];
            y = xy[1];
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        aLayer.editAddField(fieldName, DataType.DOUBLE);
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        IndexIterator iter = data.getIndexIterator();
        while (iter.hasNext()) {
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = xIter.getDoubleNext();
            aPoint.Y = yIter.getDoubleNext();
            double v = iter.getDoubleNext();
            if (Double.isNaN(aPoint.X) || Double.isNaN(aPoint.Y) || Double.isNaN(v)) continue;
            PointShape aPointShape = new PointShape();
            aPointShape.setPoint(aPoint);
            aPointShape.setValue(v);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPointShape, shapeNum)) continue;
                aLayer.editCellValue(fieldName, shapeNum, (Object)v);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.STATION_POINT);
        return aLayer;
    }

    public static VectorLayer createSTPointLayer(StationData stationData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        aLayer.editAddField("Station", DataType.STRING);
        aLayer.editAddField(fieldName, DataType.DOUBLE);
        for (int i = 0; i < stationData.data.length; ++i) {
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = stationData.data[i][0];
            aPoint.Y = stationData.data[i][1];
            if (Double.isNaN(aPoint.X)) continue;
            PointShape aPointShape = new PointShape();
            aPointShape.setPoint(aPoint);
            aPointShape.setValue(stationData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPointShape, shapeNum)) continue;
                aLayer.editCellValue("Station", shapeNum, stationData.stations.get(i));
                aLayer.editCellValue(fieldName, shapeNum, (Object)stationData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.STATION_POINT);
        return aLayer;
    }

    public static VectorLayer createSTPointLayer_Unique(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName) {
        if (data.getRank() == 2 && x.getRank() == 1) {
            Array[] xy = ArrayUtil.meshgrid((Array)x, (Array)y);
            x = xy[0];
            y = xy[1];
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        aLayer.editAddField("ID", DataType.INT);
        aLayer.editAddField(fieldName, DataType.DOUBLE);
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        IndexIterator iter = data.getIndexIterator();
        while (iter.hasNext()) {
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = xIter.getDoubleNext();
            aPoint.Y = yIter.getDoubleNext();
            double v = iter.getDoubleNext();
            if (Double.isNaN(aPoint.X) || Double.isNaN(aPoint.Y)) continue;
            PointShape aPointShape = new PointShape();
            aPointShape.setPoint(aPoint);
            aPointShape.setValue(v);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPointShape, shapeNum)) continue;
                aLayer.editCellValue("ID", shapeNum, (Object)shapeNum);
                aLayer.editCellValue(fieldName, shapeNum, (Object)v);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName("ID");
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.STATION_POINT);
        return aLayer;
    }

    public static VectorLayer createSTPointLayer_Unique(StationData stationData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        aLayer.editAddField("ID", DataType.INT);
        aLayer.editAddField("Stid", DataType.STRING);
        aLayer.editAddField(fieldName, DataType.DOUBLE);
        for (int i = 0; i < stationData.data.length; ++i) {
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = stationData.data[i][0];
            aPoint.Y = stationData.data[i][1];
            if (Double.isNaN(aPoint.X)) continue;
            PointShape aPointShape = new PointShape();
            aPointShape.setPoint(aPoint);
            aPointShape.setValue(stationData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPointShape, shapeNum)) continue;
                aLayer.editCellValue("ID", shapeNum, (Object)i);
                aLayer.editCellValue("Stid", shapeNum, stationData.stations.get(i));
                aLayer.editCellValue(fieldName, shapeNum, (Object)stationData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName("ID");
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.STATION_POINT);
        return aLayer;
    }

    public static VectorLayer createSTInfoLayer(StationInfoData stInfoData, String layerName) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.red, 8.0f);
        return DrawMeteoData.createSTInfoLayer(stInfoData, ls, layerName);
    }

    public static VectorLayer createSTInfoLayer(StationInfoData stInfoData, LegendScheme aLS, String layerName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        DataFrame dataFrame = stInfoData.getDataFrame();
        if (dataFrame == null) {
            int i;
            for (i = 0; i < stInfoData.getFields().size(); ++i) {
                String fieldName = (String)stInfoData.getFields().get(i);
                DataType dtype = DataType.STRING;
                if (stInfoData.getVariables().contains(stInfoData.getFields().get(i))) {
                    dtype = DataType.DOUBLE;
                }
                aLayer.editAddField(fieldName, dtype);
            }
            for (i = 0; i < stInfoData.getDataList().size(); ++i) {
                List dataList = (List)stInfoData.getDataList().get(i);
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = Double.parseDouble((String)dataList.get(1));
                aPoint.Y = Double.parseDouble((String)dataList.get(2));
                PointShape aPointShape = new PointShape();
                aPointShape.setPoint(aPoint);
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aPointShape, shapeNum)) continue;
                    for (int j = 0; j < stInfoData.getFields().size(); ++j) {
                        if (stInfoData.getVariables().contains(stInfoData.getFields().get(j))) {
                            double v;
                            if (dataList.size() <= j) {
                                v = 9999.0;
                            } else if (((String)dataList.get(j)).isEmpty()) {
                                v = 9999.0;
                            } else {
                                try {
                                    v = Double.parseDouble((String)dataList.get(j));
                                }
                                catch (Exception e) {
                                    v = 9999.0;
                                }
                            }
                            aLayer.editCellValue((String)stInfoData.getFields().get(j), shapeNum, (Object)v);
                            continue;
                        }
                        aLayer.editCellValue((String)stInfoData.getFields().get(j), shapeNum, dataList.get(j));
                    }
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            int i;
            for (i = 0; i < dataFrame.size(); ++i) {
                String fieldName = (String)dataFrame.getColumnNames().get(i);
                DataType dataType = (DataType)dataFrame.getColumnDataTypes().get(i);
                aLayer.editAddField(fieldName, dataType);
            }
            for (i = 0; i < dataFrame.length(); ++i) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = ((Float)dataFrame.getValue(i, "Longitude")).floatValue();
                aPoint.Y = ((Float)dataFrame.getValue(i, "Latitude")).floatValue();
                PointShape aPointShape = new PointShape();
                aPointShape.setPoint(aPoint);
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aPointShape, shapeNum)) continue;
                    for (int j = 0; j < dataFrame.size(); ++j) {
                        aLayer.editCellValue(j, shapeNum, dataFrame.getValue(i, j));
                    }
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(layerName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.STATION_POINT);
        return aLayer;
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, StationData stData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromStationData(stData, LegendType.GRADUATED_COLOR, ShapeTypes.POINT);
        for (int i = 0; i < ls.getLegendBreaks().size(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
        }
        return DrawMeteoData.createSTVectorLayer(uData, vData, stData, ls, layerName, isUV);
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, StationData stData, LegendScheme aLS, String layerName, boolean isUV) {
        StationData windSpeedData;
        StationData windDirData;
        aLS.asArrow();
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV((StationData)uData, (StationData)vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WIND_ARROW);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataType.FLOAT);
        }
        for (int i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (MIMath.doubleEquals((double)windDir, (double)windDirData.missingValue) || MIMath.doubleEquals((double)windSpeed, (double)windSpeedData.missingValue)) continue;
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindArrow aArraw = new WindArrow();
            aArraw.angle = windDir;
            aArraw.length = windSpeed;
            aArraw.size = 6.0f;
            aArraw.setPoint(aPoint);
            aArraw.setValue(stData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aArraw, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                if (!ifAdd) continue;
                aLayer.editCellValue(columnName, shapeNum, (Object)stData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.VECTOR);
        return aLayer;
    }

    public static VectorLayer createVectorLayer(Array xData, Array yData, Array uData, Array vData, Array stData, LegendScheme aLS, String layerName, boolean isUV) {
        Array windSpeedData;
        Array windDirData;
        if (isUV) {
            Array[] dsData = MeteoMath.uv2ds((Array)uData, (Array)vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WIND_ARROW);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataType.FLOAT);
        }
        IndexIterator xIter = xData.getIndexIterator();
        IndexIterator yIter = yData.getIndexIterator();
        IndexIterator wdIter = windDirData.getIndexIterator();
        IndexIterator wsIter = windSpeedData.getIndexIterator();
        IndexIterator cIter = stData == null ? null : stData.getIndexIterator();
        IndexIterator uIter = uData.getIndexIterator();
        IndexIterator vIter = vData.getIndexIterator();
        double v = 0.0;
        while (xIter.hasNext()) {
            double windDir = wdIter.getFloatNext();
            double windSpeed = wsIter.getFloatNext();
            if (!Double.isNaN(windDir) && !Double.isNaN(windSpeed)) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                WindArrow aArraw = new WindArrow();
                aArraw.angle = windDir;
                aArraw.length = (float)windSpeed;
                aArraw.size = 6.0f;
                aArraw.setPoint(aPoint);
                if (stData != null) {
                    v = cIter.getDoubleNext();
                    aArraw.setValue(v);
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aArraw, shapeNum)) continue;
                    if (isUV) {
                        aLayer.editCellValue("U", shapeNum, (Object)uIter.getDoubleNext());
                        aLayer.editCellValue("V", shapeNum, (Object)vIter.getDoubleNext());
                    }
                    aLayer.editCellValue("WindDirection", shapeNum, (Object)windDir);
                    aLayer.editCellValue("WindSpeed", shapeNum, (Object)windSpeed);
                    if (!ifAdd || stData == null) continue;
                    aLayer.editCellValue(columnName, shapeNum, (Object)v);
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            xIter.next();
            yIter.next();
            uIter.next();
            vIter.next();
            if (stData == null) continue;
            cIter.next();
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.VECTOR);
        return aLayer;
    }

    public static VectorLayer createBarbLayer(Array xData, Array yData, Array uData, Array vData, Array stData, LegendScheme aLS, String layerName, boolean isUV) {
        Array windSpeedData;
        Array windDirData;
        if (isUV) {
            Array[] dsData = MeteoMath.uv2ds((Array)uData, (Array)vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WIND_ARROW);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataType.FLOAT);
        }
        IndexIterator xIter = xData.getIndexIterator();
        IndexIterator yIter = yData.getIndexIterator();
        IndexIterator wdIter = windDirData.getIndexIterator();
        IndexIterator wsIter = windSpeedData.getIndexIterator();
        IndexIterator cIter = stData == null ? null : stData.getIndexIterator();
        IndexIterator uIter = uData.getIndexIterator();
        IndexIterator vIter = vData.getIndexIterator();
        double v = 0.0;
        while (xIter.hasNext()) {
            double windDir = wdIter.getFloatNext();
            double windSpeed = wsIter.getFloatNext();
            if (!Double.isNaN(windDir) && !Double.isNaN(windSpeed)) {
                org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
                aPoint.X = xIter.getDoubleNext();
                aPoint.Y = yIter.getDoubleNext();
                WindBarb aWB = Draw.calWindBarb((float)((float)windDir), (float)((float)windSpeed), (double)0.0, (float)10.0f, (org.meteoinfo.common.PointD)aPoint);
                if (stData != null) {
                    v = cIter.getDoubleNext();
                    aWB.setValue(v);
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape((Shape)aWB, shapeNum)) continue;
                    if (isUV) {
                        aLayer.editCellValue("U", shapeNum, (Object)uIter.getDoubleNext());
                        aLayer.editCellValue("V", shapeNum, (Object)vIter.getDoubleNext());
                    }
                    aLayer.editCellValue("WindDirection", shapeNum, (Object)aWB.angle);
                    aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(aWB.windSpeed));
                    if (!ifAdd || stData == null) continue;
                    aLayer.editCellValue(columnName, shapeNum, (Object)v);
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            xIter.next();
            yIter.next();
            uIter.next();
            vIter.next();
            if (cIter == null) continue;
            cIter.next();
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.POINT));
        aLayer.setLayerDrawType(LayerDrawType.BARB);
        return aLayer;
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.blue, 10.0f);
        return DrawMeteoData.createSTVectorLayer(uData, vData, ls, layerName, isUV);
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, LegendScheme aLS, String layerName, boolean isUV) {
        int i;
        StationData windSpeedData;
        StationData windDirData;
        aLS.asArrow();
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV((StationData)uData, (StationData)vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WIND_ARROW);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        for (i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (MIMath.doubleEquals((double)windDir, (double)windDirData.missingValue) || MIMath.doubleEquals((double)windSpeed, (double)windSpeedData.missingValue)) continue;
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindArrow aArraw = new WindArrow();
            aArraw.angle = windDir;
            aArraw.length = windSpeed;
            aArraw.size = 6.0f;
            aArraw.setPoint(aPoint);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aArraw, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        LegendScheme ls = aLS.convertTo(ShapeTypes.POINT);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.VECTOR);
        return aLayer;
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, StationData stData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromStationData(stData, LegendType.GRADUATED_COLOR, ShapeTypes.POINT);
        for (int i = 0; i < ls.getLegendBreaks().size(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
        }
        return DrawMeteoData.createSTBarbLayer(uData, vData, stData, ls, layerName, isUV);
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, StationData stData, LegendScheme aLS, String layerName, boolean isUV) {
        int i;
        StationData windSpeedData;
        StationData windDirData;
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV((StationData)uData, (StationData)vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WIND_BARB);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataType.FLOAT);
        }
        for (i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (windSpeed == 0.0f || MIMath.doubleEquals((double)windDir, (double)windDirData.missingValue) || MIMath.doubleEquals((double)windSpeed, (double)windSpeedData.missingValue)) continue;
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindBarb aWB = Draw.calWindBarb((float)windDir, (float)windSpeed, (double)0.0, (float)10.0f, (org.meteoinfo.common.PointD)aPoint);
            aWB.setValue(stData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aWB, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                if (!ifAdd) continue;
                aLayer.editCellValue(columnName, shapeNum, (Object)stData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        LegendScheme ls = aLS.convertTo(ShapeTypes.POINT);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.BARB);
        return aLayer;
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.blue, 10.0f);
        return DrawMeteoData.createSTBarbLayer(uData, vData, ls, layerName, isUV);
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, LegendScheme aLS, String layerName, boolean isUV) {
        int i;
        StationData windSpeedData;
        StationData windDirData;
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV((StationData)uData, (StationData)vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WIND_BARB);
        if (isUV) {
            aLayer.editAddField("U", DataType.FLOAT);
            aLayer.editAddField("V", DataType.FLOAT);
        }
        aLayer.editAddField("WindDirection", DataType.FLOAT);
        aLayer.editAddField("WindSpeed", DataType.FLOAT);
        for (i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (windSpeed == 0.0f || MIMath.doubleEquals((double)windDir, (double)windDirData.missingValue) || MIMath.doubleEquals((double)windSpeed, (double)windSpeedData.missingValue)) continue;
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindBarb aWB = Draw.calWindBarb((float)windDir, (float)windSpeed, (double)0.0, (float)10.0f, (org.meteoinfo.common.PointD)aPoint);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aWB, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        LegendScheme ls = aLS.convertTo(ShapeTypes.POINT);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.BARB);
        return aLayer;
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, String layerName) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.blue, 12.0f);
        return DrawMeteoData.createStationModelLayer(stationModelData, layerName, true);
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, String layerName, boolean isSurface) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.blue, 12.0f);
        return DrawMeteoData.createStationModelLayer(stationModelData, ls, layerName, isSurface);
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, LegendScheme aLS, String layerName) {
        return DrawMeteoData.createStationModelLayer(stationModelData, aLS, layerName, true);
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, LegendScheme aLS, String layerName, boolean isSurface) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        aLayer.editAddField(new Field("WindDirection", DataType.FLOAT));
        aLayer.editAddField(new Field("WindSpeed", DataType.FLOAT));
        aLayer.editAddField(new Field("Weather", DataType.INT));
        aLayer.editAddField(new Field("Temperature", DataType.INT));
        aLayer.editAddField(new Field("DewPoint", DataType.INT));
        aLayer.editAddField(new Field("Pressure", DataType.INT));
        aLayer.editAddField(new Field("CloudCoverage", DataType.INT));
        for (int i = 0; i < stationModelData.getDataNum(); ++i) {
            StationModel sm = (StationModel)stationModelData.getData().get(i);
            float windDir = (float)sm.getWindDirection();
            float windSpeed = (float)sm.getWindSpeed();
            if (MIMath.doubleEquals((double)windDir, (double)stationModelData.getMissingValue()) || MIMath.doubleEquals((double)windSpeed, (double)stationModelData.getMissingValue())) continue;
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = (float)sm.getLongitude();
            aPoint.Y = (float)sm.getLatitude();
            int weather = (int)sm.getWeather();
            int cCover = (int)sm.getCloudCover();
            int temp = (int)sm.getTemperature();
            int dewPoint = (int)sm.getDewPoint();
            int pressure = (int)sm.getPressure();
            if (isSurface && !MIMath.doubleEquals((double)sm.getPressure(), (double)stationModelData.getMissingValue())) {
                String pStr = String.valueOf((int)(sm.getPressure() * 10.0));
                if (pStr.length() < 3) {
                    pressure = (int)stationModelData.getMissingValue();
                } else {
                    pStr = pStr.substring(pStr.length() - 3);
                    pressure = Integer.parseInt(pStr);
                }
            }
            StationModelShape aSM = Draw.calStationModel((float)windDir, (float)windSpeed, (double)0.0, (float)12.0f, (org.meteoinfo.common.PointD)aPoint, (int)weather, (int)temp, (int)dewPoint, (int)pressure, (int)cCover);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aSM, shapeNum)) continue;
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                aLayer.editCellValue("Weather", shapeNum, (Object)weather);
                aLayer.editCellValue("Temperature", shapeNum, (Object)temp);
                aLayer.editCellValue("DewPoint", shapeNum, (Object)dewPoint);
                aLayer.editCellValue("Pressure", shapeNum, (Object)pressure);
                aLayer.editCellValue("CloudCoverage", shapeNum, (Object)cCover);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName("");
        aLayer.setLegendScheme(aLS);
        aLayer.setAvoidCollision(true);
        aLayer.setLayerDrawType(LayerDrawType.STATION_MODEL);
        return aLayer;
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, String layerName) {
        return DrawMeteoData.createWeatherSymbolLayer(weatherData, "All Weather", layerName);
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, String WeatherType, String layerName) {
        List<Integer> wList = DrawMeteoData.getWeatherTypes(WeatherType);
        return DrawMeteoData.createWeatherSymbolLayer(weatherData, wList, layerName);
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, List<Integer> wList, String layerName) {
        LegendScheme aLS = DrawMeteoData.createWeatherLegendScheme(wList, 20, Color.blue);
        return DrawMeteoData.createWeatherSymbolLayer(weatherData, wList, aLS, layerName);
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, List<Integer> wList, LegendScheme aLS, String layerName) {
        String columnName = "Weather";
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        aLayer.editAddField(columnName, DataType.DOUBLE);
        for (int i = 0; i < weatherData.getStNum(); ++i) {
            int weather = (int)weatherData.data[i][2];
            if (MIMath.doubleEquals((double)weather, (double)weatherData.missingValue) || !wList.contains(weather)) continue;
            org.meteoinfo.common.PointD aPoint = new org.meteoinfo.common.PointD();
            aPoint.X = weatherData.data[i][0];
            aPoint.Y = weatherData.data[i][1];
            PointShape aPS = new PointShape();
            aPS.setPoint(aPoint);
            aPS.setValue((double)weather);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape((Shape)aPS, shapeNum)) continue;
                aLayer.editCellValue(columnName, shapeNum, (Object)weather);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS);
        aLayer.setLayerDrawType(LayerDrawType.STATION_POINT);
        return aLayer;
    }

    public static LegendScheme createWeatherLegendScheme(List<Integer> wList, int size, Color color) {
        LegendScheme aLS = new LegendScheme(ShapeTypes.POINT);
        aLS.setLegendType(LegendType.UNIQUE_VALUE);
        for (int w : wList) {
            PointBreak aPB = new PointBreak();
            aPB.setMarkerType(MarkerType.CHARACTER);
            aPB.setSize((float)size);
            aPB.setColor(color);
            aPB.setFontName("Weather");
            aPB.setStartValue((Object)w);
            aPB.setEndValue((Object)w);
            int charIdx = w + 28;
            if (w == 99) {
                charIdx = w + 97;
            }
            aPB.setCharIndex(charIdx);
            aPB.setCaption(String.valueOf(w));
            aLS.getLegendBreaks().add(aPB);
        }
        return aLS;
    }

    public static List<Integer> getWeatherTypes(String weatherType) {
        int[] weathers;
        ArrayList<Integer> weatherList = new ArrayList<Integer>();
        switch (weatherType.toLowerCase()) {
            default: {
                int i;
                weathers = new int[96];
                for (i = 4; i < 100; ++i) {
                    weathers[i - 4] = i;
                }
                break;
            }
            case "sds": 
            case "dust": {
                weathers = new int[]{6, 7, 8, 9, 30, 31, 32, 33, 34, 35};
                break;
            }
            case "sds, haze": {
                weathers = new int[]{5, 6, 7, 8, 9, 30, 31, 32, 33, 34, 35};
                break;
            }
            case "smoke, haze, mist": {
                weathers = new int[]{4, 5, 10};
                break;
            }
            case "smoke": {
                weathers = new int[]{4};
                break;
            }
            case "haze": {
                weathers = new int[]{5};
                break;
            }
            case "mist": {
                weathers = new int[]{10};
                break;
            }
            case "Fog": {
                int i;
                weathers = new int[10];
                for (i = 40; i < 50; ++i) {
                    weathers[i - 40] = i;
                }
            }
        }
        for (Object w : (String)weathers) {
            weatherList.add((int)w);
        }
        return weatherList;
    }

    public static LegendScheme createCloudLegendScheme(int size, Color color) {
        int[] clouds;
        LegendScheme aLS = new LegendScheme(ShapeTypes.POINT);
        aLS.setLegendType(LegendType.UNIQUE_VALUE);
        for (int w : clouds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}) {
            PointBreak aPB = new PointBreak();
            aPB.setMarkerType(MarkerType.CHARACTER);
            aPB.setSize((float)size);
            aPB.setColor(color);
            aPB.setFontName("Weather");
            aPB.setStartValue((Object)w);
            aPB.setEndValue((Object)w);
            int charIdx = w + 197;
            aPB.setCharIndex(charIdx);
            aPB.setCaption(String.valueOf(w));
            aLS.getLegendBreaks().add(aPB);
        }
        return aLS;
    }

    public static VectorLayer meshLayer(Array x_s, Array y_s, Array a, LegendScheme ls, double lonlim) {
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYGON);
        String fieldName = "Data";
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                double x1 = x_s.getDouble(i * colNum + j);
                double x2 = x_s.getDouble(i * colNum + j + 1);
                double x3 = x_s.getDouble((i + 1) * colNum + j);
                double x4 = x_s.getDouble((i + 1) * colNum + j + 1);
                if (lonlim > 0.0 && (Math.abs(x2 - x4) > lonlim || Math.abs(x1 - x4) > lonlim || Math.abs(x3 - x4) > lonlim || Math.abs(x1 - x2) > lonlim || Math.abs(x2 - x3) > lonlim)) continue;
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                points.add(new org.meteoinfo.common.PointD(x1, y_s.getDouble(i * colNum + j)));
                points.add(new org.meteoinfo.common.PointD(x3, y_s.getDouble((i + 1) * colNum + j)));
                points.add(new org.meteoinfo.common.PointD(x4, y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new org.meteoinfo.common.PointD(x2, y_s.getDouble(i * colNum + j + 1)));
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                ps.setPoints(points);
                ps.highValue = ps.lowValue = a.getDouble(i * colNum + j);
                int shapeNum = layer.getShapeNum();
                try {
                    if (!layer.editInsertShape((Shape)ps, shapeNum)) continue;
                    layer.editCellValue(fieldName, shapeNum, (Object)ps.lowValue);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        layer.setLayerName("Mesh_Layer");
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls.convertTo(ShapeTypes.POLYGON));
        return layer;
    }

    public static VectorLayer meshLayer(Array x_s, Array y_s, Array a, LegendScheme ls) {
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYGON);
        String fieldName = "Data";
        Field aDC = new Field(fieldName, DataType.DOUBLE);
        layer.editAddField(aDC);
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                double x1 = x_s.getDouble(i * colNum + j);
                double x2 = x_s.getDouble(i * colNum + j + 1);
                double x3 = x_s.getDouble((i + 1) * colNum + j);
                double x4 = x_s.getDouble((i + 1) * colNum + j + 1);
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                points.add(new org.meteoinfo.common.PointD(x1, y_s.getDouble(i * colNum + j)));
                points.add(new org.meteoinfo.common.PointD(x3, y_s.getDouble((i + 1) * colNum + j)));
                points.add(new org.meteoinfo.common.PointD(x4, y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new org.meteoinfo.common.PointD(x2, y_s.getDouble(i * colNum + j + 1)));
                points.add((org.meteoinfo.common.PointD)((org.meteoinfo.common.PointD)points.get(0)).clone());
                ps.setPoints(points);
                ps.highValue = ps.lowValue = a.getDouble(i * colNum + j);
                int shapeNum = layer.getShapeNum();
                try {
                    if (!layer.editInsertShape((Shape)ps, shapeNum)) continue;
                    layer.editCellValue(fieldName, shapeNum, (Object)ps.lowValue);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        layer.setLayerName("Mesh_Layer");
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls.convertTo(ShapeTypes.POLYGON));
        return layer;
    }

    public static VectorLayer createTrajLineLayer(ITrajDataInfo trajDataInfo) {
        List dataTables = trajDataInfo.getDataTables();
        List trajInfoList = trajDataInfo.getTrajInfoList();
        String xVarName = trajDataInfo.getXVarName();
        String yVarName = trajDataInfo.getYVarName();
        String zVarName = trajDataInfo.getZVarName();
        ShapeTypes shapeType = zVarName == null ? ShapeTypes.POLYLINE : ShapeTypes.POLYLINE_Z;
        VectorLayer layer = new VectorLayer(shapeType);
        layer.editAddField(new Field("TrajIndex", DataType.INT));
        layer.editAddField(new Field("TrajName", DataType.STRING));
        layer.editAddField(new Field("TrajID", DataType.STRING));
        layer.editAddField(new Field("TrajCenter", DataType.STRING));
        layer.editAddField(new Field("StartDate", DataType.DATE));
        layer.editAddField(new Field("StartLon", DataType.DOUBLE));
        layer.editAddField(new Field("StartLat", DataType.DOUBLE));
        layer.editAddField(new Field("StartHeight", DataType.DOUBLE));
        int trajIdx = 0;
        if (shapeType == ShapeTypes.POLYLINE) {
            for (DataTable dataTable : dataTables) {
                TrajectoryInfo trajInfo = (TrajectoryInfo)trajInfoList.get(trajIdx);
                ArrayList<org.meteoinfo.common.PointD> points = new ArrayList<org.meteoinfo.common.PointD>();
                for (int i = 0; i < dataTable.getRowCount(); ++i) {
                    double x = Double.parseDouble(dataTable.getValue(i, xVarName).toString());
                    double y = Double.parseDouble(dataTable.getValue(i, yVarName).toString());
                    points.add(new org.meteoinfo.common.PointD(x, y));
                }
                PolylineShape polylineShape = new PolylineShape();
                polylineShape.setPoints(points);
                int shapeNum = layer.getShapeNum();
                try {
                    if (layer.editInsertShape((Shape)polylineShape, shapeNum)) {
                        layer.editCellValue("TrajIndex", shapeNum, (Object)(trajIdx + 1));
                        layer.editCellValue("TrajName", shapeNum, (Object)trajInfo.trajName);
                        layer.editCellValue("TrajID", shapeNum, (Object)trajInfo.trajID);
                        layer.editCellValue("TrajCenter", shapeNum, (Object)trajInfo.trajCenter);
                        layer.editCellValue("StartDate", shapeNum, (Object)trajInfo.startTime);
                        layer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(trajInfo.startLat));
                        layer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(trajInfo.startLon));
                        layer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(trajInfo.startHeight));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++trajIdx;
            }
        } else {
            for (DataTable dataTable : dataTables) {
                TrajectoryInfo trajInfo = (TrajectoryInfo)trajInfoList.get(trajIdx);
                ArrayList<PointZ> points = new ArrayList<PointZ>();
                for (int i = 0; i < dataTable.getRowCount(); ++i) {
                    double x = Double.parseDouble(dataTable.getValue(i, xVarName).toString());
                    double y = Double.parseDouble(dataTable.getValue(i, yVarName).toString());
                    double z = Double.parseDouble(dataTable.getValue(i, zVarName).toString());
                    points.add(new PointZ(x, y, z));
                }
                PolylineZShape polylineShape = new PolylineZShape();
                polylineShape.setPoints(points);
                int shapeNum = layer.getShapeNum();
                try {
                    if (layer.editInsertShape((Shape)polylineShape, shapeNum)) {
                        layer.editCellValue("TrajIndex", shapeNum, (Object)(trajIdx + 1));
                        layer.editCellValue("TrajName", shapeNum, (Object)trajInfo.trajName);
                        layer.editCellValue("TrajID", shapeNum, (Object)trajInfo.trajID);
                        layer.editCellValue("TrajCenter", shapeNum, (Object)trajInfo.trajCenter);
                        layer.editCellValue("StartDate", shapeNum, (Object)trajInfo.startTime);
                        layer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(trajInfo.startLat));
                        layer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(trajInfo.startLon));
                        layer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(trajInfo.startHeight));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++trajIdx;
            }
        }
        layer.setLayerName("Trajectory_Lines");
        layer.setLayerDrawType(LayerDrawType.TRAJECTORY_LINE);
        layer.setVisible(true);
        layer.updateLegendScheme(LegendType.UNIQUE_VALUE, "TrajID");
        return layer;
    }

    public static VectorLayer createTrajLineLayer(ITrajDataInfo trajDataInfo, String varName) {
        List dataTables = trajDataInfo.getDataTables();
        List trajInfoList = trajDataInfo.getTrajInfoList();
        String xVarName = trajDataInfo.getXVarName();
        String yVarName = trajDataInfo.getYVarName();
        String zVarName = trajDataInfo.getZVarName();
        VectorLayer layer = new VectorLayer(ShapeTypes.POLYLINE_Z);
        layer.editAddField(new Field("TrajIndex", DataType.INT));
        layer.editAddField(new Field("TrajName", DataType.STRING));
        layer.editAddField(new Field("TrajID", DataType.STRING));
        layer.editAddField(new Field("TrajCenter", DataType.STRING));
        layer.editAddField(new Field("StartDate", DataType.DATE));
        layer.editAddField(new Field("StartLon", DataType.DOUBLE));
        layer.editAddField(new Field("StartLat", DataType.DOUBLE));
        layer.editAddField(new Field("StartHeight", DataType.DOUBLE));
        int trajIdx = 0;
        for (DataTable dataTable : dataTables) {
            TrajectoryInfo trajInfo = (TrajectoryInfo)trajInfoList.get(trajIdx);
            ArrayList<PointZ> points = new ArrayList<PointZ>();
            for (int i = 0; i < dataTable.getRowCount(); ++i) {
                double x = Double.parseDouble(dataTable.getValue(i, xVarName).toString());
                double y = Double.parseDouble(dataTable.getValue(i, yVarName).toString());
                double z = zVarName == null ? 0.0 : Double.parseDouble(dataTable.getValue(i, zVarName).toString());
                double m = Double.parseDouble(dataTable.getValue(i, varName).toString());
                points.add(new PointZ(x, y, z, m));
            }
            PolylineZShape polylineShape = new PolylineZShape();
            polylineShape.setPoints(points);
            int shapeNum = layer.getShapeNum();
            try {
                if (layer.editInsertShape((Shape)polylineShape, shapeNum)) {
                    layer.editCellValue("TrajIndex", shapeNum, (Object)(trajIdx + 1));
                    layer.editCellValue("TrajName", shapeNum, (Object)trajInfo.trajName);
                    layer.editCellValue("TrajID", shapeNum, (Object)trajInfo.trajID);
                    layer.editCellValue("TrajCenter", shapeNum, (Object)trajInfo.trajCenter);
                    layer.editCellValue("StartDate", shapeNum, (Object)trajInfo.startTime);
                    layer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(trajInfo.startLat));
                    layer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(trajInfo.startLon));
                    layer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(trajInfo.startHeight));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++trajIdx;
        }
        layer.setLayerName("Trajectory_Lines");
        layer.setLayerDrawType(LayerDrawType.TRAJECTORY_LINE);
        layer.setVisible(true);
        layer.updateLegendScheme(LegendType.UNIQUE_VALUE, "TrajID");
        return layer;
    }

    public static VectorLayer createTrajPointLayer(ITrajDataInfo trajDataInfo) {
        List dataTables = trajDataInfo.getDataTables();
        List variables = trajDataInfo.getVariables();
        String xVarName = trajDataInfo.getXVarName();
        String yVarName = trajDataInfo.getYVarName();
        String zVarName = trajDataInfo.getZVarName();
        VectorLayer layer = new VectorLayer(ShapeTypes.POINT_Z);
        layer.editAddField(new Field("TrajID", DataType.INT));
        for (Variable variable : variables) {
            layer.editAddField(new Field(variable.getName(), variable.getDataType()));
        }
        int trajIdx = 0;
        for (DataTable dataTable : dataTables) {
            for (int i = 0; i < dataTable.getRowCount(); ++i) {
                double x = Double.parseDouble(dataTable.getValue(i, xVarName).toString());
                double y = Double.parseDouble(dataTable.getValue(i, yVarName).toString());
                double z = zVarName == null ? 0.0 : Double.parseDouble(dataTable.getValue(i, zVarName).toString());
                PointZ point = new PointZ(x, y, z);
                PointZShape pointZShape = new PointZShape();
                pointZShape.setPoint((org.meteoinfo.common.PointD)point);
                int shapeNum = layer.getShapeNum();
                try {
                    if (!layer.editInsertShape((Shape)pointZShape, shapeNum)) continue;
                    layer.editCellValue("TrajID", shapeNum, (Object)(trajIdx + 1));
                    for (Variable variable : variables) {
                        layer.editCellValue(variable.getName(), shapeNum, dataTable.getValue(i, variable.getName()));
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++trajIdx;
        }
        layer.setLayerName("Trajectory_Points");
        layer.setLayerDrawType(LayerDrawType.TRAJECTORY_POINT);
        layer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.red, 5.0f);
        aLS.setFieldName("TrajID");
        layer.setLegendScheme(aLS);
        return layer;
    }

    public static VectorLayer createTrajStartPointLayer(ITrajDataInfo trajDataInfo) {
        List dataTables = trajDataInfo.getDataTables();
        List trajInfoList = trajDataInfo.getTrajInfoList();
        String xVarName = trajDataInfo.getXVarName();
        String yVarName = trajDataInfo.getYVarName();
        String zVarName = trajDataInfo.getZVarName();
        VectorLayer layer = new VectorLayer(ShapeTypes.POINT_Z);
        layer.editAddField(new Field("TrajIndex", DataType.INT));
        layer.editAddField(new Field("TrajName", DataType.STRING));
        layer.editAddField(new Field("TrajID", DataType.STRING));
        layer.editAddField(new Field("TrajCenter", DataType.STRING));
        layer.editAddField(new Field("StartDate", DataType.DATE));
        layer.editAddField(new Field("StartLon", DataType.DOUBLE));
        layer.editAddField(new Field("StartLat", DataType.DOUBLE));
        layer.editAddField(new Field("StartHeight", DataType.DOUBLE));
        int trajIdx = 0;
        for (DataTable dataTable : dataTables) {
            TrajectoryInfo trajInfo = (TrajectoryInfo)trajInfoList.get(trajIdx);
            ArrayList points = new ArrayList();
            double x = Double.parseDouble(dataTable.getValue(0, xVarName).toString());
            double y = Double.parseDouble(dataTable.getValue(0, yVarName).toString());
            double z = zVarName == null ? 0.0 : Double.parseDouble(dataTable.getValue(0, zVarName).toString());
            PointZShape pointZShape = new PointZShape();
            pointZShape.setPoint((org.meteoinfo.common.PointD)new PointZ(x, y, z));
            int shapeNum = layer.getShapeNum();
            try {
                if (layer.editInsertShape((Shape)pointZShape, shapeNum)) {
                    layer.editCellValue("TrajIndex", shapeNum, (Object)(trajIdx + 1));
                    layer.editCellValue("TrajName", shapeNum, (Object)trajInfo.trajName);
                    layer.editCellValue("TrajID", shapeNum, (Object)trajInfo.trajID);
                    layer.editCellValue("TrajCenter", shapeNum, (Object)trajInfo.trajCenter);
                    layer.editCellValue("StartDate", shapeNum, (Object)trajInfo.startTime);
                    layer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(trajInfo.startLat));
                    layer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(trajInfo.startLon));
                    layer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(trajInfo.startHeight));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++trajIdx;
        }
        layer.setLayerName("Trajectory_Start_Points");
        layer.setLayerDrawType(LayerDrawType.TRAJECTORY_POINT);
        layer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.black, 8.0f);
        aLS.setFieldName("TrajID");
        layer.setLegendScheme(aLS);
        return layer;
    }
}

