/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.workarounds;

import bibliothek.util.workarounds.Java6Workaround;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Method;

public class Java7Workaround
extends Java6Workaround {
    private boolean supports(String translucencyName) {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            Class<?> windowTransulcency = Class.forName("java.awt.GraphicsDevice$WindowTranslucency");
            Method isWindowTranslucencySupported = GraphicsDevice.class.getMethod("isWindowTranslucencySupported", windowTransulcency);
            return (Boolean)isWindowTranslucencySupported.invoke((Object)gd, windowTransulcency.getField(translucencyName).get(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean supportsPerpixelTransparency(Window window) {
        return this.supports("PERPIXEL_TRANSPARENT");
    }

    @Override
    public boolean supportsPerpixelTranslucency(Window window) {
        return this.supports("PERPIXEL_TRANSLUCENT");
    }

    @Override
    public boolean setTransparent(Window window, Shape shape) {
        if (!this.supportsPerpixelTransparency(window)) {
            return false;
        }
        try {
            Method setShape = Window.class.getMethod("setShape", Shape.class);
            setShape.invoke((Object)window, shape);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean setTranslucent(Window window) {
        if (!this.supportsPerpixelTranslucency(window)) {
            return false;
        }
        try {
            window.setBackground(new Color(0, 0, 0, 0));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

