/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.ma2.SequenceIterator;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.iosp.BitReader;
import ucar.nc2.iosp.bufr.BitCounterCompressed;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.DataDescriptorTreeConstructor;
import ucar.nc2.iosp.bufr.DebugOut;
import ucar.nc2.iosp.bufr.Message;
import ucar.unidata.io.RandomAccessFile;

public class MessageCompressedDataReader {
    public ArrayStructure readEntireMessage(Structure s, Message proto, Message m, RandomAccessFile raf, Formatter f) throws IOException {
        DataDescriptor.transferInfo(proto.getRootDataDescriptor().getSubKeys(), m.getRootDataDescriptor().getSubKeys());
        int n = m.getNumberDatasets();
        ArrayStructureMA ama = ArrayStructureMA.factoryMA((Structure)s, (int[])new int[]{n});
        MessageCompressedDataReader.setIterators(ama);
        HashMap<DataDescriptor, StructureMembers.Member> map = new HashMap<DataDescriptor, StructureMembers.Member>(100);
        this.associateMessage2Members(ama.getStructureMembers(), m.getRootDataDescriptor(), map);
        this.readData(m, raf, f, new Request(ama, map, null));
        return ama;
    }

    public void readData(ArrayStructureMA ama, Message m, RandomAccessFile raf, Range r, Formatter f) throws IOException {
        HashMap<DataDescriptor, StructureMembers.Member> map = null;
        if (ama != null) {
            map = new HashMap<DataDescriptor, StructureMembers.Member>(2 * ama.getMembers().size());
            this.associateMessage2Members(ama.getStructureMembers(), m.getRootDataDescriptor(), map);
        }
        this.readData(m, raf, f, new Request(ama, map, r));
    }

    public static void setIterators(ArrayStructureMA ama) {
        StructureMembers sms = ama.getStructureMembers();
        for (StructureMembers.Member sm : sms.getMembers()) {
            Array data = sm.getDataArray();
            if (data instanceof ArrayStructureMA) {
                MessageCompressedDataReader.setIterators((ArrayStructureMA)data);
                continue;
            }
            int[] shape = data.getShape();
            if (shape.length > 1 && sm.getDataType() != DataType.CHAR) {
                Array datap;
                if (shape.length == 2) {
                    datap = data.transpose(0, 1);
                } else {
                    int[] pdims = new int[shape.length];
                    for (int i = 0; i < shape.length - 1; ++i) {
                        pdims[i] = i + 1;
                    }
                    datap = data.permute(pdims);
                }
                sm.setDataObject((Object)datap.getIndexIterator());
                continue;
            }
            sm.setDataObject((Object)data.getIndexIterator());
        }
    }

    private void associateMessage2Members(StructureMembers members, DataDescriptor parent, HashMap<DataDescriptor, StructureMembers.Member> map) {
        for (DataDescriptor dkey : parent.getSubKeys()) {
            if (dkey.name == null) {
                if (dkey.getSubKeys() == null) continue;
                this.associateMessage2Members(members, dkey, map);
                continue;
            }
            StructureMembers.Member m = members.findMember(dkey.name);
            if (m != null) {
                map.put(dkey, m);
                if (m.getDataType() != DataType.STRUCTURE) continue;
                ArrayStructure nested = (ArrayStructure)m.getDataArray();
                if (dkey.getSubKeys() == null) continue;
                this.associateMessage2Members(nested.getStructureMembers(), dkey, map);
                continue;
            }
            if (dkey.getSubKeys() == null) continue;
            this.associateMessage2Members(members, dkey, map);
        }
    }

    private int readData(Message m, RandomAccessFile raf, Formatter f, Request req) throws IOException {
        BitReader reader = new BitReader(raf, m.dataSection.getDataPos() + 4L);
        DataDescriptor root = m.getRootDataDescriptor();
        if (root.isBad) {
            return 0;
        }
        DebugOut out = f == null ? null : new DebugOut(f);
        BitCounterCompressed[] counterFlds = new BitCounterCompressed[root.subKeys.size()];
        this.readData(out, reader, counterFlds, root, 0, m.getNumberDatasets(), req);
        m.msg_nbits = 0;
        for (BitCounterCompressed counter : counterFlds) {
            if (counter == null) continue;
            m.msg_nbits += counter.getTotalBits();
        }
        return m.msg_nbits;
    }

    private int readData(DebugOut out, BitReader reader, BitCounterCompressed[] fldCounters, DataDescriptor parent, int bitOffset, int ndatasets, Request req) throws IOException {
        List<DataDescriptor> flds = parent.getSubKeys();
        for (int fldidx = 0; fldidx < flds.size(); ++fldidx) {
            StructureMembers.Member member;
            BitCounterCompressed counter;
            DataDescriptor dkey = flds.get(fldidx);
            if (!dkey.isOkForVariable()) {
                if (dkey.f == 2 && dkey.x == 36) {
                    req.dpiTracker = new DpiTracker(dkey.dpi, dkey.dpi.getNfields());
                }
                if (out == null) continue;
                out.f.format("%s %d %s (%s) %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName());
                continue;
            }
            fldCounters[fldidx] = counter = new BitCounterCompressed(dkey, ndatasets, bitOffset);
            if (dkey.replication == 0) {
                reader.setBitOffset(bitOffset);
                int count = (int)reader.bits2UInt(dkey.replicationCountSize);
                bitOffset += dkey.replicationCountSize;
                reader.bits2UInt(6);
                if (null != out) {
                    out.f.format("%s--sequence %s bitOffset=%d replication=%s %n", out.indent(), dkey.getFxyName(), bitOffset, count);
                }
                bitOffset += 6;
                counter.addNestedCounters(count);
                bitOffset = this.makeArraySequenceCompressed(out, reader, counter, dkey, bitOffset, ndatasets, count, req);
                continue;
            }
            if (dkey.type == 3) {
                if (null != out) {
                    out.f.format("%s--structure %s bitOffset=%d replication=%s %n", out.indent(), dkey.getFxyName(), bitOffset, dkey.replication);
                }
                counter.addNestedCounters(dkey.replication);
                for (int i = 0; i < dkey.replication; ++i) {
                    BitCounterCompressed[] nested = counter.getNestedCounters(i);
                    req.outerRow = i;
                    if (null != out) {
                        out.f.format("%n", new Object[0]);
                        out.indent.incr();
                        bitOffset = this.readData(out, reader, nested, dkey, bitOffset, ndatasets, req);
                        out.indent.decr();
                        continue;
                    }
                    bitOffset = this.readData(null, reader, nested, dkey, bitOffset, ndatasets, req);
                }
                continue;
            }
            IndexIterator iter = null;
            ArrayStructure dataDpi = null;
            if (req.map != null && (iter = (IndexIterator)(member = req.map.get(dkey)).getDataObject()) == null) {
                dataDpi = (ArrayStructure)member.getDataArray();
            }
            reader.setBitOffset(bitOffset);
            if (dkey.type == 1) {
                int nc = dkey.bitWidth / 8;
                byte[] minValue = new byte[nc];
                for (int i = 0; i < nc; ++i) {
                    minValue[i] = (byte)reader.bits2UInt(8);
                }
                int dataWidth = (int)reader.bits2UInt(6);
                counter.setDataWidth(8 * dataWidth);
                int totalWidth = dkey.bitWidth + 6 + 8 * dataWidth * ndatasets;
                bitOffset += totalWidth;
                if (null != out) {
                    out.f.format("%s read %d %s (%s) bitWidth=%d defValue=%s dataWidth=%d n=%d bitOffset=%d %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName(), dkey.bitWidth, new String(minValue, StandardCharsets.UTF_8), dataWidth, ndatasets, bitOffset);
                }
                if (iter != null) {
                    for (int dataset = 0; dataset < ndatasets; ++dataset) {
                        int i;
                        if (dataWidth == 0) {
                            if (!req.wantRow(dataset)) continue;
                            for (int i2 = 0; i2 < nc; ++i2) {
                                iter.setCharNext((char)minValue[i2]);
                            }
                            continue;
                        }
                        int nt = Math.min(nc, dataWidth);
                        byte[] incValue = new byte[nc];
                        for (i = 0; i < nt; ++i) {
                            incValue[i] = (byte)reader.bits2UInt(8);
                        }
                        for (i = nt; i < nc; ++i) {
                            incValue[i] = 0;
                        }
                        if (req.wantRow(dataset)) {
                            for (i = 0; i < nc; ++i) {
                                byte cval = incValue[i];
                                if (cval < 32 || cval > 126) {
                                    cval = 0;
                                }
                                iter.setCharNext((char)cval);
                            }
                        }
                        if (out == null) continue;
                        out.f.format(" %s,", new String(incValue, StandardCharsets.UTF_8));
                    }
                }
                if (out == null) continue;
                out.f.format("%n", new Object[0]);
                continue;
            }
            int useBitWidth = dkey.bitWidth;
            boolean isDpi = dkey.f == 0 && dkey.x == 31 && dkey.y == 31;
            boolean isDpiField = false;
            if (dkey.f == 2 && dkey.x == 24 && dkey.y == 255) {
                isDpiField = true;
                DataDescriptor dpiDD = req.dpiTracker.getDpiDD(req.outerRow);
                useBitWidth = dpiDD.bitWidth;
            }
            long dataMin = reader.bits2UInt(useBitWidth);
            int dataWidth = (int)reader.bits2UInt(6);
            if (dataWidth > useBitWidth && null != out) {
                out.f.format(" BAD WIDTH ", new Object[0]);
            }
            if (dkey.type == 1) {
                dataWidth *= 8;
            }
            counter.setDataWidth(dataWidth);
            int totalWidth = useBitWidth + 6 + dataWidth * ndatasets;
            bitOffset += totalWidth;
            if (null != out) {
                out.f.format("%s read %d, %s (%s) bitWidth=%d dataMin=%d (%f) dataWidth=%d n=%d bitOffset=%d %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName(), useBitWidth, dataMin, Float.valueOf(dkey.convert(dataMin)), dataWidth, ndatasets, bitOffset);
            }
            for (int dataset = 0; dataset < ndatasets; ++dataset) {
                long missingVal;
                long value = dataMin;
                if (dataWidth > 0) {
                    long cv = reader.bits2UInt(dataWidth);
                    value = BufrNumbers.isMissing(cv, dataWidth) ? BufrNumbers.missingValue(useBitWidth) : (value += cv);
                }
                if (dataWidth > useBitWidth && (value & (missingVal = BufrNumbers.missingValue(useBitWidth))) != value) {
                    value = missingVal;
                }
                if (req.wantRow(dataset)) {
                    if (isDpiField) {
                        if (dataDpi != null) {
                            DataDescriptor dpiDD = req.dpiTracker.getDpiDD(req.outerRow);
                            StructureMembers sms = dataDpi.getStructureMembers();
                            StructureMembers.Member m0 = sms.getMember(0);
                            IndexIterator iter2 = (IndexIterator)m0.getDataObject();
                            iter2.setObjectNext((Object)dpiDD.getName());
                            StructureMembers.Member m1 = sms.getMember(1);
                            iter2 = (IndexIterator)m1.getDataObject();
                            iter2.setFloatNext(dpiDD.convert(value));
                        }
                    } else if (iter != null) {
                        iter.setLongNext(value);
                    }
                }
                if (isDpi && dataset == 0) {
                    req.dpiTracker.setDpiValue(req.outerRow, value);
                }
                if (out == null || dataWidth <= 0) continue;
                out.f.format(" %d (%f)", value, Float.valueOf(dkey.convert(value)));
            }
            if (out == null) continue;
            out.f.format("%n", new Object[0]);
        }
        return bitOffset;
    }

    private int makeArraySequenceCompressed(DebugOut out, BitReader reader, BitCounterCompressed bitCounterNested, DataDescriptor seqdd, int bitOffset, int ndatasets, int count, Request req) throws IOException {
        ArrayStructureMA ama = null;
        StructureMembers members = null;
        HashMap<DataDescriptor, StructureMembers.Member> nmap = null;
        if (req.map != null) {
            Sequence seq = seqdd.refersTo;
            int[] shape = new int[]{ndatasets, count};
            ama = ArrayStructureMA.factoryMA((Structure)seq, (int[])shape);
            MessageCompressedDataReader.setIterators(ama);
            members = ama.getStructureMembers();
            nmap = new HashMap<DataDescriptor, StructureMembers.Member>(2 * members.getMembers().size());
            this.associateMessage2Members(members, seqdd, nmap);
        }
        Request nreq = new Request(ama, nmap, req.r);
        if (out != null) {
            out.indent.incr();
        }
        int i = 0;
        while (i < count) {
            BitCounterCompressed[] nested = bitCounterNested.getNestedCounters(i);
            nreq.outerRow = i++;
            bitOffset = this.readData(out, reader, nested, seqdd, bitOffset, ndatasets, nreq);
        }
        if (out != null) {
            out.indent.decr();
        }
        if (req.map != null) {
            StructureMembers.Member m = req.map.get(seqdd);
            ArrayObject arrObj = (ArrayObject)m.getDataArray();
            int start = 0;
            for (int i2 = 0; i2 < ndatasets; ++i2) {
                ArraySequence arrSeq = new ArraySequence(members, (StructureDataIterator)new SequenceIterator(start, count, (ArrayStructure)ama), count);
                arrObj.setObject(i2, (Object)arrSeq);
                start += count;
            }
        }
        return bitOffset;
    }

    private static class DpiTracker {
        DataDescriptorTreeConstructor.DataPresentIndicator dpi;
        boolean[] isPresent;
        List<DataDescriptor> dpiDD;

        DpiTracker(DataDescriptorTreeConstructor.DataPresentIndicator dpi, int nPresentFlags) {
            this.dpi = dpi;
            this.isPresent = new boolean[nPresentFlags];
        }

        void setDpiValue(int fldidx, long value) {
            this.isPresent[fldidx] = value == 0L;
        }

        DataDescriptor getDpiDD(int fldPresentIndex) {
            if (this.dpiDD == null) {
                this.dpiDD = new ArrayList<DataDescriptor>();
                for (int i = 0; i < this.isPresent.length; ++i) {
                    if (!this.isPresent[i]) continue;
                    this.dpiDD.add(this.dpi.linear.get(i));
                }
            }
            return this.dpiDD.get(fldPresentIndex);
        }

        boolean isDpiDDs(DataDescriptor dkey) {
            return dkey.f == 2 && dkey.x == 24 && dkey.y == 255;
        }

        boolean isDpiField(DataDescriptor dkey) {
            return dkey.f == 2 && dkey.x == 24 && dkey.y == 255;
        }
    }

    private static class Request {
        ArrayStructureMA ama;
        HashMap<DataDescriptor, StructureMembers.Member> map;
        Range r;
        DpiTracker dpiTracker;
        int outerRow;

        Request(ArrayStructureMA ama, HashMap<DataDescriptor, StructureMembers.Member> map, Range r) {
            this.ama = ama;
            this.map = map;
            this.r = r;
        }

        boolean wantRow(int row) {
            if (this.ama == null) {
                return false;
            }
            if (this.r == null) {
                return true;
            }
            return this.r.contains(row);
        }
    }
}

