/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.gui;

import com.cburch.contracts.BaseDocumentListenerContract;
import com.cburch.draw.toolbar.ToolbarModel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.FileUtil;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.base.HdlModelListener;
import com.cburch.logisim.vhdl.file.HdlFile;
import com.cburch.logisim.vhdl.gui.HdlToolbarModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class HdlContentView
extends JPanel
implements BaseDocumentListenerContract,
HdlModelListener {
    private static final long serialVersionUID = 1L;
    private static final int ROWS = 40;
    private static final int COLUMNS = 100;
    private static final String EXPORT_DIR = "hdl_export";
    private RSyntaxTextArea editor;
    private HdlModel model;
    private final Project project;
    private final HdlToolbarModel toolbar;
    boolean dirty = false;

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.docChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.docChanged();
    }

    void docChanged() {
        if (this.model == null) {
            return;
        }
        this.model.setContentNoValidation(this.editor.getText());
        if (this.dirty || this.model == null) {
            return;
        }
        this.toolbar.setDirty(true);
        this.project.doAction(new HdlEditAction(this.model, this.model.getContent()));
        this.dirty = true;
    }

    void doExport() {
        JFileChooser chooser = JFileChoosers.createSelected(this.getDefaultExportFile(null));
        chooser.setDialogTitle(Strings.S.get("hdlSaveDialog"));
        int choice = chooser.showSaveDialog(this);
        if (choice == 0) {
            File f = chooser.getSelectedFile();
            try {
                HdlFile.save(f, this.editor.getText());
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(this, e.getMessage(), Strings.S.get("hexSaveErrorTitle"), 0);
            }
        }
    }

    void doImport() {
        if (!this.editor.getText().equals(this.model.getContent()) && !HdlContentView.confirmImport(this)) {
            return;
        }
        String vhdl = this.project.getLogisimFile().getLoader().vhdlImportChooser(this);
        if (vhdl != null) {
            this.setText(vhdl);
        }
    }

    void doValidate() {
        this.model.setContent(this.editor.getText());
        this.dirty = false;
        this.toolbar.setDirty(!this.model.isValid());
        if (!this.model.isValid()) {
            this.model.showErrors();
        }
    }

    public static boolean confirmImport(Component parent) {
        Object[] options = new String[]{Strings.S.get("importOption"), Strings.S.get("cancelOption")};
        return OptionPane.showOptionDialog(parent, Strings.S.get("importMessage"), Strings.S.get("importTitle"), 0, 3, null, options, options[0]) == 0;
    }

    public HdlContentView(Project proj) {
        super(new BorderLayout());
        this.project = proj;
        this.model = null;
        this.toolbar = new HdlToolbarModel(proj, this);
        this.configure("vhdl");
    }

    private void configure(String lang) {
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        this.editor = new RSyntaxTextArea(40, 100);
        if (lang.equals("vhdl")) {
            ((RSyntaxDocument)this.editor.getDocument()).setSyntaxStyle("text/vhdl");
        } else {
            this.editor.setSyntaxEditingStyle("text/delphi");
        }
        this.editor.setCodeFoldingEnabled(true);
        this.editor.setAntiAliasingEnabled(true);
        this.editor.getDocument().addDocumentListener(this);
        RTextScrollPane sp = new RTextScrollPane(this.editor);
        sp.setFoldIndicatorEnabled(true);
        this.add((Component)sp, "Center");
        this.add((Component)buttonsPanel, "North");
        Dimension size = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width || size.height > screen.height) {
            size.width = Math.min(size.width, screen.width);
            size.height = Math.min(size.height, screen.height);
            this.setSize(size);
        }
    }

    private File getDefaultExportFile(File defaultFile) {
        File projectFile = this.project.getLogisimFile().getLoader().getMainFile();
        if (projectFile == null) {
            if (defaultFile == null) {
                return new File(this.model.getName() + ".vhd");
            }
            return defaultFile;
        }
        try {
            File compFolder = new File(FileUtil.correctPath(projectFile.getParentFile().getCanonicalPath()) + EXPORT_DIR);
            if (!compFolder.exists() || compFolder.exists() && !compFolder.isDirectory()) {
                compFolder.mkdir();
            }
            return new File(FileUtil.correctPath(compFolder.getCanonicalPath()) + this.model.getName() + ".vhd");
        }
        catch (IOException ex) {
            return defaultFile;
        }
    }

    public HdlModel getHdlModel() {
        return this.model;
    }

    public ToolbarModel getToolbarModel() {
        return this.toolbar;
    }

    public void setText(String content) {
        this.dirty = true;
        this.editor.setText(content);
        this.editor.discardAllEdits();
        this.dirty = false;
        this.editor.setCaretPosition(0);
    }

    public void clearHdlModel() {
        if (this.model == null) {
            return;
        }
        if (!this.editor.getText().equals(this.model.getContent())) {
            this.model.setContent(this.editor.getText());
        }
        this.model.removeHdlModelListener(this.toolbar);
        this.model.removeHdlModelListener(this);
        this.model = null;
        this.setText("");
        this.dirty = false;
    }

    @Override
    public void contentSet(HdlModel source) {
        if (!this.editor.getText().equals(this.model.getContent())) {
            this.setText(this.model.getContent());
        }
        this.dirty = false;
    }

    @Override
    public void aboutToSave(HdlModel source) {
        if (this.model != source) {
            return;
        }
        if (!this.editor.getText().equals(this.model.getContent())) {
            this.model.setContent(this.editor.getText());
            this.dirty = false;
            this.toolbar.setDirty(!this.model.isValid());
        }
    }

    public void setHdlModel(HdlModel model) {
        if (this.model == model) {
            return;
        }
        this.clearHdlModel();
        this.model = model;
        if (this.model != null) {
            this.model.addHdlModelListener(this.toolbar);
            this.model.addHdlModelListener(this);
            this.setText(model.getContent());
            this.toolbar.setDirty(!model.isValid());
        }
    }

    private class HdlEditAction
    extends Action {
        final HdlModel model;
        final String original;

        HdlEditAction(HdlModel model, String original) {
            this.model = model;
            this.original = original;
        }

        @Override
        public void doIt(Project proj) {
        }

        @Override
        public String getName() {
            return "VHDL edits";
        }

        @Override
        public boolean isModification() {
            return true;
        }

        @Override
        public boolean shouldAppendTo(Action other) {
            return other instanceof HdlEditAction && ((HdlEditAction)other).model == this.model;
        }

        @Override
        public void undo(Project proj) {
            HdlContentView.this.setText(this.original);
            this.model.setContentNoValidation(this.original);
            HdlContentView.this.toolbar.setDirty(!this.model.isValid());
            HdlContentView.this.dirty = false;
            if (HdlContentView.this.model != this.model) {
                HdlContentView.this.setHdlModel(this.model);
            }
        }

        @Override
        public Action append(Action other) {
            return this;
        }
    }
}

