/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.base;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.std.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VhdlParser {
    private static final Pattern LIBRARY = VhdlParser.regex("library  \\w+ ;");
    private static final Pattern USING = VhdlParser.regex("use  \\S+ ;");
    private static final Pattern ENTITY = VhdlParser.regex("entity  (\\w+)  is");
    private static final Pattern END_KEYWORD = VhdlParser.regex("end  (\\w+) ;");
    private static final Pattern END_ENTITY = VhdlParser.regex("end entity  (\\w+) ;");
    private static final Pattern END = VhdlParser.regex("end;");
    private static final Pattern ARCHITECTURE = VhdlParser.regex("architecture .*");
    private static final Pattern SEMICOLON = VhdlParser.regex(";");
    private static final Pattern OPENLIST = VhdlParser.regex("[(]");
    private static final Pattern DONELIST = VhdlParser.regex("[)] ;");
    private static final Pattern PORTS = VhdlParser.regex("port");
    private static final Pattern PORT = VhdlParser.regex("(\\w+(?: , \\w+)*) : (\\w+)  (\\w+)");
    private static final Pattern RANGE = VhdlParser.regex("[(] (\\d+) downto (\\d+) [)]");
    private static final Pattern GENERICS = VhdlParser.regex("generic");
    private static final Pattern GENERIC = VhdlParser.regex("(\\w+(?: , \\w+)*) : (\\w+)");
    private static final Pattern DVALUE = VhdlParser.regex(":= (\\w+)");
    private final List<PortDescription> inputs;
    private final List<PortDescription> outputs;
    private final List<GenericDescription> generics;
    private final String source;
    private String name;
    private String libraries;
    private String architecture;

    private static Pattern regex(String pattern) {
        pattern = ((String)pattern).trim();
        pattern = "^ " + (String)pattern;
        pattern = ((String)pattern).replaceAll(" {2}", "\\\\s+");
        pattern = ((String)pattern).replaceAll(" ", "\\\\s*");
        return Pattern.compile((String)pattern, 34);
    }

    public VhdlParser(String source) {
        this.source = source;
        this.inputs = new ArrayList<PortDescription>();
        this.outputs = new ArrayList<PortDescription>();
        this.generics = new ArrayList<GenericDescription>();
    }

    public String getArchitecture() {
        return this.architecture;
    }

    private int getEOLIndex(String input, int from) {
        int index = input.indexOf("\n", from);
        if (index != -1) {
            return index;
        }
        index = input.indexOf("\r\n", from);
        if (index != -1) {
            return index;
        }
        index = input.indexOf("\r", from);
        if (index != -1) {
            return index;
        }
        return input.length();
    }

    public List<PortDescription> getInputs() {
        return this.inputs;
    }

    public List<PortDescription> getOutputs() {
        return this.outputs;
    }

    public List<GenericDescription> getGenerics() {
        return this.generics;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public String getName() {
        return this.name;
    }

    private String getPortType(String type) throws IllegalVhdlContentException {
        if ("in".equalsIgnoreCase(type)) {
            return "input";
        }
        if ("out".equalsIgnoreCase(type)) {
            return "output";
        }
        if ("input".equalsIgnoreCase(type)) {
            return "inout";
        }
        throw new IllegalVhdlContentException(Strings.S.get("invalidTypeException") + ": " + type);
    }

    public void parse() throws IllegalVhdlContentException {
        Scanner input = new Scanner(this.removeComments());
        this.parseLibraries(input);
        if (!input.next(ENTITY)) {
            throw new IllegalVhdlContentException(Strings.S.get("CannotFindEntityException"));
        }
        this.name = input.match().group(1);
        while (this.parsePorts(input) || this.parseGenerics(input)) {
        }
        boolean justEndForEntity = input.next(END);
        if (!input.next(END_KEYWORD) && !input.next(END_ENTITY) && !justEndForEntity || !justEndForEntity && !input.match().group(1).equals(this.name)) {
            throw new IllegalVhdlContentException(Strings.S.get("CannotFindEntityException"));
        }
        this.parseArchitecture(input);
        if (input.remaining().length() > 0) {
            throw new IllegalVhdlContentException(Strings.S.get("CannotFindEntityException"));
        }
    }

    private void parseArchitecture(Scanner input) {
        this.architecture = input.next(ARCHITECTURE) ? input.match().group() : "";
    }

    private void parseLibraries(Scanner input) {
        StringBuilder result = new StringBuilder();
        while (input.next(LIBRARY) || input.next(USING)) {
            result.append(input.match().group().trim().replaceAll("\\s+", " "));
            result.append(System.getProperty("line.separator"));
        }
        this.libraries = result.toString();
    }

    private void parsePort(Scanner input) throws IllegalVhdlContentException {
        if (!input.next(PORT)) {
            throw new IllegalVhdlContentException(Strings.S.get("portDeclarationException"));
        }
        String names = input.match().group(1).trim();
        String ptype = this.getPortType(input.match().group(2).trim());
        String type = input.match().group(3).trim();
        boolean isOneBit = type.equalsIgnoreCase("std_logic");
        boolean isBitVector = type.equalsIgnoreCase("std_logic_vector");
        if (!isOneBit && !isBitVector) {
            throw new IllegalVhdlContentException(Strings.S.get("portTypeException", type));
        }
        int width = 1;
        if (isBitVector) {
            if (!input.next(RANGE)) {
                throw new IllegalVhdlContentException(Strings.S.get("portDeclarationException"));
            }
            int upper = Integer.parseInt(input.match().group(1));
            int lower = Integer.parseInt(input.match().group(2));
            width = upper - lower + 1;
        }
        for (String name : names.split("\\s*,\\s*")) {
            if (ptype.equals("input")) {
                this.inputs.add(new PortDescription(name, ptype, width));
                continue;
            }
            this.outputs.add(new PortDescription(name, ptype, width));
        }
    }

    private boolean parsePorts(Scanner input) throws IllegalVhdlContentException {
        if (!input.next(PORTS)) {
            return false;
        }
        if (!input.next(OPENLIST)) {
            throw new IllegalVhdlContentException(Strings.S.get("portDeclarationException"));
        }
        this.parsePort(input);
        while (input.next(SEMICOLON)) {
            this.parsePort(input);
        }
        if (!input.next(DONELIST)) {
            throw new IllegalVhdlContentException(Strings.S.get("portDeclarationException"));
        }
        return true;
    }

    private void parseGeneric(Scanner input) throws IllegalVhdlContentException {
        if (!input.next(GENERIC)) {
            throw new IllegalVhdlContentException(Strings.S.get("genericDeclarationException"));
        }
        String names = input.match().group(1).trim();
        String type = input.match().group(2).trim();
        if (!(type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("natural") || type.equalsIgnoreCase("positive"))) {
            throw new IllegalVhdlContentException(Strings.S.get("genericTypeException") + ": " + type);
        }
        type = type.toLowerCase();
        int dval = 0;
        if (type.equals("positive")) {
            dval = 1;
        }
        if (input.next(DVALUE)) {
            String s = input.match().group(1);
            try {
                dval = Integer.decode(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalVhdlContentException(Strings.S.get("genericValueException") + ": " + s);
            }
            if (type.equals("natural") && dval < 0 || type.equals("positive") && dval < 1) {
                throw new IllegalVhdlContentException(Strings.S.get("genericValueException") + ": " + dval);
            }
        }
        for (String name : names.split("\\s*,\\s*")) {
            this.generics.add(new GenericDescription(name, type, dval));
        }
    }

    private boolean parseGenerics(Scanner input) throws IllegalVhdlContentException {
        if (!input.next(GENERICS)) {
            return false;
        }
        if (!input.next(OPENLIST)) {
            throw new IllegalVhdlContentException(Strings.S.get("genericDeclarationException"));
        }
        this.parseGeneric(input);
        while (input.next(SEMICOLON)) {
            this.parseGeneric(input);
        }
        if (!input.next(DONELIST)) {
            throw new IllegalVhdlContentException(Strings.S.get("genericDeclarationException"));
        }
        return true;
    }

    private String removeComments() throws IllegalVhdlContentException {
        int from;
        StringBuilder input;
        try {
            input = new StringBuilder(this.source);
        }
        catch (NullPointerException ex) {
            throw new IllegalVhdlContentException(Strings.S.get("emptySourceException"));
        }
        while ((from = input.indexOf("--")) != -1) {
            int to = this.getEOLIndex(input.toString(), from);
            input.delete(from, to);
        }
        return input.toString().trim();
    }

    public static class IllegalVhdlContentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalVhdlContentException() {
        }

        public IllegalVhdlContentException(String message) {
            super(message);
        }

        public IllegalVhdlContentException(String message, Throwable cause) {
            super(message, cause);
        }

        public IllegalVhdlContentException(Throwable cause) {
            super(cause);
        }
    }

    private static class Scanner {
        String input;
        MatchResult m;

        Scanner(String input) {
            this.input = input;
        }

        boolean next(Pattern pat) {
            this.m = null;
            Matcher match = pat.matcher(this.input);
            if (!match.lookingAt()) {
                return false;
            }
            this.m = match;
            this.input = match.hitEnd() ? "" : this.input.substring(this.m.end());
            return true;
        }

        MatchResult match() {
            return this.m;
        }

        String remaining() {
            return this.input;
        }
    }

    public static class PortDescription {
        private final String name;
        private final String type;
        private final BitWidth width;

        public PortDescription(String name, String type, int width) {
            this.name = name;
            this.type = type;
            this.width = BitWidth.create(width);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getVhdlType() {
            return switch (this.type) {
                case "input" -> "in";
                case "output" -> "out";
                case "inout" -> "inout";
                default -> throw new IllegalArgumentException("Not recognized port type: " + this.type);
            };
        }

        public BitWidth getWidth() {
            return this.width;
        }
    }

    public static class GenericDescription {
        protected final String name;
        protected final String type;
        protected final int dval;

        public GenericDescription(String name, String type, int dval) {
            this.name = name;
            this.type = type;
            this.dval = dval;
        }

        public GenericDescription(String name, String type) {
            this.name = name;
            this.type = type;
            this.dval = type.equals("positive") ? 1 : 0;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getDefaultValue() {
            return this.dval;
        }
    }
}

