/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.base;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.vhdl.Strings;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.base.HdlModelListener;
import com.cburch.logisim.vhdl.base.VhdlAppearance;
import com.cburch.logisim.vhdl.base.VhdlContent;
import com.cburch.logisim.vhdl.base.VhdlEntityAttributes;
import com.cburch.logisim.vhdl.base.VhdlHdlGeneratorFactory;
import com.cburch.logisim.vhdl.base.VhdlParser;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlEntity
extends InstanceFactory
implements HdlModelListener {
    static final Logger logger = LoggerFactory.getLogger(VhdlEntity.class);
    static final Attribute<String> nameAttr = Attributes.forString("vhdlEntity", Strings.S.getter("vhdlEntityName"));
    static final ArithmeticIcon icon = new ArithmeticIcon("VHDL");
    static final int WIDTH = 140;
    static final int HEIGHT = 40;
    static final int PORT_GAP = 10;
    static final int X_PADDING = 5;
    private final VhdlContent content;
    private final ArrayList<Instance> myInstances;
    private VhdlAppearance appearance;
    private final WeakHashMap<Component, Circuit> circuitsUsingThis = new WeakHashMap();

    public VhdlEntity(VhdlContent content) {
        super("", null, new VhdlHdlGeneratorFactory(), true);
        this.content = content;
        this.content.addHdlModelListener(this);
        this.setIcon(icon);
        icon.setInvalid(!content.isValid());
        this.setFacingAttribute(StdAttr.FACING);
        this.appearance = VhdlAppearance.create(this.getPins(), this.getName(), StdAttr.APPEAR_EVOLUTION);
        this.myInstances = new ArrayList();
    }

    public void setSimName(AttributeSet attrs, String sName) {
        String label;
        if (attrs == null) {
            return;
        }
        VhdlEntityAttributes atrs = (VhdlEntityAttributes)attrs;
        String string = label = "".equals(attrs.getValue(StdAttr.LABEL)) ? sName : this.getHDLTopName(attrs);
        if (atrs.containsAttribute(VhdlSimConstants.SIM_NAME_ATTR)) {
            atrs.setValue(VhdlSimConstants.SIM_NAME_ATTR, label);
        }
    }

    public String getSimName(AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        VhdlEntityAttributes atrs = (VhdlEntityAttributes)attrs;
        return atrs.getValue(VhdlSimConstants.SIM_NAME_ATTR);
    }

    @Override
    public String getName() {
        if (this.content == null) {
            return "VHDL Entity";
        }
        return this.content.getName();
    }

    @Override
    public StringGetter getDisplayGetter() {
        if (this.content == null) {
            return Strings.S.getter("vhdlComponent");
        }
        return StringUtil.constantGetter(this.content.getName());
    }

    public VhdlContent getContent() {
        return this.content;
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        VhdlEntityAttributes attrs = (VhdlEntityAttributes)instance.getAttributeSet();
        attrs.setInstance(instance);
        instance.addAttributeListener();
        this.updatePorts(instance);
        if (!this.myInstances.contains(instance)) {
            this.myInstances.add(instance);
        }
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new VhdlEntityAttributes(this.content);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return this.content.getName().toLowerCase();
    }

    @Override
    public String getHDLTopName(AttributeSet attrs) {
        Object label = "";
        String l = attrs.getValue(StdAttr.LABEL);
        if (!"".equals(l)) {
            label = "_" + l.toLowerCase();
        }
        return this.getHDLName(attrs) + (String)label;
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        if (this.appearance == null) {
            return Bounds.create(0, 0, 100, 100);
        }
        Direction facing = attrs.getValue(StdAttr.FACING);
        return this.appearance.getOffsetBounds().rotate(Direction.EAST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            this.updatePorts(instance);
        } else if (attr == StdAttr.APPEARANCE) {
            for (Instance j : this.myInstances) {
                this.updatePorts(j);
            }
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        VhdlEntityAttributes attrs = (VhdlEntityAttributes)painter.getAttributeSet();
        Direction facing = attrs.getFacing();
        Graphics gfx = painter.getGraphics();
        Location loc = painter.getLocation();
        gfx.translate(loc.getX(), loc.getY());
        this.appearance.paintSubcircuit(painter, gfx, facing);
        gfx.translate(-loc.getX(), -loc.getY());
        String label = painter.getAttributeValue(StdAttr.LABEL);
        if (label != null && painter.getAttributeValue(StdAttr.LABEL_VISIBILITY).booleanValue()) {
            Bounds bds = painter.getBounds();
            Font oldFont = gfx.getFont();
            Color color = gfx.getColor();
            gfx.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
            gfx.setColor(StdAttr.DEFAULT_LABEL_COLOR);
            GraphicsUtil.drawCenteredText(gfx, label, bds.getX() + bds.getWidth() / 2, bds.getY() - gfx.getFont().getSize());
            gfx.setFont(oldFont);
            gfx.setColor(color);
        }
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        if (state.getProject().getVhdlSimulator().isEnabled() && state.getProject().getVhdlSimulator().isRunning()) {
            String serverResponse;
            VhdlSimulatorTop vhdlSimulator = state.getProject().getVhdlSimulator();
            for (Port singlePort : state.getInstance().getPorts()) {
                int index = state.getPortIndex(singlePort);
                Value val = state.getPortValue(index);
                String vhdlEntityName = this.getSimName(state.getAttributeSet());
                String message = singlePort.getType() + ":" + vhdlEntityName + "_" + singlePort.getToolTip() + ":" + val.toBinaryString() + ":" + index;
                vhdlSimulator.send(message);
            }
            vhdlSimulator.send("sync");
            while ((serverResponse = vhdlSimulator.receive()) != null && serverResponse.length() > 0 && !"sync".equals(serverResponse)) {
                String[] parameters = serverResponse.split(":");
                String busValue = parameters[1];
                Value[] vectorValues = new Value[busValue.length()];
                int idx = busValue.length() - 1;
                for (char bit : busValue.toCharArray()) {
                    try {
                        vectorValues[idx] = switch (Character.getNumericValue(bit)) {
                            case 0 -> Value.FALSE;
                            case 1 -> Value.TRUE;
                            default -> Value.UNKNOWN;
                        };
                    }
                    catch (NumberFormatException e) {
                        vectorValues[idx] = Value.UNKNOWN;
                    }
                    --idx;
                }
                state.setPort(Integer.parseInt(parameters[2]), Value.create(vectorValues), 1);
            }
        } else {
            for (Port port : state.getInstance().getPorts()) {
                int index = state.getPortIndex(port);
                if (port.getType() != 2) continue;
                Value[] vectorValues = new Value[port.getFixedBitWidth().getWidth()];
                for (int k = 0; k < port.getFixedBitWidth().getWidth(); ++k) {
                    vectorValues[k] = Value.UNKNOWN;
                }
                state.setPort(index, Value.create(vectorValues), 1);
            }
            throw new UnsupportedOperationException("VHDL component simulation is not supported. This could be because there is no Questasim/Modelsim simulation server running.");
        }
    }

    public void saveFile(AttributeSet attrs) {
        try {
            PrintWriter writer = new PrintWriter(VhdlSimConstants.SIM_SRC_PATH + this.getSimName(attrs) + ".vhdl", StandardCharsets.UTF_8);
            String content = this.content.getContent();
            content = content.replaceAll("(?i)" + this.getHDLName(attrs), this.getSimName(attrs));
            writer.print(content);
            writer.close();
        }
        catch (IOException e) {
            logger.error("Could not create VHDL file: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private ArrayList<Instance> getPins() {
        ArrayList<Instance> pins = new ArrayList<Instance>();
        int yPos = 0;
        for (VhdlParser.PortDescription port : this.content.getPorts()) {
            AttributeSet attr = Pin.FACTORY.createAttributeSet();
            attr.setValue(StdAttr.LABEL, port.getName());
            attr.setValue(Pin.ATTR_TYPE, port.getType() == "input" ? Pin.INPUT : Pin.OUTPUT);
            attr.setValue(StdAttr.FACING, port.getType() == "input" ? Direction.EAST : Direction.WEST);
            attr.setValue(StdAttr.WIDTH, port.getWidth());
            InstanceComponent component = (InstanceComponent)Pin.FACTORY.createComponent(Location.create(100, yPos, true), attr);
            pins.add(component.getInstance());
            yPos += 10;
        }
        return pins;
    }

    void updatePorts(Instance instance) {
        AttributeOption style = instance.getAttributeValue(StdAttr.APPEARANCE);
        this.appearance = VhdlAppearance.create(this.getPins(), this.getName(), style);
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        SortedMap<Location, Instance> portLocs = this.appearance.getPortOffsets(facing);
        Port[] ports = new Port[portLocs.size()];
        int idx = 0;
        for (Map.Entry<Location, Instance> portLoc : portLocs.entrySet()) {
            Location loc = portLoc.getKey();
            Instance pin = portLoc.getValue();
            String type = Pin.FACTORY.isInputPin(pin) ? "input" : "output";
            BitWidth width = pin.getAttributeValue(StdAttr.WIDTH);
            ports[idx] = new Port(loc.getX(), loc.getY(), type, width);
            String label = pin.getAttributeValue(StdAttr.LABEL);
            if (label != null && label.length() > 0) {
                ports[idx].setToolTip(StringUtil.constantGetter(label));
            }
            ++idx;
        }
        instance.setPorts(ports);
        instance.recomputeBounds();
    }

    @Override
    public void contentSet(HdlModel source) {
        icon.setInvalid(!this.content.isValid());
    }

    public Collection<Circuit> getCircuitsUsingThis() {
        return this.circuitsUsingThis.values();
    }

    public void addCircuitUsing(Component comp, Circuit circ) {
        this.circuitsUsingThis.put(comp, circ);
    }

    public void removeCircuitUsing(Component comp) {
        this.circuitsUsingThis.remove(comp);
    }

    @Override
    public void removeComponent(Circuit circ, Component c, CircuitState state) {
        this.removeCircuitUsing(c);
    }
}

