/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.FileUtil;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.util.Strings;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;

public final class Softwares {
    public static final String QUESTA = "questaSim";
    public static final String[] QUESTA_BIN = Softwares.loadQuesta();
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int ABORT = 2;
    public static final int VCOM = 0;
    public static final int VSIM = 1;
    public static final int VMAP = 2;
    public static final int VLIB = 3;

    private Softwares() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createWorkLibrary(File tmpDir, String questaPath, StringBuilder result) throws IOException, InterruptedException {
        BufferedReader reader = null;
        if (new File(FileUtil.correctPath(tmpDir.getCanonicalPath()) + "work").exists()) {
            return true;
        }
        try {
            String line;
            ArrayList<String> command = new ArrayList<String>();
            command.add(FileUtil.correctPath(questaPath) + QUESTA_BIN[3]);
            command.add("work");
            ProcessBuilder vlibBuilder = new ProcessBuilder(command);
            vlibBuilder.directory(tmpDir);
            Process vlib = vlibBuilder.start();
            InputStream is = vlib.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append(System.getProperty("line.separator"));
            }
            boolean bl = vlib.waitFor() == 0;
            return bl;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Softwares.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static String getQuestaPath() {
        return Softwares.getQuestaPath(null);
    }

    public static String getQuestaPath(Component parent) {
        String prefPath = AppPreferences.QUESTA_PATH.get();
        if (!Softwares.validatePath(prefPath, QUESTA) && (prefPath = Softwares.setQuestaPath()) == null) {
            return null;
        }
        return prefPath;
    }

    private static String[] loadQuesta() {
        String[] questaProgs = new String[]{"vcom", "vsim", "vmap", "vlib"};
        String osname = System.getProperty("os.name");
        if (osname == null) {
            throw new IllegalArgumentException("no os.name");
        }
        if (osname.toLowerCase().contains("windows")) {
            int i = 0;
            while (i < questaProgs.length) {
                int n = i++;
                questaProgs[n] = questaProgs[n] + ".exe";
            }
        }
        return questaProgs;
    }

    public static String setQuestaPath() {
        return Softwares.setQuestaPath(null);
    }

    public static String setQuestaPath(Component parent) {
        String path = null;
        JFileChooser chooser = JFileChoosers.create();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(Strings.S.get("questaDialogTitle"));
        chooser.setApproveButtonText(Strings.S.get("questaDialogButton"));
        int action = chooser.showOpenDialog(parent);
        if (action == 0) {
            File file = chooser.getSelectedFile();
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException ex) {
                OptionPane.showMessageDialog(parent, Strings.S.get("questaIoErrorMessage"), Strings.S.get("questaErrorTitle"), 0);
                return null;
            }
            if (Softwares.validatePath(path, QUESTA)) {
                AppPreferences.QUESTA_PATH.set(path);
            } else {
                OptionPane.showMessageDialog(parent, Strings.S.get("questaErrorMessage"), Strings.S.get("questaErrorTitle"), 0);
                return null;
            }
        }
        return path;
    }

    private static boolean validatePath(String path, String software) {
        if (!software.equals(QUESTA)) {
            return false;
        }
        String[] programs = QUESTA_BIN;
        for (String program : programs) {
            File test = new File(FileUtil.correctPath(path) + program);
            if (test.exists()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int validateVhdl(String vhdl, StringBuilder title, StringBuilder result) {
        if (!AppPreferences.QUESTA_VALIDATION.get().booleanValue()) {
            return 0;
        }
        String questaPath = Softwares.getQuestaPath();
        if (questaPath == null) {
            result.append(Strings.S.get("questaValidationAbordedMessage"));
            title.append(Strings.S.get("questaValidationAbordedTitle"));
            return 2;
        }
        BufferedReader reader = null;
        File tmp = null;
        try {
            String line;
            tmp = FileUtil.createTmpFile(vhdl, "tmp", ".vhd");
            File tmpDir = new File(tmp.getParentFile().getCanonicalPath());
            if (!Softwares.createWorkLibrary(tmpDir, questaPath, result)) {
                title.insert(0, Strings.S.get("questaLibraryErrorTitle"));
                result.insert(0, System.getProperty("line.separator"));
                result.insert(0, Strings.S.get("questaLibraryErrorMessage"));
                int n = 1;
                return n;
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(FileUtil.correctPath(questaPath) + QUESTA_BIN[0]);
            command.add("-reportprogress");
            command.add("300");
            command.add("-93");
            command.add("-work");
            command.add("work");
            command.add(tmp.getName());
            ProcessBuilder questa = new ProcessBuilder(command);
            questa.directory(tmpDir);
            Process vcom = questa.start();
            InputStream is = vcom.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append(System.getProperty("line.separator"));
            }
            if (vcom.waitFor() != 0) {
                title.insert(0, Strings.S.get("questaValidationFailedTitle"));
                result.insert(0, System.getProperty("line.separator"));
                result.insert(0, Strings.S.get("questaValidationFailedMessage"));
                int n = 1;
                return n;
            }
        }
        catch (IOException e) {
            title.insert(0, Strings.S.get("questaValidationFailedTitle"));
            result.replace(0, result.length(), e.getMessage());
            result.insert(0, System.getProperty("line.separator"));
            result.insert(0, Strings.S.get("questaValidationIoException"));
            int n = 1;
            return n;
        }
        catch (InterruptedException e) {
            title.insert(0, Strings.S.get("questaValidationFailedTitle"));
            result.replace(0, result.length(), e.getMessage());
            result.insert(0, System.getProperty("line.separator"));
            result.insert(0, Strings.S.get("questaValidationInterrupted"));
            int n = 1;
            return n;
        }
        finally {
            try {
                if (tmp != null) {
                    tmp.deleteOnExit();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Softwares.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return 0;
    }
}

