/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.Strings;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ProgressMonitor;

public class GifEncoder {
    private final short width;
    private final short height;
    private int numColors;
    private byte[] pixels;
    private byte[] colors;

    public static void toFile(Image img, File file) throws IOException, AWTException {
        GifEncoder.toFile(img, file, null);
    }

    public static void toFile(Image img, File file, ProgressMonitor monitor) throws IOException, AWTException {
        FileOutputStream out = new FileOutputStream(file);
        new GifEncoder(img, monitor).write(out);
        out.close();
    }

    public static void toFile(Image img, String filename) throws IOException, AWTException {
        GifEncoder.toFile(img, filename, null);
    }

    public static void toFile(Image img, String filename, ProgressMonitor monitor) throws IOException, AWTException {
        FileOutputStream out = new FileOutputStream(filename);
        new GifEncoder(img, monitor).write(out);
        out.close();
    }

    public GifEncoder(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.width = (short)r.length;
        this.height = (short)r[0].length;
        this.toIndexedColor(r, g, b);
    }

    public GifEncoder(Image image, ProgressMonitor monitor) throws AWTException {
        this.width = (short)image.getWidth(null);
        this.height = (short)image.getHeight(null);
        int[] values = new int[this.width * this.height];
        PixelGrabber grabber = monitor != null ? new MyGrabber(monitor, image, 0, 0, this.width, this.height, values, 0, this.width) : new PixelGrabber(image, 0, 0, (int)this.width, (int)this.height, values, 0, (int)this.width);
        try {
            if (!grabber.grabPixels()) {
                throw new AWTException(Strings.S.get("grabberError") + ": " + grabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[][] r = new byte[this.width][this.height];
        byte[][] g = new byte[this.width][this.height];
        byte[][] b = new byte[this.width][this.height];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                r[x][y] = (byte)(values[index] >> 16 & 0xFF);
                g[x][y] = (byte)(values[index] >> 8 & 0xFF);
                b[x][y] = (byte)(values[index] & 0xFF);
                ++index;
            }
        }
        this.toIndexedColor(r, g, b);
    }

    void toIndexedColor(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.pixels = new byte[this.width * this.height];
        this.colors = new byte[768];
        int colornum = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int search;
                for (search = 0; search < colornum && (this.colors[search * 3] != r[x][y] || this.colors[search * 3 + 1] != g[x][y] || this.colors[search * 3 + 2] != b[x][y]); ++search) {
                }
                if (search > 255) {
                    throw new AWTException(Strings.S.get("manyColorError"));
                }
                this.pixels[y * this.width + x] = (byte)search;
                if (search != colornum) continue;
                this.colors[search * 3] = r[x][y];
                this.colors[search * 3 + 1] = g[x][y];
                this.colors[search * 3 + 2] = b[x][y];
                ++colornum;
            }
        }
        this.numColors = 1 << BitUtils.bitsNeeded(colornum);
        byte[] copy = new byte[this.numColors * 3];
        System.arraycopy(this.colors, 0, copy, 0, this.numColors * 3);
        this.colors = copy;
    }

    public void write(OutputStream output) throws IOException {
        BitUtils.writeString(output, "GIF87a");
        ScreenDescriptor sd = new ScreenDescriptor(this.width, this.height, this.numColors);
        sd.write(output);
        output.write(this.colors, 0, this.colors.length);
        ImageDescriptor id = new ImageDescriptor(this.width, this.height, ',');
        id.write(output);
        byte codesize = BitUtils.bitsNeeded(this.numColors);
        if (codesize == 1) {
            codesize = (byte)(codesize + 1);
        }
        output.write(codesize);
        LZWCompressor.lzwCompress(output, codesize, this.pixels);
        output.write(0);
        id = new ImageDescriptor(0, 0, ';');
        id.write(output);
        output.flush();
    }

    private static class MyGrabber
    extends PixelGrabber {
        final ProgressMonitor monitor;
        int progress;
        final int goal;

        MyGrabber(ProgressMonitor monitor, Image image, int x, int y, int width, int height, int[] values, int start, int scan) {
            super(image, x, y, width, height, values, start, scan);
            this.monitor = monitor;
            this.progress = 0;
            this.goal = width * height;
            monitor.setMinimum(0);
            monitor.setMaximum(this.goal * 21 / 20);
        }

        @Override
        public void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel model, int[] pixels, int srcOff, int srcScan) {
            this.progress += srcW * srcH;
            this.monitor.setProgress(this.progress);
            if (this.monitor.isCanceled()) {
                this.abortGrabbing();
            } else {
                super.setPixels(srcX, srcY, srcW, srcH, model, pixels, srcOff, srcScan);
            }
        }
    }

    private static class BitUtils {
        private BitUtils() {
        }

        static byte bitsNeeded(int n) {
            byte ret = 1;
            if (n-- == 0) {
                return 0;
            }
            while ((n >>= 1) != 0) {
                ret = (byte)(ret + 1);
            }
            return ret;
        }

        static void writeString(OutputStream output, String string) throws IOException {
            for (int loop = 0; loop < string.length(); ++loop) {
                output.write((byte)string.charAt(loop));
            }
        }

        static void writeWord(OutputStream output, short w) throws IOException {
            output.write(w & 0xFF);
            output.write(w >> 8 & 0xFF);
        }
    }

    private static class ScreenDescriptor {
        final short localScreenWidth;
        final short localScreenHeight;
        private byte byteVal;
        final byte backgroundColorIndex;
        final byte pixelAspectRatio;

        ScreenDescriptor(short width, short height, int numColors) {
            this.localScreenWidth = width;
            this.localScreenHeight = height;
            this.setGlobalColorTableSize((byte)(BitUtils.bitsNeeded(numColors) - 1));
            this.setGlobalColorTableFlag((byte)1);
            this.setSortFlag((byte)0);
            this.setColorResolution((byte)7);
            this.backgroundColorIndex = 0;
            this.pixelAspectRatio = 0;
        }

        void setColorResolution(byte num) {
            this.byteVal = (byte)(this.byteVal | (num & 7) << 4);
        }

        void setGlobalColorTableFlag(byte num) {
            this.byteVal = (byte)(this.byteVal | (num & 1) << 7);
        }

        void setGlobalColorTableSize(byte num) {
            this.byteVal = (byte)(this.byteVal | num & 7);
        }

        void setSortFlag(byte num) {
            this.byteVal = (byte)(this.byteVal | (num & 1) << 3);
        }

        void write(OutputStream output) throws IOException {
            BitUtils.writeWord(output, this.localScreenWidth);
            BitUtils.writeWord(output, this.localScreenHeight);
            output.write(this.byteVal);
            output.write(this.backgroundColorIndex);
            output.write(this.pixelAspectRatio);
        }
    }

    private static class ImageDescriptor {
        final byte separator;
        final short leftPosition;
        final short topPosition;
        final short width;
        final short height;
        private byte byteVal;

        ImageDescriptor(short width, short height, char separator) {
            this.separator = (byte)separator;
            this.leftPosition = 0;
            this.topPosition = 0;
            this.width = width;
            this.height = height;
            this.setLocalColorTableSize((byte)0);
            this.setReserved((byte)0);
            this.setSortFlag((byte)0);
            this.setInterlaceFlag((byte)0);
            this.setLocalColorTableFlag((byte)0);
        }

        void setInterlaceFlag(byte num) {
            this.byteVal = (byte)(this.byteVal | (num & 1) << 6);
        }

        void setLocalColorTableFlag(byte num) {
            this.byteVal = (byte)(this.byteVal | (num & 1) << 7);
        }

        void setLocalColorTableSize(byte num) {
            this.byteVal = (byte)(this.byteVal | num & 7);
        }

        void setReserved(byte num) {
            this.byteVal = (byte)(this.byteVal | (num & 3) << 3);
        }

        void setSortFlag(byte num) {
            this.byteVal = (byte)(this.byteVal | (num & 1) << 5);
        }

        void write(OutputStream output) throws IOException {
            output.write(this.separator);
            BitUtils.writeWord(output, this.leftPosition);
            BitUtils.writeWord(output, this.topPosition);
            BitUtils.writeWord(output, this.width);
            BitUtils.writeWord(output, this.height);
            output.write(this.byteVal);
        }
    }

    private static class LZWCompressor {
        private LZWCompressor() {
        }

        static void lzwCompress(OutputStream output, int codesize, byte[] toCompress) throws IOException {
            short prefix = -1;
            int clearcode = 1 << codesize;
            int endofinfo = clearcode + 1;
            int numbits = codesize + 1;
            int limit = (1 << numbits) - 1;
            LZWStringTable strings = new LZWStringTable();
            strings.clearTable(codesize);
            BitFile bitFile = new BitFile(output);
            bitFile.writeBits(clearcode, numbits);
            for (byte compress : toCompress) {
                byte c = compress;
                short index = strings.findCharString(prefix, c);
                if (index != -1) {
                    prefix = index;
                    continue;
                }
                bitFile.writeBits(prefix, numbits);
                if (strings.addCharString(prefix, c) > limit) {
                    if (++numbits > 12) {
                        bitFile.writeBits(clearcode, numbits - 1);
                        strings.clearTable(codesize);
                        numbits = codesize + 1;
                    }
                    limit = (1 << numbits) - 1;
                }
                prefix = (short)((short)c & 0xFF);
            }
            if (prefix != -1) {
                bitFile.writeBits(prefix, numbits);
            }
            bitFile.writeBits(endofinfo, numbits);
            bitFile.flush();
        }
    }

    private static class LZWStringTable {
        private static final int RES_CODES = 2;
        private static final short HASH_FREE = -1;
        private static final short NEXT_FIRST = -1;
        private static final int MAXBITS = 12;
        private static final int MAXSTR = 4096;
        private static final short HASHSIZE = 9973;
        private static final short HASHSTEP = 2039;
        final byte[] strChr = new byte[4096];
        final short[] strNext = new short[4096];
        final short[] strHash = new short[9973];
        short numStrings;

        static int hash(short index, byte lastbyte) {
            return (((short)(lastbyte << 8) ^ index) & 0xFFFF) % 9973;
        }

        LZWStringTable() {
        }

        int addCharString(short index, byte b) {
            if (this.numStrings >= 4096) {
                return 65535;
            }
            int hshidx = LZWStringTable.hash((short)index, b);
            while (this.strHash[hshidx] != -1) {
                hshidx = (hshidx + 2039) % 9973;
            }
            this.strHash[hshidx] = this.numStrings;
            this.strChr[this.numStrings] = b;
            this.strNext[this.numStrings] = index != -1 ? index : -1;
            short s = this.numStrings;
            this.numStrings = (short)(s + 1);
            return s;
        }

        void clearTable(int codesize) {
            this.numStrings = 0;
            for (int q = 0; q < 9973; ++q) {
                this.strHash[q] = -1;
            }
            int w = (1 << codesize) + 2;
            for (int q = 0; q < w; ++q) {
                this.addCharString((short)-1, (byte)q);
            }
        }

        short findCharString(short index, byte b) {
            short nextIndex;
            if (index == -1) {
                return b;
            }
            int hashIndex = LZWStringTable.hash(index, b);
            while ((nextIndex = this.strHash[hashIndex]) != -1) {
                if (this.strNext[nextIndex] == index && this.strChr[nextIndex] == b) {
                    return nextIndex;
                }
                hashIndex = (hashIndex + 2039) % 9973;
            }
            return -1;
        }
    }

    private static class BitFile {
        final OutputStream outputStream;
        final byte[] buffer;
        int index;
        int bitsLeft;

        BitFile(OutputStream output) {
            this.outputStream = output;
            this.buffer = new byte[256];
            this.index = 0;
            this.bitsLeft = 8;
        }

        void flush() throws IOException {
            int numBytes = this.index + (this.bitsLeft == 8 ? 0 : 1);
            if (numBytes > 0) {
                this.outputStream.write(numBytes);
                this.outputStream.write(this.buffer, 0, numBytes);
                this.buffer[0] = 0;
                this.index = 0;
                this.bitsLeft = 8;
            }
        }

        void writeBits(int bits, int numbits) throws IOException {
            int numBytes = 255;
            do {
                if (this.index == 254 && this.bitsLeft == 0 || this.index > 254) {
                    this.outputStream.write(numBytes);
                    this.outputStream.write(this.buffer, 0, numBytes);
                    this.buffer[0] = 0;
                    this.index = 0;
                    this.bitsLeft = 8;
                }
                if (numbits <= this.bitsLeft) {
                    int n = this.index;
                    this.buffer[n] = (byte)(this.buffer[n] | (bits & (1 << numbits) - 1) << 8 - this.bitsLeft);
                    this.bitsLeft -= numbits;
                    numbits = 0;
                    continue;
                }
                int n = this.index++;
                this.buffer[n] = (byte)(this.buffer[n] | (bits & (1 << this.bitsLeft) - 1) << 8 - this.bitsLeft);
                bits >>= this.bitsLeft;
                numbits -= this.bitsLeft;
                this.buffer[this.index] = 0;
                this.bitsLeft = 8;
            } while (numbits != 0);
        }
    }
}

