/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.IteratorUtil;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <E> List<E> createUnmodifiableListUnion(List<? extends E> a, List<? extends E> b) {
        return new UnionList<E>(a, b);
    }

    public static <E> Set<E> createUnmodifiableSetUnion(Set<? extends E> a, Set<? extends E> b) {
        return new UnionSet<E>(a, b);
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    private static class UnionList<E>
    extends AbstractList<E> {
        private final List<? extends E> listA;
        private final List<? extends E> listB;

        UnionList(List<? extends E> a, List<? extends E> b) {
            this.listA = a;
            this.listB = b;
        }

        @Override
        public E get(int index) {
            E ret = index < this.listA.size() ? this.listA.get(index) : this.listA.get(index - this.listA.size());
            return ret;
        }

        @Override
        public int size() {
            return this.listA.size() + this.listB.size();
        }
    }

    private static class UnionSet<E>
    extends AbstractSet<E> {
        private final Set<? extends E> setA;
        private final Set<? extends E> setB;

        UnionSet(Set<? extends E> a, Set<? extends E> b) {
            this.setA = a;
            this.setB = b;
        }

        @Override
        public Iterator<E> iterator() {
            return IteratorUtil.createJoinedIterator(this.setA.iterator(), this.setB.iterator());
        }

        @Override
        public int size() {
            return this.setA.size() + this.setB.size();
        }
    }
}

