/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentListener;
import com.cburch.logisim.soc.data.SocSupport;
import java.util.ArrayList;

public interface CircuitStateHolder {
    public void setCircuitState(CircuitState var1);

    public void setHierarchyName(HierarchyInfo var1);

    public static class HierarchyInfo {
        private final Circuit mainCircuit;
        private final ArrayList<Component> components = new ArrayList();

        public HierarchyInfo(Circuit circ) {
            this.mainCircuit = circ;
        }

        public void addComponent(Component comp) {
            this.components.add(comp);
        }

        public void registerCircuitListener(CircuitListener l) {
            if (this.mainCircuit != null) {
                this.mainCircuit.addCircuitListener(l);
            }
            for (Component c : this.components) {
                ComponentFactory componentFactory = c.getFactory();
                if (!(componentFactory instanceof SubcircuitFactory)) continue;
                SubcircuitFactory f = (SubcircuitFactory)componentFactory;
                f.getSubcircuit().addCircuitListener(l);
            }
        }

        public void deregisterCircuitListener(CircuitListener l) {
            if (this.mainCircuit != null) {
                this.mainCircuit.addCircuitListener(l);
            }
            for (Component c : this.components) {
                ComponentFactory componentFactory = c.getFactory();
                if (!(componentFactory instanceof SubcircuitFactory)) continue;
                SubcircuitFactory f = (SubcircuitFactory)componentFactory;
                f.getSubcircuit().removeCircuitListener(l);
            }
        }

        public void registerComponentListener(ComponentListener l) {
            for (Component c : this.components) {
                c.addComponentListener(l);
            }
        }

        public void deregisterComponentListener(ComponentListener l) {
            for (Component c : this.components) {
                c.addComponentListener(l);
            }
        }

        public String getName() {
            StringBuilder s = new StringBuilder();
            if (this.mainCircuit != null) {
                s.append(this.mainCircuit.getName());
            }
            for (Component c : this.components) {
                if (s.length() != 0) {
                    s.append(":");
                }
                s.append(SocSupport.getComponentName(c));
            }
            return s.toString();
        }

        public HierarchyInfo getCopy() {
            HierarchyInfo copy = new HierarchyInfo(this.mainCircuit);
            for (Component c : this.components) {
                copy.addComponent(c);
            }
            return copy;
        }
    }
}

