/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.ttl.ClockState;
import java.util.Arrays;

public class TtlRegisterData
extends ClockState
implements InstanceData {
    private final Value[] values;
    private final BitWidth bits;

    public TtlRegisterData(BitWidth width, int depth) {
        this.values = new Value[depth];
        Arrays.fill(this.values, AppPreferences.Memory_Startup_Unknown.get() != false ? Value.createUnknown(width) : Value.createKnown(width, 0L));
        this.bits = width;
    }

    public TtlRegisterData(BitWidth width) {
        this(width, 1);
    }

    public void setValue(int i, Value value) {
        this.values[i] = value;
    }

    public void setValue(Value value) {
        this.setValue(0, value);
    }

    public Value getValue(int i) {
        return this.values[i];
    }

    public Value getValue() {
        return this.getValue(0);
    }

    public BitWidth getWidth() {
        return this.bits;
    }
}

