/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import java.util.ArrayList;
import java.util.Arrays;

public class Ttl74181
extends AbstractTtlGate {
    public static final String _ID = "74181";
    public static final int DELAY = 1;
    public static final byte A0 = 2;
    public static final byte A1 = 23;
    public static final byte A2 = 21;
    public static final byte A3 = 19;
    public static final byte B0 = 1;
    public static final byte B1 = 22;
    public static final byte B2 = 20;
    public static final byte B3 = 18;
    public static final byte F0 = 9;
    public static final byte F1 = 10;
    public static final byte F2 = 11;
    public static final byte F3 = 13;
    public static final byte S0 = 6;
    public static final byte S1 = 5;
    public static final byte S2 = 4;
    public static final byte S3 = 3;
    public static final byte Ci = 7;
    public static final byte M = 8;
    public static final byte AeqB = 14;
    public static final byte Co = 16;
    public static final byte P = 15;
    public static final byte G = 17;
    public static final byte GND = 12;
    public static final byte VCC = 24;
    private InstanceState _state;

    public Ttl74181() {
        super(_ID, (byte)24, new byte[]{9, 10, 11, 13, 16, 14, 15, 17}, new String[]{"B0", "A0", "S3", "S2", "S1", "S0", "nCi", "M", "F0", "F1", "F2", "F3", "A=B", "Pn", "Co", "Gn", "B3", "A3", "B2", "A2", "B1", "A1"}, null);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        int label_len_max = 4;
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.portNames) {
            String[] tmp = name.split("\\s+");
            names.add(tmp[0].length() <= 4 ? tmp[0] : tmp[0].substring(0, 4));
        }
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, names.toArray(new String[0]));
    }

    protected byte pinNrToPortNr(byte dsPinNr) {
        return (byte)(dsPinNr <= 12 ? dsPinNr - 1 : dsPinNr - 2);
    }

    private boolean getPort(byte dsPinNr) {
        return this._state.getPortValue(this.pinNrToPortNr(dsPinNr)) == Value.TRUE;
    }

    private void setPort(byte dsPinNr, boolean b) {
        this._state.setPort(this.pinNrToPortNr(dsPinNr), b ? Value.TRUE : Value.FALSE, 1);
    }

    private boolean pal32L1(ArrayList<Boolean> in, int[] products) {
        boolean or = false;
        for (int i = 0; i < products.length && !or; ++i) {
            int product = products[i];
            boolean and = true;
            for (int j = 0; j < 32 && and; ++j) {
                if ((product & 1 << j) == 0) continue;
                and = in.get(j);
            }
            or = and;
        }
        return !or;
    }

    @Override
    public void propagateTtl(InstanceState state) {
        this._state = state;
        final ArrayList<Boolean> a = new ArrayList<Boolean>(Arrays.asList(this.getPort((byte)2), this.getPort((byte)23), this.getPort((byte)21), this.getPort((byte)19)));
        final ArrayList<Boolean> b = new ArrayList<Boolean>(Arrays.asList(this.getPort((byte)1), this.getPort((byte)22), this.getPort((byte)20), this.getPort((byte)18)));
        final ArrayList<Boolean> bn = new ArrayList<Boolean>(b.stream().map(x -> x == false).toList());
        final ArrayList<Boolean> s = new ArrayList<Boolean>(Arrays.asList(this.getPort((byte)6), this.getPort((byte)5), this.getPort((byte)4), this.getPort((byte)3)));
        final boolean ci = this.getPort((byte)7);
        final boolean m = this.getPort((byte)8);
        ArrayList<Boolean> level1 = new ArrayList<Boolean>(this){
            final /* synthetic */ Ttl74181 this$0;
            {
                this.this$0 = this$0;
                this.addAll(a);
                this.addAll(b);
                this.addAll(bn);
                this.addAll(s);
            }
        };
        final ArrayList<Boolean> x2 = new ArrayList<Boolean>(Arrays.asList(this.pal32L1(level1, new int[]{32785, 16641}), this.pal32L1(level1, new int[]{32802, 16898}), this.pal32L1(level1, new int[]{32836, 17412}), this.pal32L1(level1, new int[]{32904, 18440})));
        final ArrayList<Boolean> y = new ArrayList<Boolean>(Arrays.asList(this.pal32L1(level1, new int[]{8448, 4112, 1}), this.pal32L1(level1, new int[]{8704, 4128, 2}), this.pal32L1(level1, new int[]{9216, 4160, 4}), this.pal32L1(level1, new int[]{10240, 4224, 8})));
        ArrayList<Boolean> level2 = new ArrayList<Boolean>(this){
            final /* synthetic */ Ttl74181 this$0;
            {
                this.this$0 = this$0;
                this.addAll(x2);
                this.addAll(y);
                this.add(!m);
                this.add(ci);
            }
        };
        ArrayList<Boolean> z = new ArrayList<Boolean>(Arrays.asList(this.pal32L1(level2, new int[]{768}), this.pal32L1(level2, new int[]{769, 272}), this.pal32L1(level2, new int[]{771, 274, 288}), this.pal32L1(level2, new int[]{775, 278, 292, 320})));
        boolean p = this.pal32L1(level2, new int[]{15});
        boolean g = this.pal32L1(level2, new int[]{128, 72, 44, 30});
        boolean co = !this.pal32L1(level2, new int[]{527}) || !g;
        boolean eq = a.get(0) == b.get(0) && a.get(1) == b.get(1) && a.get(2) == b.get(2) && a.get(3) == b.get(3);
        boolean f0 = x2.get(0) ^ y.get(0) ^ z.get(0);
        boolean f1 = x2.get(1) ^ y.get(1) ^ z.get(1);
        boolean f2 = x2.get(2) ^ y.get(2) ^ z.get(2);
        boolean f3 = x2.get(3) ^ y.get(3) ^ z.get(3);
        this.setPort((byte)15, p);
        this.setPort((byte)17, g);
        this.setPort((byte)16, co);
        this.setPort((byte)14, eq);
        this.setPort((byte)13, f3);
        this.setPort((byte)11, f2);
        this.setPort((byte)10, f1);
        this.setPort((byte)9, f0);
    }
}

