/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import java.util.ArrayList;

public class Ttl74139
extends AbstractTtlGate {
    public static final String _ID = "74139";
    public static final byte L1_nEN = 1;
    public static final byte L1_A = 2;
    public static final byte L1_B = 3;
    public static final byte L1_nY0 = 4;
    public static final byte L1_nY1 = 5;
    public static final byte L1_nY2 = 6;
    public static final byte L1_nY3 = 7;
    public static final byte GND = 8;
    public static final byte L2_nY3 = 9;
    public static final byte L2_nY2 = 10;
    public static final byte L2_nY1 = 11;
    public static final byte L2_nY0 = 12;
    public static final byte L2_B = 13;
    public static final byte L2_A = 14;
    public static final byte L2_nEN = 15;
    public static final byte VCC = 16;
    public static final int DELAY = 1;

    public Ttl74139() {
        super(_ID, (byte)16, new byte[]{4, 5, 6, 7, 12, 11, 10, 9}, new String[]{"1nG Enable (active LOW)", "1A", "1B", "1nY0", "1nY1", "1nY2", "1nY3", "2nY3", "2nY2", "2nY1", "2nY0", "2B", "2A", "2nG Enable (active LOW)"}, null);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        int label_len_max = 4;
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.portNames) {
            String[] tmp = name.split("\\s+");
            names.add(tmp[0].length() <= 4 ? tmp[0] : tmp[0].substring(0, 4));
        }
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, names.toArray(new String[0]));
    }

    protected byte mapPort(byte dsIdx) {
        return (byte)(dsIdx <= 8 ? dsIdx - 1 : dsIdx - 2);
    }

    protected void computeState(InstanceState state, byte inEn, byte inA, byte inB, byte[] outPorts) {
        boolean enabled = state.getPortValue(this.mapPort(inEn)) == Value.FALSE;
        int A = state.getPortValue(this.mapPort(inA)) == Value.TRUE ? 1 : 0;
        int B = state.getPortValue(this.mapPort(inB)) == Value.TRUE ? 2 : 0;
        int[][] outputPortStates = new int[][]{{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}};
        for (int i = 0; i < 4; ++i) {
            Value val = enabled ? (outputPortStates[A + B][i] == 0 ? Value.TRUE : Value.FALSE) : Value.TRUE;
            state.setPort(this.mapPort(outPorts[i]), val, 1);
        }
    }

    @Override
    public void propagateTtl(InstanceState state) {
        byte[] out1 = new byte[]{4, 5, 6, 7};
        this.computeState(state, (byte)1, (byte)2, (byte)3, out1);
        byte[] out2 = new byte[]{12, 11, 10, 9};
        this.computeState(state, (byte)15, (byte)14, (byte)13, out2);
    }
}

