/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.Ttl7410HdlGenerator;
import java.awt.Graphics;

public class Ttl7410
extends AbstractTtlGate {
    public static final String _ID = "7410";
    private boolean inverted = true;
    private boolean isAND = true;
    private static final byte pinCount = 14;
    private static final byte[] outPorts = new byte[]{6, 8, 12};

    public Ttl7410() {
        super(_ID, (byte)14, outPorts, new Ttl7410HdlGenerator(true, true));
    }

    public Ttl7410(String val, boolean inverted) {
        super(val, (byte)14, outPorts, new Ttl7410HdlGenerator(inverted, true));
        this.inverted = inverted;
    }

    public Ttl7410(String val, boolean inverted, boolean isOR) {
        super(val, (byte)14, outPorts, new Ttl7410HdlGenerator(inverted, !isOR));
        this.inverted = inverted;
        this.isAND = !isOR;
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        int LineOffset;
        super.paintBase(painter, false, false);
        Graphics g = painter.getGraphics();
        int n = LineOffset = !this.isAND & AppPreferences.GATE_SHAPE.get().equals("shaped") ? -4 : 0;
        if (this.isAND) {
            Drawgates.paintAnd(g, x + 45, y + 20, 10, 10, this.inverted);
            Drawgates.paintAnd(g, x + 125, y + 20, 10, 10, this.inverted);
            Drawgates.paintAnd(g, x + 105, y + 40, 10, 10, this.inverted);
        } else {
            Drawgates.paintOr(g, x + 45, y + 20, 10, 10, this.inverted, false);
            Drawgates.paintOr(g, x + 125, y + 20, 10, 10, this.inverted, false);
            Drawgates.paintOr(g, x + 105, y + 40, 10, 10, this.inverted, false);
        }
        int offset = this.inverted ? 0 : -4;
        int[] xpos = new int[]{x + 49 + offset, x + 50, x + 50};
        int[] ypos = new int[]{y + 20, y + 20, y + 7};
        g.drawPolyline(xpos, ypos, 3);
        xpos[0] = x + 129 + offset;
        xpos[1] = xpos[2] = x + 130;
        g.drawPolyline(xpos, ypos, 3);
        xpos[0] = x + 109 + offset;
        xpos[1] = xpos[2] = x + 110;
        ypos[0] = ypos[1] = y + 40;
        ypos[2] = y + height - 7;
        g.drawPolyline(xpos, ypos, 3);
        xpos = new int[]{x + 30, x + 30, x + 35 + LineOffset};
        ypos = new int[]{y + 7, y + 17, y + 17};
        g.drawPolyline(xpos, ypos, 3);
        xpos = new int[]{x + 10, x + 10, x + 35 + LineOffset};
        ypos = new int[]{y + height - 7, y + 20, y + 20};
        g.drawPolyline(xpos, ypos, 3);
        xpos = new int[]{x + 30, x + 30, x + 35 + LineOffset};
        ypos = new int[]{y + height - 7, y + 23, y + 23};
        g.drawPolyline(xpos, ypos, 3);
        for (int i = 0; i < 3; ++i) {
            xpos = new int[]{x + 70 + i * 20, x + 70 + i * 20, x + 115 + LineOffset};
            ypos = new int[]{y + 7, y + 23 - i * 3, y + 23 - i * 3};
            g.drawPolyline(xpos, ypos, 3);
            xpos = new int[]{x + 50 + i * 20, x + 50 + i * 20, x + 95 + LineOffset};
            ypos = new int[]{y + height - 7, y + 37 + i * 3, y + 37 + i * 3};
            g.drawPolyline(xpos, ypos, 3);
        }
    }

    @Override
    public void propagateTtl(InstanceState state) {
        Value val = this.isAND ? state.getPortValue(2).and(state.getPortValue(3).and(state.getPortValue(4))) : state.getPortValue(2).or(state.getPortValue(3).or(state.getPortValue(4)));
        state.setPort(5, this.inverted ? val.not() : val, 2);
        val = this.isAND ? state.getPortValue(0).and(state.getPortValue(1).and(state.getPortValue(11))) : state.getPortValue(0).or(state.getPortValue(1).or(state.getPortValue(11)));
        state.setPort(10, this.inverted ? val.not() : val, 2);
        val = this.isAND ? state.getPortValue(7).and(state.getPortValue(8).and(state.getPortValue(9))) : state.getPortValue(7).or(state.getPortValue(8).or(state.getPortValue(9)));
        state.setPort(6, this.inverted ? val.not() : val, 2);
    }
}

