/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.MemState;
import com.cburch.logisim.std.memory.Ram;
import com.cburch.logisim.std.memory.RamAttributes;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class RamAppearance {
    public static int getNrAddrPorts(AttributeSet attrs) {
        return 1;
    }

    public static int getNrDataInPorts(AttributeSet attrs) {
        if (!RamAppearance.seperatedBus(attrs)) {
            return 0;
        }
        return RamAppearance.getNrDataOutPorts(attrs);
    }

    public static int getNrDataOutPorts(AttributeSet attrs) {
        if (!attrs.containsAttribute(Mem.ENABLES_ATTR) || attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) {
            if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.DUAL)) {
                return 2;
            }
            if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.QUAD)) {
                return 4;
            }
            if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.OCTO)) {
                return 8;
            }
        }
        return 1;
    }

    public static int getNrDataPorts(AttributeSet attrs) {
        return RamAppearance.getNrDataInPorts(attrs) + RamAppearance.getNrDataOutPorts(attrs);
    }

    public static int getNrOEPorts(AttributeSet attrs) {
        if (!attrs.containsAttribute(Mem.ENABLES_ATTR)) {
            return 0;
        }
        if (!RamAppearance.seperatedBus(attrs) || RamAppearance.seperatedBus(attrs) && attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USEBYTEENABLES)) {
            return 1;
        }
        return 0;
    }

    public static int getNrWEPorts(AttributeSet attrs) {
        if (!attrs.containsAttribute(Mem.ENABLES_ATTR)) {
            return 0;
        }
        return 1;
    }

    public static int getNrClkPorts(AttributeSet attrs) {
        boolean async;
        if (!attrs.containsAttribute(Mem.ENABLES_ATTR)) {
            return 0;
        }
        boolean bl = async = !RamAppearance.synchronous(attrs);
        if (async && attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USEBYTEENABLES)) {
            return 0;
        }
        return 1;
    }

    public static int getNrLEPorts(AttributeSet attrs) {
        if (!attrs.containsAttribute(Mem.ENABLES_ATTR)) {
            return 0;
        }
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) {
            if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.DUAL)) {
                return 2;
            }
            if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.QUAD)) {
                return 4;
            }
            if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.OCTO)) {
                return 8;
            }
        }
        return 0;
    }

    public static int getNrBEPorts(AttributeSet attrs) {
        boolean async;
        if (!attrs.containsAttribute(Mem.ENABLES_ATTR)) {
            return 0;
        }
        boolean bl = async = !RamAppearance.synchronous(attrs);
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USEBYTEENABLES) && attrs.getValue(RamAttributes.ATTR_ByteEnables).equals(RamAttributes.BUS_WITH_BYTEENABLES) && !async) {
            int nrBits = attrs.getValue(Mem.DATA_ATTR).getWidth();
            return nrBits < 9 ? 0 : nrBits + 7 >> 3;
        }
        return 0;
    }

    public static int getNrClrPorts(AttributeSet attrs) {
        return attrs.containsAttribute(RamAttributes.CLEAR_PIN) && attrs.getValue(RamAttributes.CLEAR_PIN) != false ? 1 : 0;
    }

    public static int getNrOfPorts(AttributeSet attrs) {
        return RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataPorts(attrs) + RamAppearance.getNrOEPorts(attrs) + RamAppearance.getNrWEPorts(attrs) + RamAppearance.getNrClkPorts(attrs) + RamAppearance.getNrLEPorts(attrs) + RamAppearance.getNrBEPorts(attrs) + RamAppearance.getNrClrPorts(attrs);
    }

    public static int getAddrIndex(int portIndex, AttributeSet attrs) {
        return portIndex == 0 ? 0 : -1;
    }

    public static int getDataInIndex(int portIndex, AttributeSet attrs) {
        if (!RamAppearance.seperatedBus(attrs)) {
            return RamAppearance.getDataOutIndex(portIndex, attrs);
        }
        int portOffset = RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataOutPorts(attrs);
        return RamAppearance.getDataOffset(portOffset, portIndex, attrs);
    }

    public static int getDataOutIndex(int portIndex, AttributeSet attrs) {
        int portOffset = RamAppearance.getNrAddrPorts(attrs);
        return RamAppearance.getDataOffset(portOffset, portIndex, attrs);
    }

    public static int getOEIndex(int portIndex, AttributeSet attrs) {
        int portOffset = RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataPorts(attrs);
        int nrOEs = RamAppearance.getNrOEPorts(attrs);
        if (nrOEs == 0 || portIndex < 0) {
            return -1;
        }
        if (portIndex < nrOEs) {
            return portOffset + portIndex;
        }
        return -1;
    }

    public static int getWEIndex(int portIndex, AttributeSet attrs) {
        int portOffset = RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataPorts(attrs) + RamAppearance.getNrOEPorts(attrs);
        int nrWEs = RamAppearance.getNrWEPorts(attrs);
        if (nrWEs == 0 || portIndex < 0) {
            return -1;
        }
        if (portIndex < nrWEs) {
            return portOffset + portIndex;
        }
        return -1;
    }

    public static int getClkIndex(int portIndex, AttributeSet attrs) {
        int portOffset = RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataPorts(attrs) + RamAppearance.getNrOEPorts(attrs) + RamAppearance.getNrWEPorts(attrs);
        if (RamAppearance.getNrClkPorts(attrs) == 0 || portIndex != 0) {
            return -1;
        }
        return portOffset;
    }

    public static int getLEIndex(int portIndex, AttributeSet attrs) {
        int portOffset = RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataPorts(attrs) + RamAppearance.getNrOEPorts(attrs) + RamAppearance.getNrWEPorts(attrs) + RamAppearance.getNrClkPorts(attrs);
        int nrLEs = RamAppearance.getNrLEPorts(attrs);
        if (nrLEs == 0 || portIndex < 0) {
            return -1;
        }
        if (portIndex < nrLEs) {
            return portOffset + portIndex;
        }
        return -1;
    }

    public static int getBEIndex(int portIndex, AttributeSet attrs) {
        int portOffset = RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataPorts(attrs) + RamAppearance.getNrOEPorts(attrs) + RamAppearance.getNrWEPorts(attrs) + RamAppearance.getNrClkPorts(attrs) + RamAppearance.getNrLEPorts(attrs);
        int nrBEs = RamAppearance.getNrBEPorts(attrs);
        if (nrBEs == 0 || portIndex < 0) {
            return -1;
        }
        if (portIndex < nrBEs) {
            return portOffset + portIndex;
        }
        return -1;
    }

    public static int getClrIndex(int portIndex, AttributeSet attrs) {
        int portOffset = RamAppearance.getNrAddrPorts(attrs) + RamAppearance.getNrDataPorts(attrs) + RamAppearance.getNrOEPorts(attrs) + RamAppearance.getNrWEPorts(attrs) + RamAppearance.getNrClkPorts(attrs) + RamAppearance.getNrLEPorts(attrs) + RamAppearance.getNrBEPorts(attrs);
        int nrClrs = RamAppearance.getNrClrPorts(attrs);
        if (nrClrs == 0 || portIndex < 0) {
            return -1;
        }
        if (portIndex < nrClrs) {
            return portOffset + portIndex;
        }
        return -1;
    }

    public static void configurePorts(Instance instance) {
        int i;
        AttributeSet attrs = instance.getAttributeSet();
        Port[] ps = new Port[RamAppearance.getNrOfPorts(attrs)];
        for (i = 0; i < RamAppearance.getNrAddrPorts(attrs); ++i) {
            ps[RamAppearance.getAddrIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getAddrPort(i, attrs);
        }
        for (i = 0; i < RamAppearance.getNrDataInPorts(attrs); ++i) {
            ps[RamAppearance.getDataInIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getDataInPort(i, attrs);
        }
        for (i = 0; i < RamAppearance.getNrDataOutPorts(attrs); ++i) {
            ps[RamAppearance.getDataOutIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getDataOutPort(i, attrs, instance.getBounds().getWidth());
        }
        for (i = 0; i < RamAppearance.getNrOEPorts(attrs); ++i) {
            ps[RamAppearance.getOEIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getOEPort(i, attrs);
        }
        for (i = 0; i < RamAppearance.getNrWEPorts(attrs); ++i) {
            ps[RamAppearance.getWEIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getWEPort(i, attrs);
        }
        for (i = 0; i < RamAppearance.getNrClkPorts(attrs); ++i) {
            ps[RamAppearance.getClkIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getClkPort(i, attrs);
        }
        for (i = 0; i < RamAppearance.getNrLEPorts(attrs); ++i) {
            ps[RamAppearance.getLEIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getLEPort(i, attrs);
        }
        for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
            ps[RamAppearance.getBEIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getBEPort(i, attrs);
        }
        for (i = 0; i < RamAppearance.getNrClrPorts(attrs); ++i) {
            ps[RamAppearance.getClrIndex((int)i, (AttributeSet)attrs)] = RamAppearance.getClrPort(i, attrs);
        }
        instance.setPorts(ps);
    }

    public static Bounds getBounds(AttributeSet attrs) {
        int xoffset;
        int n = xoffset = RamAppearance.seperatedBus(attrs) ? 40 : 50;
        if (RamAppearance.classicAppearance(attrs)) {
            int len = Math.max(64, (RamAppearance.getNrLEPorts(attrs) + 1) * 10);
            return Bounds.create(0, 0, 240, RamAppearance.getControlHeight(attrs) + len);
        }
        int len = Math.max(attrs.getValue(Mem.DATA_ATTR).getWidth() * 20, (RamAppearance.getNrLEPorts(attrs) + 1) * 10);
        return Bounds.create(0, 0, 200 + xoffset, RamAppearance.getControlHeight(attrs) + len);
    }

    public static boolean classicAppearance(AttributeSet attrs) {
        return attrs.getValue(StdAttr.APPEARANCE).equals(StdAttr.APPEAR_CLASSIC);
    }

    public static void drawRamClassic(InstancePainter painter) {
        MemState state;
        AttributeSet attrs = painter.getAttributeSet();
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        Instance inst = painter.getInstance();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        String Label = painter.getAttributeValue(StdAttr.LABEL);
        if (Label != null && painter.getAttributeValue(StdAttr.LABEL_VISIBILITY).booleanValue()) {
            Font font = g.getFont();
            g.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
            GraphicsUtil.drawCenteredText(g, Label, bds.getX() + bds.getWidth() / 2, bds.getY() - g.getFont().getSize());
            g.setFont(font);
        }
        painter.drawBounds();
        RamAppearance.drawConnections(inst, attrs, painter);
        String type = inst.getFactory() instanceof Ram ? "RAM " : "ROM ";
        GraphicsUtil.drawCenteredText(g, type + Mem.getSizeLabel(painter.getAttributeValue(Mem.ADDR_ATTR).getWidth()) + " x " + painter.getAttributeValue(Mem.DATA_ATTR).getWidth(), bds.getX() + 100 + 20, bds.getY() + 6);
        if (painter.getShowState() && (state = (MemState)inst.getData(painter.getCircuitState())) != null) {
            state.paint(painter.getGraphics(), bds.getX(), bds.getY(), 30, 15, bds.getWidth() - 60, bds.getHeight() - 20, RamAppearance.getNrToHighlight(attrs));
        }
    }

    public static void drawRamEvolution(InstancePainter painter) {
        MemState state;
        AttributeSet attrs = painter.getAttributeSet();
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        Instance inst = painter.getInstance();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        String Label = painter.getAttributeValue(StdAttr.LABEL);
        if (Label != null && painter.getAttributeValue(StdAttr.LABEL_VISIBILITY).booleanValue()) {
            Font font = g.getFont();
            g.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
            GraphicsUtil.drawCenteredText(g, Label, bds.getX() + bds.getWidth() / 2, bds.getY() - g.getFont().getSize());
            g.setFont(font);
        }
        RamAppearance.drawControlBlock(inst, attrs, painter);
        RamAppearance.drawDataBlocks(inst, attrs, painter);
        RamAppearance.drawConnections(inst, attrs, painter);
        String type = inst.getFactory() instanceof Ram ? "RAM " : "ROM ";
        GraphicsUtil.drawCenteredText(g, type + Mem.getSizeLabel(painter.getAttributeValue(Mem.ADDR_ATTR).getWidth()) + " x " + painter.getAttributeValue(Mem.DATA_ATTR).getWidth(), bds.getX() + 100 + 20, bds.getY() + 6);
        if (painter.getShowState() && (state = (MemState)inst.getData(painter.getCircuitState())) != null) {
            state.paint(painter.getGraphics(), bds.getX(), bds.getY(), 50, RamAppearance.getControlHeight(attrs) + 5, bds.getWidth() - 100, bds.getHeight() - 10 - RamAppearance.getControlHeight(attrs), RamAppearance.getNrToHighlight(attrs));
        }
    }

    public static int getControlHeight(AttributeSet attrs) {
        int result = 60;
        if (attrs.containsAttribute(Mem.ENABLES_ATTR) && attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) {
            if (!RamAppearance.classicAppearance(attrs)) {
                result += 30;
            }
            result += RamAppearance.getNrLEPorts(attrs) * 10;
        } else if (attrs.containsAttribute(StdAttr.TRIGGER)) {
            boolean async = !RamAppearance.synchronous(attrs);
            result += 20;
            if (!async) {
                result += 10;
            }
            result += RamAppearance.getNrBEPorts(attrs) * 10;
        }
        return result;
    }

    private static int getNrToHighlight(AttributeSet attrs) {
        if (attrs.containsAttribute(Mem.ENABLES_ATTR) && attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USEBYTEENABLES)) {
            return 1;
        }
        if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.DUAL)) {
            return 2;
        }
        if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.QUAD)) {
            return 4;
        }
        if (attrs.getValue(Mem.LINE_ATTR).equals(Mem.OCTO)) {
            return 8;
        }
        return 1;
    }

    private static int getDataOffset(int portOffset, int portIndex, AttributeSet attrs) {
        switch (portIndex) {
            case 0: {
                return portOffset;
            }
            case 1: {
                if (!(attrs.containsAttribute(Mem.ENABLES_ATTR) && !attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES) || attrs.getValue(Mem.LINE_ATTR).equals(Mem.SINGLE))) {
                    return portOffset + 1;
                }
                return -1;
            }
            case 2: 
            case 3: {
                if ((!attrs.containsAttribute(Mem.ENABLES_ATTR) || attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) && (attrs.getValue(Mem.LINE_ATTR).equals(Mem.QUAD) || attrs.getValue(Mem.LINE_ATTR).equals(Mem.OCTO))) {
                    return portOffset + portIndex;
                }
                return -1;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if ((!attrs.containsAttribute(Mem.ENABLES_ATTR) || attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) && attrs.getValue(Mem.LINE_ATTR).equals(Mem.OCTO)) {
                    return portOffset + portIndex;
                }
                return -1;
            }
        }
        return -1;
    }

    private static Port getAddrPort(int portIndex, AttributeSet attrs) {
        Port result = new Port(0, 10, "input", attrs.getValue(Mem.ADDR_ATTR));
        result.setToolTip(Strings.S.getter("memAddrTip"));
        return result;
    }

    private static Port getDataInPort(int portIndex, AttributeSet attrs) {
        int nrDins = RamAppearance.getNrDataInPorts(attrs);
        if (nrDins == 0 || portIndex < 0) {
            return null;
        }
        if (portIndex >= nrDins) {
            return null;
        }
        int ypos = RamAppearance.getControlHeight(attrs);
        boolean classic = RamAppearance.classicAppearance(attrs);
        BitWidth bits = attrs.getValue(Mem.DATA_ATTR);
        if (!classic && bits.getWidth() == 1) {
            ypos += 10;
        }
        Port result = new Port(0, ypos += portIndex * 10, "input", bits);
        switch (portIndex) {
            case 0: {
                if (nrDins == 1) {
                    result.setToolTip(Strings.S.getter("ramInTip"));
                    break;
                }
                result.setToolTip(Strings.S.getter("ramInTip0"));
                break;
            }
            case 1: {
                result.setToolTip(Strings.S.getter("ramInTip1"));
                break;
            }
            case 2: {
                result.setToolTip(Strings.S.getter("ramInTip2"));
                break;
            }
            case 3: {
                result.setToolTip(Strings.S.getter("ramInTip3"));
                break;
            }
        }
        return result;
    }

    private static Port getDataOutPort(int portIndex, AttributeSet attrs, int xpos) {
        int nrDouts = RamAppearance.getNrDataOutPorts(attrs);
        if (nrDouts == 0 || portIndex < 0) {
            return null;
        }
        if (portIndex >= nrDouts) {
            return null;
        }
        int ypos = RamAppearance.getControlHeight(attrs);
        String portType = "output";
        if (!RamAppearance.seperatedBus(attrs) && attrs.containsAttribute(Mem.ENABLES_ATTR)) {
            portType = "inout";
        }
        boolean classic = RamAppearance.classicAppearance(attrs);
        BitWidth bits = attrs.getValue(Mem.DATA_ATTR);
        if (!classic && bits.getWidth() == 1) {
            ypos += 10;
        }
        Port result = new Port(xpos, ypos += portIndex * 10, portType, bits);
        switch (portIndex) {
            case 0: {
                if (nrDouts == 1) {
                    result.setToolTip(Strings.S.getter("memDataTip"));
                    break;
                }
                result.setToolTip(Strings.S.getter("memDataTip0"));
                break;
            }
            case 1: {
                result.setToolTip(Strings.S.getter("memDataTip1"));
                break;
            }
            case 2: {
                result.setToolTip(Strings.S.getter("memDataTip2"));
                break;
            }
            case 3: {
                result.setToolTip(Strings.S.getter("memDataTip3"));
                break;
            }
        }
        return result;
    }

    private static Port getOEPort(int portIndex, AttributeSet attrs) {
        int nrOEs = RamAppearance.getNrOEPorts(attrs);
        if (nrOEs == 0 || portIndex < 0) {
            return null;
        }
        if (portIndex >= nrOEs) {
            return null;
        }
        int ypos = 60;
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES) && RamAppearance.classicAppearance(attrs)) {
            ypos = 20;
        }
        Port result = new Port(0, ypos, "input", 1);
        result.setToolTip(Strings.S.getter("ramOETip"));
        return result;
    }

    private static Port getWEPort(int portIndex, AttributeSet attrs) {
        int nrWEs = RamAppearance.getNrWEPorts(attrs);
        if (nrWEs == 0 || portIndex < 0) {
            return null;
        }
        if (portIndex >= nrWEs) {
            return null;
        }
        int ypos = 50;
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES) && RamAppearance.classicAppearance(attrs)) {
            ypos = 30;
        }
        Port result = new Port(0, ypos, "input", 1);
        result.setToolTip(Strings.S.getter("ramWETip"));
        return result;
    }

    private static Port getClkPort(int portIndex, AttributeSet attrs) {
        int nrClks = RamAppearance.getNrClkPorts(attrs);
        if (nrClks == 0 || portIndex < 0) {
            return null;
        }
        if (portIndex >= nrClks) {
            return null;
        }
        int ypos = 70;
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES) && RamAppearance.classicAppearance(attrs)) {
            ypos = 40;
        }
        ypos += RamAppearance.getNrLEPorts(attrs) * 10;
        Port result = new Port(0, ypos += RamAppearance.getNrBEPorts(attrs) * 10, "input", 1);
        result.setToolTip(Strings.S.getter("ramClkTip"));
        return result;
    }

    private static Port getLEPort(int portIndex, AttributeSet attrs) {
        int nrLEs = RamAppearance.getNrLEPorts(attrs);
        if (nrLEs == 0 || portIndex < 0) {
            return null;
        }
        if (portIndex >= nrLEs) {
            return null;
        }
        int ypos = 70;
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES) && RamAppearance.classicAppearance(attrs)) {
            ypos = 40;
        }
        Port result = new Port(0, ypos += portIndex * 10, "input", 1);
        switch (portIndex) {
            case 0: {
                result.setToolTip(Strings.S.getter("ramLETip0"));
                break;
            }
            case 1: {
                result.setToolTip(Strings.S.getter("ramLETip1"));
                break;
            }
            case 2: {
                result.setToolTip(Strings.S.getter("ramLETip2"));
                break;
            }
            case 3: {
                result.setToolTip(Strings.S.getter("ramLETip3"));
                break;
            }
        }
        return result;
    }

    private static Port getBEPort(int portIndex, AttributeSet attrs) {
        int nrBEs = RamAppearance.getNrBEPorts(attrs);
        if (nrBEs == 0 || portIndex < 0) {
            return null;
        }
        if (portIndex >= nrBEs) {
            return null;
        }
        int ypos = 70 + (nrBEs - portIndex - 1) * 10;
        Port result = new Port(0, ypos, "input", 1);
        switch (portIndex) {
            case 0: {
                result.setToolTip(Strings.S.getter("ramByteEnableTip0"));
                break;
            }
            case 1: {
                result.setToolTip(Strings.S.getter("ramByteEnableTip1"));
                break;
            }
            case 2: {
                result.setToolTip(Strings.S.getter("ramByteEnableTip2"));
                break;
            }
            case 3: {
                result.setToolTip(Strings.S.getter("ramByteEnableTip3"));
                break;
            }
        }
        return result;
    }

    private static Port getClrPort(int portIndex, AttributeSet attrs) {
        if (RamAppearance.getNrClrPorts(attrs) == 0 || portIndex != 0) {
            return null;
        }
        Port result = new Port(40, 0, "input", 1);
        result.setToolTip(Strings.S.getter("ramClrPin"));
        return result;
    }

    private static boolean seperatedBus(AttributeSet attrs) {
        AttributeOption bus = attrs.getValue(RamAttributes.ATTR_DBUS);
        return bus != null && bus.equals(RamAttributes.BUS_SEP);
    }

    private static boolean synchronous(AttributeSet attrs) {
        return attrs.containsAttribute(StdAttr.TRIGGER) && (attrs.getValue(StdAttr.TRIGGER).equals(StdAttr.TRIG_RISING) || attrs.getValue(StdAttr.TRIGGER).equals(StdAttr.TRIG_FALLING));
    }

    private static void drawConnections(Instance inst, AttributeSet attrs, InstancePainter painter) {
        int[] ypos;
        int y;
        int idx;
        String label;
        int i;
        boolean classic = RamAppearance.classicAppearance(attrs);
        Graphics2D g = (Graphics2D)painter.getGraphics().create();
        Font font = g.getFont();
        g.setStroke(new BasicStroke(4.0f));
        int nrOfBits = attrs.getValue(Mem.DATA_ATTR).getWidth();
        int nrOfDataPorts = Math.max(RamAppearance.getNrDataInPorts(attrs), RamAppearance.getNrDataOutPorts(attrs));
        for (i = 0; i < RamAppearance.getNrDataInPorts(attrs); ++i) {
            label = !classic ? "" : (RamAppearance.getNrDataInPorts(attrs) == 1 ? "D" : "D" + i);
            idx = RamAppearance.getDataInIndex(i, attrs);
            if (!classic) {
                Location loc = inst.getPortLocation(idx);
                int x = loc.getX();
                y = loc.getY();
                if (nrOfBits == 1) {
                    g.setStroke(new BasicStroke(2.0f));
                    if (nrOfDataPorts > 1) {
                        xpos = new int[4];
                        ypos = new int[4];
                        xpos[0] = x;
                        xpos[1] = xpos[2] = x + 4 + i * 4;
                        xpos[3] = x + 20;
                        ypos[0] = ypos[1] = y;
                        ypos[2] = ypos[3] = y - (i + 1) * 6;
                        g.drawPolyline(xpos, ypos, 4);
                    } else {
                        g.drawLine(x, y, x + 20, y);
                    }
                    g.setStroke(new BasicStroke(4.0f));
                } else if (i != 0) {
                    if (i == 3 && nrOfBits == 2) {
                        g.drawLine(loc.getX(), loc.getY(), loc.getX() + 4, loc.getY() - 4);
                    } else {
                        g.drawLine(loc.getX(), loc.getY(), loc.getX() + 4, loc.getY() + 4);
                    }
                } else {
                    xpos = new int[3];
                    ypos = new int[3];
                    g.setStroke(new BasicStroke(2.0f));
                    xpos[0] = x + 5;
                    xpos[1] = x + 10;
                    xpos[2] = x + 20;
                    ypos[0] = y + 5;
                    ypos[1] = ypos[2] = y + 10;
                    g.setFont(font.deriveFont(7.0f));
                    g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
                    for (int j = 0; j < nrOfBits; ++j) {
                        g.drawPolyline(xpos, ypos, 3);
                        GraphicsUtil.drawText(g, Integer.toString(j), xpos[2] - 3, ypos[2] - 3, 1, 1);
                        ypos[0] = ypos[0] + 20;
                        ypos[1] = ypos[1] + 20;
                        ypos[2] = ypos[2] + 20;
                    }
                    g.setColor(Value.multiColor);
                    g.setStroke(new BasicStroke(4.0f));
                    xpos[0] = x;
                    xpos[1] = xpos[2] = x + 5;
                    ypos[0] = y;
                    ypos[1] = y + 5;
                    ypos[2] = y + 5 + (nrOfBits - 1) * 20;
                    g.drawPolyline(xpos, ypos, 3);
                }
            }
            painter.drawPort(idx, label, Direction.EAST);
        }
        for (i = 0; i < RamAppearance.getNrDataOutPorts(attrs); ++i) {
            label = !classic ? "" : (RamAppearance.getNrDataOutPorts(attrs) == 1 ? "D" : "D" + i);
            idx = RamAppearance.getDataOutIndex(i, attrs);
            if (!classic) {
                boolean seperate = RamAppearance.seperatedBus(attrs) || !attrs.containsAttribute(RamAttributes.ATTR_DBUS);
                Location loc = inst.getPortLocation(idx);
                int x = loc.getX();
                int y2 = loc.getY();
                if (nrOfBits == 1) {
                    g.setStroke(new BasicStroke(2.0f));
                    if (nrOfDataPorts > 1) {
                        xpos = new int[4];
                        ypos = new int[4];
                        xpos[0] = x;
                        xpos[1] = xpos[2] = x - (i + 1) * 4;
                        xpos[3] = x - 20;
                        ypos[0] = ypos[1] = y2;
                        ypos[2] = ypos[3] = y2 - (i + 1) * 6;
                        g.drawPolyline(xpos, ypos, 4);
                    } else {
                        g.drawLine(x, y2, x - 20, y2);
                    }
                    if (!seperate && i == 0) {
                        RamAppearance.drawBidir(g, x - 20, y2);
                    }
                    g.setStroke(new BasicStroke(4.0f));
                } else if (i != 0) {
                    if (i == 3 && nrOfBits == 2) {
                        g.drawLine(x - 4, y2 - 4, x, y2);
                    } else {
                        g.drawLine(x - 4, y2 + 4, x, y2);
                    }
                } else {
                    xpos = new int[3];
                    ypos = new int[3];
                    g.setStroke(new BasicStroke(2.0f));
                    xpos[0] = x - 5;
                    xpos[1] = x - 10;
                    xpos[2] = x - 20;
                    ypos[0] = y2 + 5;
                    ypos[1] = ypos[2] = y2 + 10;
                    g.setFont(font.deriveFont(7.0f));
                    g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
                    for (int j = 0; j < nrOfBits; ++j) {
                        g.drawPolyline(xpos, ypos, 3);
                        GraphicsUtil.drawText(g, Integer.toString(j), xpos[2] + 3, ypos[2] - 3, -1, 1);
                        if (!seperate) {
                            RamAppearance.drawBidir(g, xpos[2], ypos[2]);
                        }
                        ypos[0] = ypos[0] + 20;
                        ypos[1] = ypos[1] + 20;
                        ypos[2] = ypos[2] + 20;
                    }
                    g.setStroke(new BasicStroke(4.0f));
                    g.setColor(Value.multiColor);
                    xpos[0] = x;
                    xpos[1] = xpos[2] = x - 5;
                    ypos[0] = y2;
                    ypos[1] = y2 + 5;
                    ypos[2] = y2 + 5 + (nrOfBits - 1) * 20;
                    g.drawPolyline(xpos, ypos, 3);
                }
            }
            painter.drawPort(idx, label, Direction.WEST);
        }
        for (i = 0; i < RamAppearance.getNrAddrPorts(attrs); ++i) {
            label = !classic ? "" : (RamAppearance.getNrAddrPorts(attrs) == 1 ? "A" : "A" + i);
            idx = RamAppearance.getAddrIndex(i, attrs);
            if (!classic) {
                Location loc = inst.getPortLocation(idx);
                int x = loc.getX();
                y = loc.getY();
                int[] xpos = new int[3];
                ypos = new int[3];
                g.setStroke(new BasicStroke(2.0f));
                g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
                xpos[0] = x + 5;
                xpos[1] = x + 10;
                xpos[2] = x + 20;
                ypos[0] = y + 5;
                ypos[1] = ypos[2] = y + 10;
                g.drawPolyline(xpos, ypos, 3);
                for (int j = 0; j < 3; ++j) {
                    int n = j;
                    ypos[n] = ypos[n] + 20;
                    if (attrs.getValue(Mem.ADDR_ATTR).getWidth() <= 2) continue;
                    g.drawLine(x + 15, y + 13 + j * 6, x + 15, y + 15 + j * 6);
                }
                g.drawPolyline(xpos, ypos, 3);
                g.setColor(Value.multiColor);
                g.setStroke(new BasicStroke(4.0f));
                xpos[0] = x;
                xpos[1] = xpos[2] = x + 5;
                ypos[0] = y;
                ypos[1] = y + 5;
                ypos[2] = y + 25;
                g.drawPolyline(xpos, ypos, 3);
            }
            painter.drawPort(idx, label, Direction.EAST);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.setStroke(new BasicStroke(2.0f));
        for (i = 0; i < RamAppearance.getNrOEPorts(attrs); ++i) {
            label = !classic ? "" : (RamAppearance.getNrOEPorts(attrs) == 1 ? "OE" : "OE" + i);
            idx = RamAppearance.getOEIndex(i, attrs);
            if (!classic) {
                Location loc = inst.getPortLocation(idx);
                g.drawLine(loc.getX(), loc.getY(), loc.getX() + 20, loc.getY());
            }
            painter.drawPort(idx, label, Direction.EAST);
        }
        for (i = 0; i < RamAppearance.getNrWEPorts(attrs); ++i) {
            label = !classic ? "" : (RamAppearance.getNrWEPorts(attrs) == 1 ? "WE" : "WE" + i);
            idx = RamAppearance.getWEIndex(i, attrs);
            if (!classic) {
                Location loc = inst.getPortLocation(idx);
                g.drawLine(loc.getX(), loc.getY(), loc.getX() + 20, loc.getY());
            }
            painter.drawPort(idx, label, Direction.EAST);
        }
        for (i = 0; i < RamAppearance.getNrClkPorts(attrs); ++i) {
            idx = RamAppearance.getClkIndex(i, attrs);
            if (!classic) {
                Location loc = inst.getPortLocation(idx);
                int xend = 20;
                if (attrs.getValue(StdAttr.TRIGGER).equals(StdAttr.TRIG_FALLING) || attrs.getValue(StdAttr.TRIGGER).equals(StdAttr.TRIG_LOW)) {
                    xend -= 8;
                    g.drawOval(loc.getX() + 12, loc.getY() - 4, 8, 8);
                }
                g.drawLine(loc.getX(), loc.getY(), loc.getX() + xend, loc.getY());
                if (RamAppearance.synchronous(attrs)) {
                    painter.drawClockSymbol(loc.getX() + 20, loc.getY());
                }
                painter.drawPort(idx);
                continue;
            }
            if (RamAppearance.synchronous(attrs)) {
                painter.drawClock(idx, Direction.EAST);
                continue;
            }
            painter.drawPort(idx, (String)(RamAppearance.getNrClkPorts(attrs) == 1 ? "E" : "E" + i), Direction.EAST);
        }
        for (i = 0; i < RamAppearance.getNrLEPorts(attrs); ++i) {
            label = !classic ? "" : (RamAppearance.getNrLEPorts(attrs) == 1 ? "LE" : "LE" + i);
            idx = RamAppearance.getLEIndex(i, attrs);
            if (!classic) {
                Location loc = inst.getPortLocation(idx);
                g.drawLine(loc.getX(), loc.getY(), loc.getX() + 20, loc.getY());
            }
            painter.drawPort(idx, label, Direction.EAST);
        }
        for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
            label = !classic ? "" : (RamAppearance.getNrBEPorts(attrs) == 1 ? "BE" : "BE" + i);
            idx = RamAppearance.getBEIndex(i, attrs);
            if (!classic) {
                Location loc = inst.getPortLocation(idx);
                g.drawLine(loc.getX(), loc.getY(), loc.getX() + 20, loc.getY());
            }
            painter.drawPort(idx, label, Direction.EAST);
        }
        for (i = 0; i < RamAppearance.getNrClrPorts(attrs); ++i) {
            idx = RamAppearance.getClrIndex(i, attrs);
            painter.drawPort(idx);
        }
        g.dispose();
    }

    private static void drawControlBlock(Instance inst, AttributeSet attrs, InstancePainter painter) {
        String label;
        Location loc;
        int i;
        Graphics2D g = (Graphics2D)painter.getGraphics().create();
        int[] xpos = new int[8];
        int[] ypos = new int[8];
        int x = painter.getBounds().getX();
        int y = painter.getBounds().getY();
        xpos[0] = xpos[1] = x + 30;
        xpos[2] = xpos[3] = x + 20;
        xpos[4] = xpos[5] = x + 200 + 20;
        xpos[6] = xpos[7] = x + 200 + 10;
        ypos[0] = ypos[7] = y + RamAppearance.getControlHeight(attrs);
        ypos[5] = ypos[6] = ypos[0] - 10;
        ypos[2] = ypos[6];
        ypos[1] = ypos[6];
        ypos[3] = ypos[4] = y;
        GraphicsUtil.switchToWidth(g, 2);
        g.drawPolyline(xpos, ypos, 8);
        for (int i2 = 0; i2 < RamAppearance.getNrAddrPorts(attrs); ++i2) {
            int idx = RamAppearance.getAddrIndex(i2, attrs);
            Location loc2 = inst.getPortLocation(idx);
            RamAppearance.drawAddress(g, loc2.getX(), loc2.getY(), attrs.getValue(Mem.ADDR_ATTR).getWidth());
        }
        int cidx = 1;
        for (i = 0; i < RamAppearance.getNrClkPorts(attrs); ++i) {
            int idx = RamAppearance.getClkIndex(i, attrs);
            loc = inst.getPortLocation(idx);
            label = RamAppearance.synchronous(attrs) ? "C" + cidx : "E" + cidx;
            ++cidx;
            g.drawString(label, loc.getX() + 33, loc.getY() + 5);
        }
        for (i = 0; i < RamAppearance.getNrOEPorts(attrs); ++i) {
            int idx = RamAppearance.getOEIndex(i, attrs);
            loc = inst.getPortLocation(idx);
            label = "M" + cidx + " [Output enable]";
            ++cidx;
            g.drawString(label, loc.getX() + 33, loc.getY() + 5);
        }
        for (i = 0; i < RamAppearance.getNrWEPorts(attrs); ++i) {
            int idx = RamAppearance.getWEIndex(i, attrs);
            loc = inst.getPortLocation(idx);
            label = "M" + cidx + " [Write enable]";
            ++cidx;
            g.drawString(label, loc.getX() + 33, loc.getY() + 5);
        }
        for (i = 0; i < RamAppearance.getNrLEPorts(attrs); ++i) {
            int idx = RamAppearance.getLEIndex(i, attrs);
            loc = inst.getPortLocation(idx);
            label = "M" + cidx + " [Line enable " + i + "]";
            ++cidx;
            g.drawString(label, loc.getX() + 33, loc.getY() + 5);
        }
        for (i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
            int idx = RamAppearance.getBEIndex(i, attrs);
            loc = inst.getPortLocation(idx);
            label = "M" + cidx + " [Byte enable " + i + "]";
            ++cidx;
            g.drawString(label, loc.getX() + 33, loc.getY() + 5);
        }
        g.dispose();
    }

    private static void drawDataBlocks(Instance inst, AttributeSet attrs, InstancePainter painter) {
        int i;
        Graphics2D g = (Graphics2D)painter.getGraphics().create();
        int x = painter.getBounds().getX() + 20;
        int y = painter.getBounds().getY() + RamAppearance.getControlHeight(attrs);
        int width = 200;
        int height = 20;
        g.setFont(g.getFont().deriveFont(9.0f));
        int nrOfBits = attrs.getValue(Mem.DATA_ATTR).getWidth();
        StringBuilder doutLabel = new StringBuilder();
        StringBuilder dinLabel = new StringBuilder();
        doutLabel.append("A");
        dinLabel.append("A");
        int cidx = 1;
        boolean async = !RamAppearance.synchronous(attrs) || attrs.containsAttribute(Mem.ASYNC_READ) && attrs.getValue(Mem.ASYNC_READ) != false;
        boolean drawDin = attrs.containsAttribute(RamAttributes.ATTR_DBUS);
        boolean seperate = RamAppearance.seperatedBus(attrs) || !drawDin;
        for (i = 0; i < RamAppearance.getNrClkPorts(attrs); ++i) {
            if (!async) {
                doutLabel.append(",").append(cidx);
            }
            dinLabel.append(",").append(cidx);
            ++cidx;
        }
        for (i = 0; i < RamAppearance.getNrOEPorts(attrs); ++i) {
            doutLabel.append(",").append(cidx);
            ++cidx;
        }
        for (i = 0; i < RamAppearance.getNrWEPorts(attrs); ++i) {
            dinLabel.append(",").append(cidx);
            ++cidx;
        }
        for (i = 0; i < RamAppearance.getNrLEPorts(attrs); ++i) {
            dinLabel.append(",").append(cidx);
            ++cidx;
        }
        boolean appendBE = RamAppearance.getNrBEPorts(attrs) > 0;
        String DLabel = seperate ? "" : "D";
        for (int i2 = 0; i2 < nrOfBits; ++i2) {
            g.setStroke(new BasicStroke(2.0f));
            g.drawRect(x, y, 200, 20);
            g.setStroke(new BasicStroke(1.0f));
            GraphicsUtil.drawText(g, doutLabel.toString(), x - (seperate ? 3 : 10) + 200, y + (seperate ? 10 : 5), 1, 0);
            if (!seperate) {
                int[] xpos = new int[3];
                int[] ypos = new int[3];
                xpos[0] = x - 8 + 200;
                xpos[1] = x - 5 + 200;
                xpos[2] = x - 2 + 200;
                ypos[0] = ypos[2] = y + 5;
                ypos[1] = y + 8;
                g.drawPolygon(xpos, ypos, 3);
            }
            Object BEIndex = "";
            if (appendBE) {
                int beIdx = cidx + (i2 >> 3);
                BEIndex = "," + beIdx;
            }
            if (drawDin) {
                GraphicsUtil.drawText(g, String.valueOf(dinLabel) + (String)BEIndex + DLabel, x + (seperate ? 3 : 197), y + (seperate ? 10 : 13), seperate ? -1 : 1, 0);
            }
            y += 20;
        }
        g.dispose();
    }

    private static void drawBidir(Graphics2D g, int x, int y) {
        int[] xpos = new int[4];
        int[] ypos = new int[4];
        xpos[0] = xpos[3] = x - 10;
        xpos[1] = xpos[2] = x;
        ypos[0] = ypos[1] = y - 5;
        ypos[2] = ypos[3] = y + 5;
        g.drawPolyline(xpos, ypos, 4);
        xpos[0] = xpos[2] = x - 4;
        xpos[1] = x - 8;
        ypos[0] = y + 2;
        ypos[1] = y + 5;
        ypos[2] = y + 8;
        g.drawPolyline(xpos, ypos, 3);
        xpos[0] = xpos[2] = x - 6;
        xpos[1] = x - 2;
        ypos[0] = y - 8;
        ypos[1] = y - 5;
        ypos[2] = y - 2;
        g.drawPolyline(xpos, ypos, 3);
    }

    private static void drawAddress(Graphics2D g, int xpos, int ypos, int nrAddressBits) {
        GraphicsUtil.switchToWidth(g, 1);
        GraphicsUtil.drawText(g, "0", xpos + 22, ypos + 10, -1, 0);
        GraphicsUtil.drawText(g, Integer.toString(nrAddressBits - 1), xpos + 22, ypos + 30, -1, 0);
        GraphicsUtil.drawText(g, "A", xpos + 50, ypos + 20, -1, 0);
        g.drawLine(xpos + 40, ypos + 5, xpos + 45, ypos + 10);
        g.drawLine(xpos + 45, ypos + 10, xpos + 45, ypos + 17);
        g.drawLine(xpos + 45, ypos + 17, xpos + 48, ypos + 20);
        g.drawLine(xpos + 48, ypos + 20, xpos + 45, ypos + 23);
        g.drawLine(xpos + 45, ypos + 23, xpos + 45, ypos + 30);
        g.drawLine(xpos + 40, ypos + 35, xpos + 45, ypos + 30);
        String size = Long.toString((1 << nrAddressBits) - 1);
        Font font = g.getFont();
        FontMetrics fm = g.getFontMetrics(font);
        int StrSize = fm.stringWidth(size);
        g.drawLine(xpos + 60, ypos + 20, xpos + 60 + StrSize, ypos + 20);
        GraphicsUtil.drawText(g, "0", xpos + 60 + StrSize / 2, ypos + 19, 0, 2);
        GraphicsUtil.drawText(g, size, xpos + 60 + StrSize / 2, ypos + 21, 0, -1);
    }
}

